/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.rewardbetaadapter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.mediation.Adapter;
import com.google.android.gms.ads.mediation.InitializationCompleteCallback;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationConfiguration;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.mediation.VersionInfo;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.configfiles.ConfigFiles;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.mintegral.msdk.system.a;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AdmobNewRewardVideoAdapter
extends Adapter
implements MediationRewardedAd,
RewardVideoListener {
    private MTGRewardVideoHandler mMvRewardVideoHandler;
    private String mAPPID = "";
    private String mAPPKey = "";
    private String mRewardUnitId = "";
    private String mRewardId = "1";
    private String mUserId = "";
    private String TAG = "testnewreward";
    static boolean hasInitMintegralSDK = false;
    MediationAdLoadCallback admobLoadListener;
    private MediationRewardedAdCallback mMediationRewardedAdCallback;
    private HashMap<String, MTGRewardVideoHandler> unitArray = new HashMap();

    public void initialize(Context context, InitializationCompleteCallback initializationCompleteCallback, List<MediationConfiguration> list) {
        Log.e((String)this.TAG, (String)"initialize: ");
        for (MediationConfiguration configuration : list) {
            Bundle serverParameters = configuration.getServerParameters();
            String serviceString = serverParameters.getString("parameter");
            if (TextUtils.isEmpty((CharSequence)serviceString)) continue;
            this.parseServiceString(context, serviceString);
        }
        if (TextUtils.isEmpty((CharSequence)this.mAPPID) || TextUtils.isEmpty((CharSequence)this.mAPPKey)) {
            initializationCompleteCallback.onInitializationFailed("mintegral appid or appkey is null");
            return;
        }
        AdapterTools.addChannel();
        if (!hasInitMintegralSDK) {
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(this.mAPPID, this.mAPPKey);
            sdk.init(map, context.getApplicationContext());
            hasInitMintegralSDK = true;
            Log.e((String)this.TAG, (String)("hasInitMintegralSDK:" + hasInitMintegralSDK));
        }
        initializationCompleteCallback.onInitializationSucceeded();
    }

    public VersionInfo getVersionInfo() {
        Log.e((String)this.TAG, (String)"getVersionInfo: ");
        String[] splits = ConfigFiles.VERSION_CODE.split("\\.");
        int major = Integer.parseInt(splits[0]);
        int minor = Integer.parseInt(splits[1]);
        int micro = Integer.parseInt(splits[2]);
        return new VersionInfo(major, minor, micro);
    }

    public VersionInfo getSDKVersionInfo() {
        Log.e((String)this.TAG, (String)"getSDKVersionInfo: ");
        return null;
    }

    public void showAd(Context context) {
        Log.e((String)this.TAG, (String)"showAd: ");
        if (this.mMvRewardVideoHandler != null) {
            this.mMvRewardVideoHandler.show(this.mRewardId, this.mUserId);
        }
    }

    public void loadRewardedAd(MediationRewardedAdConfiguration configuration, MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mediationAdLoadCallback) {
        Log.e((String)this.TAG, (String)"loadRewardedAd: ");
        Context context = configuration.getContext();
        this.admobLoadListener = mediationAdLoadCallback;
        Bundle serverParameters = configuration.getServerParameters();
        String serviceString = serverParameters.getString("parameter");
        if (!TextUtils.isEmpty((CharSequence)serviceString)) {
            this.parseServiceString(context, serviceString);
        }
        if (TextUtils.isEmpty((CharSequence)this.mAPPID) || TextUtils.isEmpty((CharSequence)this.mAPPKey) || TextUtils.isEmpty((CharSequence)this.mRewardId)) {
            mediationAdLoadCallback.onFailure("mintegral appid or appkey or unitid is null");
            return;
        }
        if (!hasInitMintegralSDK) {
            AdapterTools.addChannel();
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(this.mAPPID, this.mAPPKey);
            sdk.init(map, context.getApplicationContext());
            hasInitMintegralSDK = true;
            Log.e((String)this.TAG, (String)("hasInitMintegralSDK:" + hasInitMintegralSDK));
        }
        if (this.unitArray.containsKey(this.mRewardUnitId)) {
            this.mMvRewardVideoHandler = this.unitArray.get(this.mRewardUnitId);
        } else {
            this.mMvRewardVideoHandler = new MTGRewardVideoHandler(context, this.mRewardUnitId);
            this.unitArray.put(this.mRewardUnitId, this.mMvRewardVideoHandler);
        }
        if (this.mMvRewardVideoHandler != null) {
            this.mMvRewardVideoHandler.setRewardVideoListener((RewardVideoListener)this);
            this.mMvRewardVideoHandler.load();
        }
    }

    private void parseServiceString(Context context, String serviceString) {
        if (TextUtils.isEmpty((CharSequence)serviceString)) {
            return;
        }
        Log.e((String)this.TAG, (String)serviceString);
        try {
            JSONObject jsonObject = new JSONObject(serviceString);
            String appId = jsonObject.optString("appId");
            String appKey = jsonObject.optString("appKey");
            String unitId = jsonObject.optString("unitId");
            String rewardId = jsonObject.optString("rewardId");
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                this.mAPPID = appId;
            }
            if (!TextUtils.isEmpty((CharSequence)appKey)) {
                this.mAPPKey = appKey;
            }
            if (!TextUtils.isEmpty((CharSequence)unitId)) {
                this.mRewardUnitId = unitId;
            }
            if (!TextUtils.isEmpty((CharSequence)rewardId)) {
                this.mRewardId = rewardId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onVideoLoadSuccess(String s) {
        Log.e((String)this.TAG, (String)("onVideoLoadSuccess: " + s));
        if (this.admobLoadListener != null) {
            this.mMediationRewardedAdCallback = (MediationRewardedAdCallback)this.admobLoadListener.onSuccess((Object)this);
        }
    }

    public void onLoadSuccess(String s) {
        Log.e((String)this.TAG, (String)("onLoadSuccess: " + s));
    }

    public void onVideoLoadFail(String s) {
        Log.e((String)this.TAG, (String)("onVideoLoadFail: " + s));
        if (this.admobLoadListener != null) {
            this.admobLoadListener.onFailure(s);
        }
    }

    public void onAdShow() {
        if (this.mMediationRewardedAdCallback != null) {
            this.mMediationRewardedAdCallback.reportAdImpression();
            this.mMediationRewardedAdCallback.onAdOpened();
            this.mMediationRewardedAdCallback.onVideoStart();
        }
    }

    public void onAdClose(boolean b, String s, float v) {
        Log.e((String)this.TAG, (String)("onAdClose: " + b));
        if (this.mMediationRewardedAdCallback != null) {
            if (b) {
                this.mMediationRewardedAdCallback.onUserEarnedReward(new RewardItem(){

                    public String getType() {
                        return "";
                    }

                    public int getAmount() {
                        return 1;
                    }
                });
            }
            this.mMediationRewardedAdCallback.onAdClosed();
        }
    }

    public void onShowFail(String s) {
        Log.e((String)this.TAG, (String)("onShowFail: " + s));
        if (this.mMediationRewardedAdCallback != null) {
            this.mMediationRewardedAdCallback.onAdFailedToShow(s);
        }
    }

    public void onVideoAdClicked(String s) {
        if (this.mMediationRewardedAdCallback != null) {
            this.mMediationRewardedAdCallback.reportAdClicked();
        }
    }

    public void onVideoComplete(String s) {
        if (this.mMediationRewardedAdCallback != null) {
            this.mMediationRewardedAdCallback.onVideoComplete();
        }
    }

    public void onEndcardShow(String s) {
    }
}

