/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.rewardadapter;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdAdapter;
import com.google.android.gms.ads.reward.mediation.MediationRewardedVideoAdListener;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.rewardadapter.MediationRewardVideoEventForwarder;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGRewardVideoHandler;
import com.mintegral.msdk.out.RewardVideoListener;
import com.mintegral.msdk.system.a;
import java.util.Map;
import org.json.JSONObject;

public class MTGToAdmobRewardVideoAdapter
implements MediationRewardedVideoAdAdapter {
    private String TAG = "MTGToAdmobRewardVideoAdapter";
    private MTGRewardVideoHandler mMvRewardVideoHandler;
    private String mAPPID = "";
    private String mAPPKey = "";
    private String mRewardUnitId = "";
    private String mRewardId = "";
    private String mUserId = "";
    static boolean hasInitMintegralSDK;
    private MediationRewardVideoEventForwarder mediationRewardVideoEventForwarder;

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    private void parseAuthority(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
    }

    private void parseServiceString(Context context, String serviceString) {
        if (TextUtils.isEmpty((CharSequence)serviceString)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(serviceString);
            String appId = jsonObject.optString("appId");
            String appKey = jsonObject.optString("appKey");
            String unitId = jsonObject.optString("unitId");
            String rewardId = jsonObject.optString("rewardId");
            if (!TextUtils.isEmpty((CharSequence)appId)) {
                this.mAPPID = appId;
            }
            if (!TextUtils.isEmpty((CharSequence)appKey)) {
                this.mAPPKey = appKey;
            }
            if (!TextUtils.isEmpty((CharSequence)unitId)) {
                this.mRewardUnitId = unitId;
            }
            if (!TextUtils.isEmpty((CharSequence)rewardId)) {
                this.mRewardId = rewardId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initialize(Context context, MediationAdRequest mediationAdRequest, String s, MediationRewardedVideoAdListener mediationRewardedVideoAdListener, Bundle bundle, Bundle bundle1) {
        String serviceString = bundle.getString("parameter");
        this.parseServiceString(context, serviceString);
        if (bundle1 != null && !TextUtils.isEmpty((CharSequence)bundle1.getCharSequence("userId"))) {
            this.mUserId = bundle1.getCharSequence("userId").toString();
        }
        if (TextUtils.isEmpty((CharSequence)this.mAPPID) || TextUtils.isEmpty((CharSequence)this.mAPPKey)) {
            mediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        AdapterTools.addChannel();
        this.initSDK(context);
        if (!(context instanceof Activity)) {
            mediationRewardedVideoAdListener.onInitializationFailed((MediationRewardedVideoAdAdapter)this, 1);
            return;
        }
        this.mMvRewardVideoHandler = new MTGRewardVideoHandler((Context)((Activity)context), this.mRewardUnitId);
        this.mediationRewardVideoEventForwarder = new MediationRewardVideoEventForwarder(mediationRewardedVideoAdListener, this);
        this.mMvRewardVideoHandler.setRewardVideoListener((RewardVideoListener)this.mediationRewardVideoEventForwarder);
        mediationRewardedVideoAdListener.onInitializationSucceeded((MediationRewardedVideoAdAdapter)this);
    }

    private void initSDK(Context context) {
        if (!hasInitMintegralSDK) {
            a sdk = MIntegralSDKFactory.getMIntegralSDK();
            Map map = sdk.getMTGConfigurationMap(this.mAPPID, this.mAPPKey);
            sdk.init(map, context.getApplicationContext());
            hasInitMintegralSDK = true;
            Log.e((String)this.TAG, (String)("hasInitMintegralSDK:" + hasInitMintegralSDK));
        }
    }

    public boolean isInitialized() {
        return this.mMvRewardVideoHandler != null;
    }

    public void loadAd(MediationAdRequest mediationAdRequest, Bundle bundle, Bundle bundle1) {
        this.mMvRewardVideoHandler.load();
    }

    public void showVideo() {
        if (this.mMvRewardVideoHandler.isReady()) {
            this.mMvRewardVideoHandler.show(this.mRewardId, this.mUserId);
        }
    }

    public boolean canShow() {
        if (this.mMvRewardVideoHandler != null) {
            return this.mMvRewardVideoHandler.isReady();
        }
        return false;
    }
}

