/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.nativeadapter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.mintegral.adapter.nativeadapter.MintegralNativeMappedImage;
import com.mintegral.msdk.base.entity.CampaignEx;
import com.mintegral.msdk.nativex.view.MTGMediaView;
import com.mintegral.msdk.out.Campaign;
import com.mintegral.msdk.out.MtgNativeHandler;
import com.mintegral.msdk.out.OnMTGMediaViewListener;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MintegralNativeAppInstallAdMapper
extends NativeAppInstallAdMapper
implements OnMTGMediaViewListener {
    private final Campaign mSampleAd;
    private String TAG = ((Object)((Object)this)).getClass().getName();
    private MtgNativeHandler mNativeHandle;
    private CustomEventNativeListener mCustomEventNativeListener;

    public MintegralNativeAppInstallAdMapper(Context context, Campaign ad, MtgNativeHandler nativeHandle, CustomEventNativeListener nativeListener) {
        this.mSampleAd = ad;
        this.mCustomEventNativeListener = nativeListener;
        this.mNativeHandle = nativeHandle;
        this.setHeadline(this.mSampleAd.getAppName());
        this.setBody(this.mSampleAd.getAppDesc());
        this.setCallToAction(this.mSampleAd.getAdCall());
        this.setStarRating(this.mSampleAd.getRating());
        this.setStore(this.mSampleAd.getPackageName());
        MTGMediaView mediaView = new MTGMediaView(context);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        mediaView.setLayoutParams(layoutParams);
        mediaView.setOnMediaViewListener((OnMTGMediaViewListener)this);
        mediaView.setNativeAd(this.mSampleAd);
        ArrayList<MintegralNativeMappedImage> imagesList = new ArrayList<MintegralNativeMappedImage>();
        Uri imageUri = Uri.parse((String)this.mSampleAd.getImageUrl());
        Uri iconUri = Uri.parse((String)this.mSampleAd.getIconUrl());
        MintegralNativeMappedImage image = new MintegralNativeMappedImage(null, imageUri, 1.0);
        MintegralNativeMappedImage icon = new MintegralNativeMappedImage(null, iconUri, 1.0);
        imagesList.add(image);
        this.setImages(imagesList);
        this.setIcon(icon);
        this.setMediaView((View)mediaView);
        CampaignEx campaignEx = (CampaignEx)this.mSampleAd;
        boolean hasVideo = !TextUtils.isEmpty((CharSequence)campaignEx.getVideoUrlEncode());
        this.setHasVideoContent(hasVideo);
        this.setOverrideClickHandling(true);
        this.setOverrideImpressionRecording(false);
    }

    public void recordImpression() {
        super.recordImpression();
    }

    public void handleClick(View view) {
        super.handleClick(view);
    }

    public void trackView(View view) {
        if (view instanceof ViewGroup) {
            if (this.mNativeHandle != null) {
                this.mNativeHandle.registerView(view, this.traversalView(view), this.mSampleAd);
            }
        } else if (view instanceof View && this.mNativeHandle != null) {
            this.mNativeHandle.registerView(view, this.mSampleAd);
        }
        super.trackView(view);
    }

    public void untrackView(View view) {
        super.untrackView(view);
    }

    private List traversalView(View view) {
        ArrayList<View> viewList = new ArrayList<View>();
        if (null == view) {
            return viewList;
        }
        if (view instanceof MediaView) {
            viewList.add(view);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (viewGroup.getChildAt(i) instanceof ViewGroup) {
                    viewList.addAll(this.traversalView(viewGroup.getChildAt(i)));
                    continue;
                }
                viewList.add(viewGroup.getChildAt(i));
            }
        } else if (view instanceof View) {
            viewList.add(view);
        }
        return viewList;
    }

    public void onEnterFullscreen() {
    }

    public void onExitFullscreen() {
    }

    public void onStartRedirection(Campaign campaign, String s) {
    }

    public void onFinishRedirection(Campaign campaign, String s) {
    }

    public void onRedirectionFailed(Campaign campaign, String s) {
    }

    public void onVideoAdClicked(Campaign campaign) {
        if (this.mCustomEventNativeListener != null) {
            this.mCustomEventNativeListener.onAdClicked();
        }
    }

    public void onVideoStart() {
    }

    public static class DownloadDrawablesAsync
    extends AsyncTask<Object, Void, Boolean> {
        private ImageDownloadListener mImageDownloadListener;

        public DownloadDrawablesAsync(ImageDownloadListener listener) {
            this.mImageDownloadListener = listener;
        }

        protected Boolean doInBackground(Object ... params) {
            MintegralNativeMappedImage mapper = (MintegralNativeMappedImage)((Object)params[0]);
            ExecutorService executorService = Executors.newCachedThreadPool();
            Uri uri = mapper.getUri();
            Future<Drawable> drawableFuture = this.getDrawableFuture(uri, executorService);
            Drawable drawable = null;
            try {
                drawable = drawableFuture.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                return false;
            }
            mapper.setDrawable(drawable);
            return true;
        }

        private Future<Drawable> getDrawableFuture(final Uri uri, ExecutorService executorService) {
            return executorService.submit(new Callable<Drawable>(){

                @Override
                public Drawable call() throws Exception {
                    InputStream in = new URL(uri.toString()).openStream();
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
                    bitmap.setDensity(160);
                    return new BitmapDrawable(Resources.getSystem(), bitmap);
                }
            });
        }

        protected void onPostExecute(Boolean isDownloadSuccessful) {
            super.onPostExecute((Object)isDownloadSuccessful);
            if (isDownloadSuccessful.booleanValue()) {
                this.mImageDownloadListener.onDonwloadSuccess();
            } else {
                this.mImageDownloadListener.onDonwloadFailed();
            }
        }
    }

    public static interface ImageDownloadListener {
        public void onDonwloadSuccess();

        public void onDonwloadFailed();
    }
}

