/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.nativeadapter;

import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.mediation.NativeAppInstallAdMapper;
import com.mintegral.adapter.nativeadapter.MintegralNativeMappedImage;
import com.mintegral.msdk.out.Campaign;
import com.mintegral.msdk.out.MtgNativeHandler;
import java.util.ArrayList;
import java.util.List;

public class MintegralNativeAppInstallAdMapper
extends NativeAppInstallAdMapper {
    private final Campaign mSampleAd;
    private ImageView mInformationIconView;
    private String TAG = ((Object)((Object)this)).getClass().getName();
    private MtgNativeHandler mNativeHandle;

    public MintegralNativeAppInstallAdMapper(Campaign ad, MtgNativeHandler nativeHandle) {
        this.mSampleAd = ad;
        this.mNativeHandle = nativeHandle;
        this.setHeadline(this.mSampleAd.getAppName());
        this.setBody(this.mSampleAd.getAppDesc());
        this.setCallToAction(this.mSampleAd.getAdCall());
        this.setStarRating(this.mSampleAd.getRating());
        this.setStore(this.mSampleAd.getPackageName());
        this.setIcon(new MintegralNativeMappedImage(null, Uri.parse((String)ad.getIconUrl()), 100.0));
        ArrayList<MintegralNativeMappedImage> imagesList = new ArrayList<MintegralNativeMappedImage>();
        imagesList.add(new MintegralNativeMappedImage(null, Uri.parse((String)ad.getImageUrl()), 1000.0));
        this.setImages(imagesList);
        this.setOverrideClickHandling(true);
        this.setOverrideImpressionRecording(true);
    }

    public void recordImpression() {
        super.recordImpression();
    }

    public void handleClick(View view) {
        super.handleClick(view);
    }

    public void trackView(View view) {
        if (view instanceof ViewGroup) {
            if (this.mNativeHandle != null) {
                this.mNativeHandle.registerView(view, this.traversalView(view), this.mSampleAd);
            }
        } else if (view instanceof View && this.mNativeHandle != null) {
            this.mNativeHandle.registerView(view, this.mSampleAd);
        }
        super.trackView(view);
    }

    public void untrackView(View view) {
        super.untrackView(view);
    }

    private List traversalView(View view) {
        ArrayList<View> viewList = new ArrayList<View>();
        if (null == view) {
            return viewList;
        }
        if (view instanceof MediaView) {
            viewList.add(view);
        } else if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                if (viewGroup.getChildAt(i) instanceof ViewGroup) {
                    viewList.addAll(this.traversalView(viewGroup.getChildAt(i)));
                    continue;
                }
                viewList.add(viewGroup.getChildAt(i));
            }
        } else if (view instanceof View) {
            viewList.add(view);
        }
        return viewList;
    }
}

