/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.nativeadapter;

import android.util.Log;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventNativeListener;
import com.mintegral.adapter.nativeadapter.MintegralNativeAppInstallAdMapper;
import com.mintegral.adapter.nativeadapter.MintegralNativeContentAdMapper;
import com.mintegral.msdk.out.Campaign;
import com.mintegral.msdk.out.Frame;
import com.mintegral.msdk.out.MtgNativeHandler;
import com.mintegral.msdk.out.NativeListener;
import java.util.List;

public class CustomNativeEventForwarder
implements NativeListener.NativeAdListener {
    private static final String TAG = "CustomNativeEvent";
    private CustomEventNativeListener mNativeListener;
    private NativeMediationAdRequest mNativeMediationAdRequest;
    private MtgNativeHandler mNativeHandle;

    public CustomNativeEventForwarder(CustomEventNativeListener listener, NativeMediationAdRequest nativeMediationAdRequest, MtgNativeHandler nativeHandle) {
        this.mNativeListener = listener;
        this.mNativeMediationAdRequest = nativeMediationAdRequest;
        this.mNativeHandle = nativeHandle;
    }

    public void onAdClick(Campaign campaign) {
        if (this.mNativeListener != null) {
            this.mNativeListener.onAdOpened();
            this.mNativeListener.onAdClicked();
        }
    }

    public void onAdFramesLoaded(List<Frame> list) {
    }

    public void onLoggingImpression(int adsourceType) {
        Log.i((String)TAG, (String)("onLoggingImpression adsourceType:" + adsourceType));
        if (this.mNativeListener != null) {
            Log.i((String)TAG, (String)"onLoggingImpression onAdImpression");
            this.mNativeListener.onAdImpression();
        }
    }

    public void onAdLoaded(List<Campaign> list, int i) {
        if (list == null || list.size() == 0) {
            this.mNativeListener.onAdFailedToLoad(3);
            return;
        }
        Campaign ad = list.get(0);
        if (!this.containsRequiredAppInstallAdAssets(ad)) {
            this.mNativeListener.onAdFailedToLoad(3);
            return;
        }
        if (this.mNativeMediationAdRequest.isAppInstallAdRequested()) {
            MintegralNativeAppInstallAdMapper mapper = new MintegralNativeAppInstallAdMapper(ad, this.mNativeHandle);
            this.mNativeListener.onAdLoaded((NativeAdMapper)mapper);
            return;
        }
        if (this.mNativeMediationAdRequest.isContentAdRequested()) {
            MintegralNativeContentAdMapper mapper = new MintegralNativeContentAdMapper(ad, this.mNativeHandle);
            this.mNativeListener.onAdLoaded((NativeAdMapper)mapper);
            return;
        }
    }

    public void onAdLoadError(String s) {
        this.mNativeListener.onAdFailedToLoad(0);
    }

    private boolean containsRequiredAppInstallAdAssets(Campaign appInstallAd) {
        return appInstallAd != null && appInstallAd.getAppName() != null && appInstallAd.getAppDesc() != null && appInstallAd.getImageUrl() != null && appInstallAd.getIconUrl() != null && appInstallAd.getAdCall() != null;
    }
}

