/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.adapter.interstitialadapter;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitial;
import com.google.android.gms.ads.mediation.customevent.CustomEventInterstitialListener;
import com.mintegral.adapter.common.AdapterTools;
import com.mintegral.adapter.interstitialadapter.MintegralCustomInterstitialEventForwarder;
import com.mintegral.msdk.out.InterstitialListener;
import com.mintegral.msdk.out.MIntegralSDKFactory;
import com.mintegral.msdk.out.MTGInterstitialHandler;
import com.mintegral.msdk.system.a;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class MintegralCustomEventInterstitial
implements CustomEventInterstitial {
    private MTGInterstitialHandler mInterstitialHandler;
    private String appId = "";
    private String appKey = "";
    private String unitId = "";
    private String packageName = "";
    MintegralCustomInterstitialEventForwarder mMintegralCustomInterstitialEventForwarder;

    public void requestInterstitialAd(Context context, CustomEventInterstitialListener customEventInterstitialListener, String s, MediationAdRequest mediationAdRequest, Bundle bundle) {
        this.mMintegralCustomInterstitialEventForwarder = new MintegralCustomInterstitialEventForwarder(customEventInterstitialListener);
        this.parseServer(context, s);
        this.parseBunld(bundle);
        a sdk = MIntegralSDKFactory.getMIntegralSDK();
        if (TextUtils.isEmpty((CharSequence)this.appId) || TextUtils.isEmpty((CharSequence)this.appKey)) {
            if (this.mMintegralCustomInterstitialEventForwarder != null) {
                this.mMintegralCustomInterstitialEventForwarder.onInterstitialLoadFail("mobvista appid or appkey is null");
            }
            return;
        }
        Map map = sdk.getMTGConfigurationMap(this.appId, this.appKey);
        if (!TextUtils.isEmpty((CharSequence)this.packageName)) {
            map.put("applicationID", this.packageName);
        }
        AdapterTools.addChannel();
        sdk.init(map, context);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("unit_id", this.unitId);
        this.mInterstitialHandler = new MTGInterstitialHandler(context, hashMap);
        this.mInterstitialHandler.setInterstitialListener((InterstitialListener)this.mMintegralCustomInterstitialEventForwarder);
        this.mInterstitialHandler.preload();
    }

    private void parseServer(Context context, String s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            try {
                JSONObject jo = new JSONObject(s);
                if (jo != null) {
                    this.appId = jo.getString("appId");
                    this.appKey = jo.getString("appKey");
                    this.unitId = jo.getString("unitId");
                    AdapterTools.pareseAuthority(context, jo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void parseBunld(Bundle bundle) {
        if (bundle != null && bundle.get("packageName") != null) {
            this.packageName = bundle.get("packageName").toString();
        }
    }

    public void showInterstitial() {
        if (this.mInterstitialHandler != null) {
            this.mInterstitialHandler.show();
        }
    }

    public void onDestroy() {
    }

    public void onResume() {
    }

    public void onPause() {
    }
}

