/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.thrid.okhttp.internal.platform;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class OptionalMethod<T> {
    private final Class<?> returnType;
    private final String methodName;
    private final Class[] methodParams;

    OptionalMethod(Class<?> returnType, String methodName, Class ... methodParams) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.methodParams = methodParams;
    }

    public boolean isSupported(T target) {
        return this.getMethod(target.getClass()) != null;
    }

    public Object invokeOptional(T target, Object ... args) throws InvocationTargetException {
        Method m2 = this.getMethod(target.getClass());
        if (m2 == null) {
            return null;
        }
        try {
            return m2.invoke(target, args);
        }
        catch (IllegalAccessException e2) {
            return null;
        }
    }

    public Object invokeOptionalWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invokeOptional(target, args);
        }
        catch (InvocationTargetException e2) {
            Throwable targetException = e2.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error)).initCause(targetException);
            throw error;
        }
    }

    public Object invoke(T target, Object ... args) throws InvocationTargetException {
        Method m2 = this.getMethod(target.getClass());
        if (m2 == null) {
            throw new AssertionError((Object)("Method " + this.methodName + " not supported for object " + target));
        }
        try {
            return m2.invoke(target, args);
        }
        catch (IllegalAccessException e2) {
            AssertionError error = new AssertionError((Object)("Unexpectedly could not call: " + m2));
            ((Throwable)((Object)error)).initCause(e2);
            throw error;
        }
    }

    public Object invokeWithoutCheckedException(T target, Object ... args) {
        try {
            return this.invoke(target, args);
        }
        catch (InvocationTargetException e2) {
            Throwable targetException = e2.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            AssertionError error = new AssertionError((Object)"Unexpected exception");
            ((Throwable)((Object)error)).initCause(targetException);
            throw error;
        }
    }

    private Method getMethod(Class<?> clazz) {
        Method method = null;
        if (this.methodName != null && (method = OptionalMethod.getPublicMethod(clazz, this.methodName, this.methodParams)) != null && this.returnType != null && !this.returnType.isAssignableFrom(method.getReturnType())) {
            method = null;
        }
        return method;
    }

    private static Method getPublicMethod(Class<?> clazz, String methodName, Class[] parameterTypes) {
        Method method = null;
        try {
            method = clazz.getMethod(methodName, parameterTypes);
            if ((method.getModifiers() & 1) == 0) {
                method = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }
}

