/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.thrid.okhttp.internal.cache;

import com.mintegral.msdk.thrid.okio.Buffer;
import com.mintegral.msdk.thrid.okio.ForwardingSink;
import com.mintegral.msdk.thrid.okio.Sink;
import java.io.IOException;

class FaultHidingSink
extends ForwardingSink {
    private boolean hasErrors;

    FaultHidingSink(Sink delegate) {
        super(delegate);
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (IOException e2) {
            this.hasErrors = true;
            this.onException(e2);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e2) {
            this.hasErrors = true;
            this.onException(e2);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException e2) {
            this.hasErrors = true;
            this.onException(e2);
        }
    }

    protected void onException(IOException e2) {
    }
}

