/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.out;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.mintegral.msdk.MIntegralConstans;
import com.mintegral.msdk.appwall.service.HandlerProvider;
import com.mintegral.msdk.base.utils.g;
import com.mintegral.msdk.out.AppWallTrackingListener;
import com.mintegral.msdk.out.LoadListener;
import com.mintegral.msdk.out.MtgCommonHandler;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MtgWallHandler
extends MtgCommonHandler {
    private ViewGroup container;
    private View handlerCustomerLayout;
    private HandlerProvider wallProvider;
    private Context context;

    public MtgWallHandler(Map<String, Object> map, Context context, ViewGroup viewGroup) {
        super(map, context);
        this.context = context;
        this.setHandlerContainer(viewGroup);
    }

    public MtgWallHandler(Map<String, Object> map, Context context) {
        super(map, context);
        this.context = context;
    }

    public void refreshUI(View view) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("refresh", new Class[0]);
                method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Map<String, Object> getWallProperties(String string, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(MIntegralConstans.PLACEMENT_ID, string);
        hashMap.put("unit_id", string2);
        hashMap.put("plugin_name", new String[]{"MVWallPlugin"});
        hashMap.put("layout_type", 3);
        return hashMap;
    }

    @Override
    public boolean load() {
        if (this.properties != null && this.properties.containsKey("unit_id")) {
            this.loadAppWall();
        } else {
            g.c("", "no unit id.");
        }
        return true;
    }

    private boolean loadAppWall() {
        try {
            if (this.handlerCustomerLayout != null) {
                this.properties.put("wall_entry", this.handlerCustomerLayout);
            }
            if (this.wallProvider == null) {
                this.wallProvider = new HandlerProvider();
                this.wallProvider.insetView(this.container, null, this.properties);
            }
            this.wallProvider.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    @Override
    public void release() {
        if (this.wallProvider != null) {
            this.wallProvider.release();
        }
        if (this.container != null) {
            this.container = null;
        }
        if (this.handlerCustomerLayout != null) {
            this.handlerCustomerLayout = null;
        }
    }

    public void setWallViewBackClickListener(View view, WallViewBackClickListener wallViewBackClickListener) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("setmWallViewClickListener", WallViewBackClickListener.class);
                method.invoke(obj, wallViewBackClickListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public View getWallView(Context context, AppWallTrackingListener appWallTrackingListener) {
        if (this.properties != null && this.properties.size() > 0) {
            Object var3_3 = null;
            try {
                Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
                Constructor<?> constructor = clazz.getConstructor(Context.class, AppWallTrackingListener.class);
                var3_3 = constructor.newInstance(context, appWallTrackingListener);
                Method method = clazz.getMethod("setParamsIntent", Bundle.class);
                method.invoke(var3_3, this.getBundleFromMap(this.properties));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return var3_3;
        }
        return null;
    }

    public void releaseWallView(View view) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("destory", new Class[0]);
                method.invoke(obj, new Object[0]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.context != null) {
            this.context = null;
        }
    }

    private Bundle getBundleFromMap(Map<String, Object> map) {
        LoadListener loadListener;
        Object object;
        boolean bl;
        Object object2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string;
        int n8;
        if (map == null) {
            return null;
        }
        if (!map.containsKey("unit_id")) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("unit_id", (String)map.get("unit_id"));
        if (map.containsKey("wall_title_background_id")) {
            n8 = (Integer)map.get("wall_title_background_id");
            bundle.putInt("wall_title_background_id", n8);
        }
        if (map.containsKey("wall_title_logo_id")) {
            n8 = (Integer)map.get("wall_title_logo_id");
            bundle.putInt("wall_title_logo_id", n8);
        }
        if (map.containsKey("wall_main_background_id")) {
            n8 = (Integer)map.get("wall_main_background_id");
            bundle.putInt("wall_main_background_id", n8);
        }
        if (map.containsKey("wall_tab_background_id")) {
            n8 = (Integer)map.get("wall_tab_background_id");
            bundle.putInt("wall_tab_background_id", n8);
        }
        if (map.containsKey("wall_tab_line_background_id")) {
            n8 = (Integer)map.get("wall_tab_line_background_id");
            bundle.putInt("wall_tab_line_background_id", n8);
        }
        if (map.containsKey("wall_button_background_id")) {
            n8 = (Integer)map.get("wall_button_background_id");
            bundle.putInt("wall_button_background_id", n8);
        }
        if (map.containsKey("wall_load_id")) {
            n8 = (Integer)map.get("wall_load_id");
            bundle.putInt("wall_load_id", n8);
        }
        if (map.containsKey("wall_status_color") && (n8 = ((Integer)map.get("wall_status_color")).intValue()) > 0) {
            bundle.putInt("wall_status_color", n8);
        }
        if (map.containsKey("wall_navigation_color") && (n8 = ((Integer)map.get("wall_navigation_color")).intValue()) > 0) {
            bundle.putInt("wall_navigation_color", n8);
        }
        if (map.containsKey("wall_title_background_color") && (n8 = ((Integer)map.get("wall_title_background_color")).intValue()) > 0) {
            bundle.putInt("wall_title_background_color", n8);
        }
        if (map.containsKey("wall_title_logo_text") && !TextUtils.isEmpty((CharSequence)(string = (String)map.get("wall_title_logo_text")))) {
            bundle.putString("wall_title_logo_text", string);
        }
        if (map.containsKey("wall_title_logo_text_color") && (n7 = ((Integer)map.get("wall_title_logo_text_color")).intValue()) > 0) {
            bundle.putInt("wall_title_logo_text_color", n7);
        }
        if (map.containsKey("wall_title_logo_text_size") && (n6 = ((Integer)map.get("wall_title_logo_text_size")).intValue()) > 0) {
            bundle.putInt("wall_title_logo_text_size", n6);
        }
        if (map.containsKey("wall_title_logo_text_typeface") && (n5 = ((Integer)map.get("wall_title_logo_text_typeface")).intValue()) > 0) {
            bundle.putInt("wall_title_logo_text_typeface", n5);
        }
        if (map.containsKey("wall_current_tab_id") && (n4 = ((Integer)map.get("wall_current_tab_id")).intValue()) >= 0) {
            bundle.putInt("wall_current_tab_id", n4);
        }
        if (map.containsKey("wall_tab_shape_color") && (n3 = ((Integer)map.get("wall_tab_shape_color")).intValue()) >= 0) {
            bundle.putInt("wall_tab_shape_color", n3);
        }
        if (map.containsKey("wall_tab_shape_height") && (n2 = ((Integer)map.get("wall_tab_shape_height")).intValue()) >= 0) {
            bundle.putInt("wall_tab_shape_height", n2);
        }
        if (map.containsKey("wall_configchanges")) {
            int n9 = (Integer)map.get("wall_configchanges");
            bundle.putInt("wall_configchanges", n9);
        }
        if (map.containsKey("wall_view_viewpager_noscroll") && (object2 = map.get("wall_view_viewpager_noscroll")) instanceof Boolean) {
            bl = (Boolean)object2;
            bundle.putBoolean("wall_view_viewpager_noscroll", bl);
        }
        if (map.containsKey("wall_view_viewpager_noscroll") && (object = map.get("wall_view_viewpager_noscroll")) instanceof Boolean) {
            bl = (Boolean)object;
            bundle.putBoolean("wall_view_viewpager_noscroll", bl);
        }
        if (map.containsKey("appwall_view_load_result_listener") && (loadListener = (LoadListener)map.get("appwall_view_load_result_listener")) != null) {
            bundle.putSerializable("appwall_view_load_result_listener", (Serializable)loadListener);
        }
        return bundle;
    }

    public ViewGroup getHandlerContainer() {
        return this.container;
    }

    public void setHandlerContainer(ViewGroup viewGroup) {
        this.container = viewGroup;
    }

    public View getHandlerCustomerLayout() {
        return this.handlerCustomerLayout;
    }

    public void setHandlerCustomerLayout(View view) {
        this.handlerCustomerLayout = view;
    }

    public void setAppWallViewCampaignClickListener(View view, AppWallViewCampaignClickListener appWallViewCampaignClickListener) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("setAppWallViewCampaignClickListener", AppWallViewCampaignClickListener.class);
                method.invoke(obj, appWallViewCampaignClickListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAppWallViewNoMoreDateListener(View view, AppWallViewNoMoreDateListener appWallViewNoMoreDateListener) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("setAppWallViewNoMoreDateListener", AppWallViewNoMoreDateListener.class);
                method.invoke(obj, appWallViewNoMoreDateListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setAppWallViewLoadingEnd(View view, AppWallViewLoadingEndListener appWallViewLoadingEndListener) {
        try {
            Class<?> clazz = Class.forName("com.mintegral.msdk.appwallex.WallView");
            if (view != null && clazz.isInstance(view)) {
                Object obj = clazz.cast(view);
                Method method = clazz.getMethod("setAppWallViewLoadingEndListener", AppWallViewLoadingEndListener.class);
                method.invoke(obj, appWallViewLoadingEndListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startWall() {
        if (this.properties != null && this.properties.containsKey("unit_id")) {
            this.toShuffleOrAppwall();
        } else {
            g.c("", "no unit id.");
        }
    }

    private void toShuffleOrAppwall() {
        if (this.wallProvider == null) {
            this.wallProvider = new HandlerProvider();
        }
        this.wallProvider.startShuffleOrAppwall(this.context, this.properties);
    }

    public static interface AppWallViewLoadingEndListener {
        public void onLoadEnd();
    }

    public static interface AppWallViewNoMoreDateListener {
        public void onNoMoreData();
    }

    public static interface AppWallViewCampaignClickListener {
        public void onStartJump();

        public void onEndJump();
    }

    public static interface WallViewBackClickListener {
        public void onBackClick();
    }
}

