/*
 * Decompiled with CFR 0.152.
 */
package com.mintegral.msdk.base.utils;

import android.text.TextUtils;
import com.mintegral.msdk.base.utils.g;
import com.mintegral.msdk.system.NoProGuard;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public class CommonMD5
implements NoProGuard {
    public static final String TAG = "MD5";

    public static String getMD5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        try {
            g.a(TAG, string);
            MessageDigest messageDigest = MessageDigest.getInstance(TAG);
            messageDigest.reset();
            messageDigest.update(string.getBytes());
            return CommonMD5.HexEncode(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static String getUPMD5(String string) {
        try {
            g.a(TAG, string);
            MessageDigest messageDigest = MessageDigest.getInstance(TAG);
            messageDigest.reset();
            messageDigest.update(string.getBytes());
            return CommonMD5.UpHexEncode(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static String getQftJSMD5(String string) {
        try {
            byte[] byArray = CommonMD5.getQftJSMD5Bytes(string);
            char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
            MessageDigest messageDigest = MessageDigest.getInstance(TAG);
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            int n2 = byArray2.length;
            char[] cArray2 = new char[n2 * 2];
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by = byArray2[i2];
                cArray2[n3++] = cArray[by >>> 4 & 0xF];
                cArray2[n3++] = cArray[by & 0xF];
            }
            return new String(cArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static byte[] getQftJSMD5Bytes(String string) throws UnsupportedEncodingException {
        int n2 = string.length();
        byte[] byArray = string.getBytes("UTF-16LE");
        g.b("----", "b = " + CommonMD5.ByteArrayToHexString(byArray));
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += 2) {
            if (byArray[i2] == -1 || byArray[i2] == -2) continue;
            byArray2[n3] = byArray[i2];
            if (++n3 == n2) break;
        }
        g.b("----", "source = " + CommonMD5.ByteArrayToHexString(byArray2));
        return byArray2;
    }

    public static String ByteArrayToHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        if (byArray.length == 0) {
            return "";
        }
        int n2 = byArray.length * 2;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            byArray2[i2] = 48;
        }
        byte[] byArray3 = new byte[byArray.length + 1];
        byArray3[0] = 0;
        System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
        BigInteger bigInteger = new BigInteger(byArray3);
        byte[] byArray4 = bigInteger.toString(16).getBytes();
        int n3 = byArray2.length - byArray4.length;
        n2 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray2, n3, n2);
        return new String(byArray2);
    }

    private static String HexEncode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString((by & 0xF0) >>> 4));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        return stringBuilder.toString().toLowerCase(Locale.US);
    }

    private static String UpHexEncode(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString((by & 0xF0) >>> 4));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        return stringBuilder.toString().toUpperCase(Locale.US);
    }
}

