/*
 * Decompiled with CFR 0.152.
 */
package com.iab.omid.library.mintegral.adsession;

import android.webkit.WebView;
import com.iab.omid.library.mintegral.adsession.AdSessionContextType;
import com.iab.omid.library.mintegral.adsession.Partner;
import com.iab.omid.library.mintegral.adsession.VerificationScriptResource;
import com.iab.omid.library.mintegral.d.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AdSessionContext {
    private final Partner partner;
    private final WebView webView;
    private final List<VerificationScriptResource> verificationScriptResources = new ArrayList<VerificationScriptResource>();
    private final String omidJsScriptContent;
    private final String customReferenceData;
    private final AdSessionContextType adSessionContextType;

    private AdSessionContext(Partner partner, WebView webView, String string, List<VerificationScriptResource> list, String string2) {
        this.partner = partner;
        this.webView = webView;
        this.omidJsScriptContent = string;
        if (list != null) {
            this.verificationScriptResources.addAll(list);
            this.adSessionContextType = AdSessionContextType.NATIVE;
        } else {
            this.adSessionContextType = AdSessionContextType.HTML;
        }
        this.customReferenceData = string2;
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, String string) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string != null) {
            e.a(string, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string, List<VerificationScriptResource> list, String string2) {
        e.a(partner, "Partner is null");
        e.a((Object)string, "OM SDK JS script content is null");
        e.a(list, "VerificationScriptResources is null");
        if (string2 != null) {
            e.a(string2, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, null, string, list, string2);
    }

    public Partner getPartner() {
        return this.partner;
    }

    public List<VerificationScriptResource> getVerificationScriptResources() {
        return Collections.unmodifiableList(this.verificationScriptResources);
    }

    public WebView getWebView() {
        return this.webView;
    }

    public String getCustomReferenceData() {
        return this.customReferenceData;
    }

    public String getOmidJsScriptContent() {
        return this.omidJsScriptContent;
    }

    public AdSessionContextType getAdSessionContextType() {
        return this.adSessionContextType;
    }
}

