/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import android.support.annotation.IntRange;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.SeekBar;
import app.minimize.com.seek_bar_compat.R;
import app.minimize.com.seek_bar_compat.SeekBarBackgroundDrawable;
import java.util.concurrent.Callable;

public class SeekBarCompat
extends SeekBar
implements View.OnTouchListener {
    private static final String TAG = "SeekBarCompat";
    private int mActualBackgroundColor;
    int mThumbColor;
    int mProgressColor;
    int mProgressBackgroundColor;
    Drawable mThumb;
    int[][] states = new int[][]{{16842910}, {16842919}, {-16842910}, new int[0]};
    int[] colorsThumb = new int[]{-16777216, -16777216, -3355444, -16777216};
    int[] colorsProgress = new int[]{-16777216, -16777216, -3355444, -16777216};
    int[] colorsProgressBackground = new int[]{-16777216, -16777216, -3355444, -16777216};
    ColorStateList mColorStateListThumb;
    ColorStateList mColorStateListProgress;
    ColorStateList mColorStateListProgressBackground;
    private int mOriginalThumbHeight;
    private int mThumbAlpha = 255;
    private boolean mIsEnabled = true;
    GradientDrawable gradientDrawable = new GradientDrawable();

    public void setThumbColor(int thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.lollipopAndAbove()) {
            this.setupThumbColorLollipop();
        } else {
            this.gradientDrawable.setColor(this.mIsEnabled ? thumbColor : -3355444);
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupThumbColorLollipop() {
        if (this.lollipopAndAbove()) {
            this.colorsThumb[0] = this.mThumbColor;
            this.colorsThumb[1] = this.mThumbColor;
            this.colorsThumb[2] = -3355444;
            this.mColorStateListThumb = new ColorStateList(this.states, this.colorsThumb);
            this.setThumbTintList(this.mColorStateListThumb);
        }
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressColorLollipop();
        } else {
            this.setupProgressColor();
        }
        this.invalidate();
        this.requestLayout();
    }

    private boolean lollipopAndAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void setupProgressColor() {
        try {
            LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
            ScaleDrawable shape = (ScaleDrawable)ld.findDrawableByLayerId(16908301);
            shape.setColorFilter(this.mProgressColor, PorterDuff.Mode.SRC_IN);
            NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)ld.findDrawableByLayerId(0x1020000);
            ninePatchDrawable.setColorFilter(0, PorterDuff.Mode.SRC_IN);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @TargetApi(value=21)
    private void setupProgressColorLollipop() {
        this.colorsProgress[0] = this.mProgressColor;
        this.colorsProgress[1] = this.mProgressColor;
        this.mColorStateListProgress = new ColorStateList(this.states, this.colorsProgress);
        this.setProgressTintList(this.mColorStateListProgress);
    }

    @TargetApi(value=16)
    public void setProgressBackgroundColor(int progressBackgroundColor) {
        this.mProgressBackgroundColor = progressBackgroundColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressBackgroundLollipop();
        } else {
            this.setupProgressBackground();
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupProgressBackgroundLollipop() {
        this.colorsProgressBackground[0] = this.mProgressBackgroundColor;
        this.colorsProgressBackground[1] = this.mProgressBackgroundColor;
        this.mColorStateListProgressBackground = new ColorStateList(this.states, this.colorsProgressBackground);
        this.setProgressBackgroundTintList(this.mColorStateListProgressBackground);
    }

    @TargetApi(value=16)
    private void setupProgressBackground() {
        SeekBarBackgroundDrawable seekBarBackgroundDrawable = new SeekBarBackgroundDrawable(this.getContext(), this.mProgressBackgroundColor, this.mActualBackgroundColor, this.getPaddingLeft(), this.getPaddingRight());
        if (this.belowJellybean()) {
            this.setBackgroundDrawable(seekBarBackgroundDrawable);
        } else {
            this.setBackground(seekBarBackgroundDrawable);
        }
    }

    public SeekBarCompat(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    public SeekBarCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SeekBarCompat, 0, 0);
        int[] array = new int[]{16842964, 0x101000E};
        TypedArray b = context.getTheme().obtainStyledAttributes(attrs, array, 0, 0);
        try {
            this.mThumbColor = a.getColor(R.styleable.SeekBarCompat_thumbColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressColor = a.getColor(R.styleable.SeekBarCompat_progressColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressBackgroundColor = a.getColor(R.styleable.SeekBarCompat_progressBackgroundColor, -16777216);
            this.mThumbAlpha = (int)(a.getFloat(R.styleable.SeekBarCompat_thumbAlpha, 1.0f) * 255.0f);
            this.mActualBackgroundColor = b.getColor(0, 0);
            this.mIsEnabled = b.getBoolean(1, true);
            if (this.lollipopAndAbove()) {
                this.setSplitTrack(false);
                this.setupThumbColorLollipop();
                this.setupProgressColorLollipop();
                this.setupProgressBackgroundLollipop();
                this.getThumb().setAlpha(this.mThumbAlpha);
            } else {
                Log.e((String)TAG, (String)("SeekBarCompat isEnabled? " + this.mIsEnabled));
                this.setupProgressColor();
                this.setOnTouchListener(this);
                this.gradientDrawable.setShape(1);
                this.gradientDrawable.setSize(50, 50);
                this.gradientDrawable.setColor(this.mIsEnabled ? this.mThumbColor : -3355444);
                SeekBarCompat.triggerMethodOnceViewIsDisplayed((View)this, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ViewGroup.LayoutParams layoutParams = SeekBarCompat.this.getLayoutParams();
                        SeekBarCompat.this.mOriginalThumbHeight = SeekBarCompat.this.mThumb.getIntrinsicHeight();
                        SeekBarCompat.this.gradientDrawable.setSize(SeekBarCompat.this.mOriginalThumbHeight / 3, SeekBarCompat.this.mOriginalThumbHeight / 3);
                        SeekBarCompat.this.gradientDrawable.setAlpha(SeekBarCompat.this.mThumbAlpha);
                        SeekBarCompat.this.setThumb((Drawable)SeekBarCompat.this.gradientDrawable);
                        if (layoutParams.height < SeekBarCompat.this.mOriginalThumbHeight) {
                            layoutParams.height = SeekBarCompat.this.mOriginalThumbHeight;
                        }
                        SeekBarCompat.this.setupProgressBackground();
                        return null;
                    }
                });
            }
        }
        finally {
            a.recycle();
            b.recycle();
        }
    }

    private boolean belowJellybean() {
        return Build.VERSION.SDK_INT < 16;
    }

    public static int getPrimaryColorFromSelectedTheme(Context context) {
        int[] attrs = new int[]{R.attr.colorPrimary, R.attr.colorPrimaryDark};
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs);
        int primaryColor = ta.getColor(0, -16777216);
        ta.recycle();
        return primaryColor;
    }

    public static void triggerMethodOnceViewIsDisplayed(final View view, final Callable<Void> method) {
        ViewTreeObserver observer = view.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                try {
                    method.call();
                }
                catch (Exception e) {
                    Log.e((String)SeekBarCompat.TAG, (String)("onGlobalLayout " + e.toString()));
                }
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.lollipopAndAbove()) {
            switch (event.getAction()) {
                case 0: {
                    this.gradientDrawable = new GradientDrawable();
                    this.gradientDrawable.setShape(1);
                    this.gradientDrawable.setSize(this.mOriginalThumbHeight / 2, this.mOriginalThumbHeight / 2);
                    this.gradientDrawable.setColor(this.mIsEnabled ? this.mThumbColor : -3355444);
                    this.gradientDrawable.setDither(true);
                    this.gradientDrawable.setAlpha(this.mThumbAlpha);
                    this.setThumb((Drawable)this.gradientDrawable);
                    break;
                }
                case 1: {
                    this.gradientDrawable = new GradientDrawable();
                    this.gradientDrawable.setShape(1);
                    this.gradientDrawable.setSize(this.mOriginalThumbHeight / 3, this.mOriginalThumbHeight / 3);
                    this.gradientDrawable.setColor(this.mIsEnabled ? this.mThumbColor : -3355444);
                    this.gradientDrawable.setDither(true);
                    this.gradientDrawable.setAlpha(this.mThumbAlpha);
                    this.setThumb((Drawable)this.gradientDrawable);
                }
            }
        }
        return false;
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.mThumb = thumb;
    }

    @TargetApi(value=16)
    public void setThumbAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mThumbAlpha = alpha;
        if (!this.belowJellybean()) {
            this.getThumb().setAlpha(this.mThumbAlpha);
        }
        this.setLayoutParams(this.getLayoutParams());
    }

    public void setEnabled(final boolean enabled) {
        this.mIsEnabled = enabled;
        SeekBarCompat.triggerMethodOnceViewIsDisplayed((View)this, new Callable<Void>(){

            @Override
            @TargetApi(value=16)
            public Void call() throws Exception {
                if (!SeekBarCompat.this.lollipopAndAbove()) {
                    SeekBarCompat.this.gradientDrawable = new GradientDrawable();
                    SeekBarCompat.this.gradientDrawable.setShape(1);
                    SeekBarCompat.this.gradientDrawable.setSize(SeekBarCompat.this.mOriginalThumbHeight / 3, SeekBarCompat.this.mOriginalThumbHeight / 3);
                    SeekBarCompat.this.gradientDrawable.setColor(SeekBarCompat.this.mIsEnabled ? SeekBarCompat.this.mThumbColor : -3355444);
                    SeekBarCompat.this.gradientDrawable.setDither(true);
                    SeekBarCompat.this.gradientDrawable.setAlpha(SeekBarCompat.this.mThumbAlpha);
                    SeekBarCompat.this.setThumb((Drawable)SeekBarCompat.this.gradientDrawable);
                    LayerDrawable ld = (LayerDrawable)SeekBarCompat.this.getProgressDrawable();
                    ScaleDrawable shape = (ScaleDrawable)ld.findDrawableByLayerId(16908301);
                    shape.setColorFilter(SeekBarCompat.this.mIsEnabled ? SeekBarCompat.this.mProgressColor : -3355444, PorterDuff.Mode.SRC_IN);
                    NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)ld.findDrawableByLayerId(0x1020000);
                    ninePatchDrawable.setColorFilter(0, PorterDuff.Mode.SRC_IN);
                    SeekBarBackgroundDrawable seekBarBackgroundDrawable = new SeekBarBackgroundDrawable(SeekBarCompat.this.getContext(), SeekBarCompat.this.mIsEnabled ? SeekBarCompat.this.mProgressBackgroundColor : -3355444, SeekBarCompat.this.mActualBackgroundColor, SeekBarCompat.this.getPaddingLeft(), SeekBarCompat.this.getPaddingRight());
                    if (SeekBarCompat.this.belowJellybean()) {
                        SeekBarCompat.this.setBackgroundDrawable(seekBarBackgroundDrawable);
                    } else {
                        SeekBarCompat.this.setBackground(seekBarBackgroundDrawable);
                    }
                }
                SeekBarCompat.super.setEnabled(enabled);
                return null;
            }
        });
    }
}

