/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.SeekBar;
import app.minimize.com.seek_bar_compat.R;
import app.minimize.com.seek_bar_compat.SeekBarBackgroundDrawable;
import java.util.concurrent.Callable;

public class SeekBarCompat
extends SeekBar
implements View.OnTouchListener {
    private static final String TAG = "SeekBarCompat";
    private int mActualBackgroundColor;
    int mThumbColor;
    int mProgressColor;
    int mProgressBackgroundColor;
    Drawable mThumb;
    int[][] states = new int[][]{{16842910}, {16842919}};
    int[] colorsThumb = new int[]{-16777216, -16777216};
    int[] colorsProgress = new int[]{-16777216, -16777216};
    int[] colorsProgressBackground = new int[]{-16777216, -16777216};
    ColorStateList mColorStateListThumb;
    ColorStateList mColorStateListProgress;
    ColorStateList mColorStateListProgressBackground;
    private int mOriginalThumbHeight;
    private int mAlpha = 255;
    GradientDrawable gradientDrawable = new GradientDrawable();

    public void setThumbColor(int thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.lollipopAndAbove()) {
            this.setupThumbColorLollipop();
        } else {
            this.gradientDrawable.setColor(thumbColor);
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupThumbColorLollipop() {
        if (this.lollipopAndAbove()) {
            this.colorsThumb[0] = this.mThumbColor;
            this.colorsThumb[1] = this.mThumbColor;
            this.mColorStateListThumb = new ColorStateList(this.states, this.colorsThumb);
            this.setThumbTintList(this.mColorStateListThumb);
        }
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressColorLollipop();
        } else {
            this.setupProgressColor();
        }
        this.invalidate();
        this.requestLayout();
    }

    private boolean lollipopAndAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void setupProgressColor() {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        ScaleDrawable shape = (ScaleDrawable)ld.findDrawableByLayerId(16908301);
        shape.setColorFilter(this.mProgressColor, PorterDuff.Mode.SRC_IN);
        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)ld.findDrawableByLayerId(0x1020000);
        ninePatchDrawable.setColorFilter(0, PorterDuff.Mode.SRC_IN);
    }

    @TargetApi(value=21)
    private void setupProgressColorLollipop() {
        this.colorsProgress[0] = this.mProgressColor;
        this.colorsProgress[1] = this.mProgressColor;
        this.mColorStateListProgress = new ColorStateList(this.states, this.colorsProgress);
        this.setProgressTintList(this.mColorStateListProgress);
    }

    @TargetApi(value=16)
    public void setProgressBackgroundColor(int progressBackgroundColor) {
        this.mProgressBackgroundColor = progressBackgroundColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressBackgroundLollipop();
        } else {
            this.setupProgressBackground();
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupProgressBackgroundLollipop() {
        this.colorsProgressBackground[0] = this.mProgressBackgroundColor;
        this.colorsProgressBackground[1] = this.mProgressBackgroundColor;
        this.mColorStateListProgressBackground = new ColorStateList(this.states, this.colorsProgressBackground);
        this.setProgressBackgroundTintList(this.mColorStateListProgressBackground);
    }

    @TargetApi(value=16)
    private void setupProgressBackground() {
        SeekBarBackgroundDrawable seekBarBackgroundDrawable = new SeekBarBackgroundDrawable(this.getContext(), this.mProgressBackgroundColor, this.mActualBackgroundColor, this.getPaddingLeft(), this.getPaddingRight());
        if (this.belowJellybean()) {
            this.setBackgroundDrawable(seekBarBackgroundDrawable);
        } else {
            this.setBackground(seekBarBackgroundDrawable);
        }
    }

    public SeekBarCompat(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public SeekBarCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SeekBarCompat, 0, 0);
        int[] array = new int[]{16842964};
        TypedArray b = context.getTheme().obtainStyledAttributes(attrs, array, 0, 0);
        try {
            this.mThumbColor = a.getColor(R.styleable.SeekBarCompat_thumbColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressColor = a.getColor(R.styleable.SeekBarCompat_progressColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressBackgroundColor = a.getColor(R.styleable.SeekBarCompat_progressBackgroundColor, -16777216);
            this.mActualBackgroundColor = b.getColor(0, 0);
            if (this.lollipopAndAbove()) {
                this.setupThumbColorLollipop();
                this.setupProgressColorLollipop();
                this.setupProgressBackgroundLollipop();
                this.getThumb().setAlpha(this.mAlpha);
            } else {
                this.setupProgressColor();
                this.setOnTouchListener(this);
                this.gradientDrawable.setShape(1);
                this.gradientDrawable.setSize(120, 120);
                this.gradientDrawable.setColor(this.mThumbColor);
                SeekBarCompat.triggerMethodOnceViewIsDisplayed((View)this, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ViewGroup.LayoutParams layoutParams = SeekBarCompat.this.getLayoutParams();
                        SeekBarCompat.this.mOriginalThumbHeight = SeekBarCompat.this.mThumb.getIntrinsicHeight();
                        SeekBarCompat.this.setThumb(SeekBarCompat.this.setDrawableDimensions((Drawable)SeekBarCompat.this.gradientDrawable, SeekBarCompat.this.mOriginalThumbHeight / 3, SeekBarCompat.this.mOriginalThumbHeight / 3));
                        if (layoutParams.height < SeekBarCompat.this.mOriginalThumbHeight) {
                            layoutParams.height = SeekBarCompat.this.mOriginalThumbHeight;
                        }
                        SeekBarCompat.this.setupProgressBackground();
                        return null;
                    }
                });
            }
        }
        finally {
            a.recycle();
            b.recycle();
        }
    }

    private Drawable setDrawableDimensions(Drawable drawable, int height, int width) {
        Bitmap bmpOrg = SeekBarCompat.drawableToBitmap(drawable);
        Bitmap bmpScaled = Bitmap.createScaledBitmap((Bitmap)bmpOrg, (int)height, (int)width, (boolean)true);
        BitmapDrawable newDrawable = new BitmapDrawable(this.getResources(), bmpScaled);
        newDrawable.setBounds(0, 0, newDrawable.getIntrinsicWidth(), newDrawable.getIntrinsicHeight());
        newDrawable.setAlpha(this.mAlpha);
        return newDrawable;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private boolean belowJellybean() {
        return Build.VERSION.SDK_INT < 16;
    }

    public static int getPrimaryColorFromSelectedTheme(Context context) {
        int[] attrs = new int[]{R.attr.colorPrimary, R.attr.colorPrimaryDark};
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs);
        int primaryColor = ta.getColor(0, -16777216);
        ta.recycle();
        return primaryColor;
    }

    public static void triggerMethodOnceViewIsDisplayed(final View view, final Callable<Void> method) {
        ViewTreeObserver observer = view.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                try {
                    method.call();
                }
                catch (Exception e) {
                    Log.e((String)SeekBarCompat.TAG, (String)("onGlobalLayout " + e.toString()));
                }
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (!this.lollipopAndAbove()) {
            switch (event.getAction()) {
                case 0: {
                    this.setThumb(this.setDrawableDimensions((Drawable)this.gradientDrawable, this.mOriginalThumbHeight / 2, this.mOriginalThumbHeight / 2));
                    break;
                }
                case 1: {
                    this.setThumb(this.setDrawableDimensions((Drawable)this.gradientDrawable, this.mOriginalThumbHeight / 3, this.mOriginalThumbHeight / 3));
                }
            }
        }
        return false;
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.mThumb = thumb;
    }

    @TargetApi(value=16)
    public void setThumbAlpha(int alpha) {
        this.mAlpha = alpha;
        if (this.lollipopAndAbove()) {
            this.getThumb().setAlpha(this.mAlpha);
        }
        this.setLayoutParams(this.getLayoutParams());
    }
}

