/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.ShapeDrawable;
import app.minimize.com.seek_bar_compat.SeekBarCompat;

public class SeekBarThumbDrawable
extends ShapeDrawable {
    private static final String TAG = "SeekBarThumb";
    private int mHeight;
    private SeekBarCompat mSeekBarCompat;
    private Paint mPaint = new Paint();
    private float xMultiple;
    private int shrinkScale = 5;
    private float mMax;
    private float mWidth;

    public SeekBarThumbDrawable(int thumbColor, SeekBarCompat seekBarCompat) {
        this.mSeekBarCompat = seekBarCompat;
        this.mPaint.setColor(thumbColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        try {
            canvas.drawCircle((float)this.mSeekBarCompat.getProgress() * this.xMultiple, (float)(this.mHeight / 2), (float)(this.mHeight / this.shrinkScale), this.mPaint);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    public void shrinkMode() {
        this.shrinkScale = 5;
        this.invalidateSelf();
    }

    public void expandMode() {
        this.shrinkScale = 3;
        this.invalidateSelf();
    }

    public void setMax(int max) {
        this.mMax = max;
        this.xMultiple = (this.mWidth - (float)this.mHeight) / this.mMax;
    }

    public void setHeight(int height) {
        this.mHeight = height;
        this.mWidth = this.mSeekBarCompat.getWidth();
        this.xMultiple = (float)(this.mSeekBarCompat.getWidth() - height) / this.mMax;
    }

    public void setColor(int thumbColor) {
        this.mPaint.setColor(thumbColor);
        this.invalidateSelf();
    }
}

