/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.ScaleDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.SeekBar;
import app.minimize.com.seek_bar_compat.R;
import app.minimize.com.seek_bar_compat.SeekBarBackgroundDrawable;
import app.minimize.com.seek_bar_compat.SeekBarThumbDrawable;
import java.util.concurrent.Callable;

public class SeekBarCompat
extends SeekBar
implements View.OnTouchListener {
    private static final String TAG = "SeekBarCompat";
    int mThumbColor;
    int mProgressColor;
    int mProgressBackgroundColor;
    Drawable mThumb;
    int[][] states = new int[][]{{16842910}, {16842919}};
    int[] colorsThumb = new int[]{-16777216, -16777216};
    int[] colorsProgress = new int[]{-16777216, -16777216};
    int[] colorsProgressBackground = new int[]{-16777216, -16777216};
    ColorStateList mColorStateListThumb;
    ColorStateList mColorStateListProgress;
    ColorStateList mColorStateListProgressBackground;
    private int mOriginalThumbHeight;
    private int mMax;

    public void setThumbColor(int thumbColor) {
        this.mThumbColor = thumbColor;
        if (this.lollipopAndAbove()) {
            this.setupThumbColorLollipop();
        } else if (this.mThumb != null) {
            ((SeekBarThumbDrawable)this.mThumb).setColor(this.mThumbColor);
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupThumbColorLollipop() {
        this.colorsThumb[0] = this.mThumbColor;
        this.colorsThumb[1] = this.mThumbColor;
        this.mColorStateListThumb = new ColorStateList(this.states, this.colorsThumb);
        this.setThumbTintList(this.mColorStateListThumb);
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressColorLollipop();
        } else {
            this.setupProgressColor();
        }
        this.invalidate();
        this.requestLayout();
    }

    private boolean lollipopAndAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private void setupProgressColor() {
        LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
        ScaleDrawable shape = (ScaleDrawable)ld.findDrawableByLayerId(16908301);
        shape.setColorFilter(this.mProgressColor, PorterDuff.Mode.SRC_IN);
        NinePatchDrawable ninePatchDrawable = (NinePatchDrawable)ld.findDrawableByLayerId(0x1020000);
        ninePatchDrawable.setColorFilter(0, PorterDuff.Mode.SRC_IN);
    }

    @TargetApi(value=21)
    private void setupProgressColorLollipop() {
        this.colorsProgress[0] = this.mProgressColor;
        this.colorsProgress[1] = this.mProgressColor;
        this.mColorStateListProgress = new ColorStateList(this.states, this.colorsProgress);
        this.setProgressTintList(this.mColorStateListProgress);
    }

    @TargetApi(value=16)
    public void setProgressBackgroundColor(int progressBackgroundColor) {
        this.mProgressBackgroundColor = progressBackgroundColor;
        if (this.lollipopAndAbove()) {
            this.setupProgressBackgroundLollipop();
        } else {
            this.setupProgressBackground();
        }
        this.invalidate();
        this.requestLayout();
    }

    @TargetApi(value=21)
    private void setupProgressBackgroundLollipop() {
        this.colorsProgressBackground[0] = this.mProgressBackgroundColor;
        this.colorsProgressBackground[1] = this.mProgressBackgroundColor;
        this.mColorStateListProgressBackground = new ColorStateList(this.states, this.colorsProgressBackground);
        this.setProgressBackgroundTintList(this.mColorStateListProgressBackground);
    }

    @TargetApi(value=16)
    private void setupProgressBackground() {
        SeekBarBackgroundDrawable seekBarBackgroundDrawable = new SeekBarBackgroundDrawable(this.getContext(), this.mProgressBackgroundColor, this.getResources().getDimension(R.dimen.default_margin));
        if (this.belowJellybean()) {
            this.setBackgroundDrawable(seekBarBackgroundDrawable);
        } else {
            this.setBackground(seekBarBackgroundDrawable);
        }
        this.getBackground().setColorFilter((ColorFilter)new PorterDuffColorFilter(this.mProgressBackgroundColor, PorterDuff.Mode.SRC_IN));
    }

    public SeekBarCompat(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=16)
    public SeekBarCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SeekBarCompat, 0, 0);
        try {
            this.mThumbColor = a.getColor(R.styleable.SeekBarCompat_thumbColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressColor = a.getColor(R.styleable.SeekBarCompat_progressColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressBackgroundColor = a.getColor(R.styleable.SeekBarCompat_progressBackgroundColor, -16777216);
            if (this.lollipopAndAbove()) {
                this.setupThumbColorLollipop();
                this.setupProgressColorLollipop();
                this.setupProgressBackgroundLollipop();
            } else {
                this.setupProgressColor();
                this.setupProgressBackground();
                this.setOnTouchListener(this);
                this.mThumb = new SeekBarThumbDrawable(this.mThumbColor, this);
                SeekBarCompat.triggerMethodOnceViewIsDisplayed((View)this, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ViewGroup.LayoutParams layoutParams = SeekBarCompat.this.getLayoutParams();
                        SeekBarCompat.this.mOriginalThumbHeight = SeekBarCompat.this.getThumb().getIntrinsicHeight();
                        ((SeekBarThumbDrawable)SeekBarCompat.this.mThumb).setMax(SeekBarCompat.this.getMax());
                        ((SeekBarThumbDrawable)SeekBarCompat.this.mThumb).setHeight(SeekBarCompat.this.mOriginalThumbHeight);
                        SeekBarCompat.this.setThumb(SeekBarCompat.this.mThumb);
                        layoutParams.height = SeekBarCompat.this.mOriginalThumbHeight;
                        SeekBarCompat.this.setLayoutParams(layoutParams);
                        return null;
                    }
                });
            }
        }
        finally {
            a.recycle();
        }
    }

    private boolean belowJellybean() {
        return Build.VERSION.SDK_INT < 16;
    }

    public static int getPrimaryColorFromSelectedTheme(Context context) {
        int[] attrs = new int[]{R.attr.colorPrimary, R.attr.colorPrimaryDark};
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs);
        int primaryColor = ta.getColor(0, -16777216);
        ta.recycle();
        return primaryColor;
    }

    public static void triggerMethodOnceViewIsDisplayed(final View view, final Callable<Void> method) {
        ViewTreeObserver observer = view.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                try {
                    method.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        int x = (int)event.getX();
        switch (event.getAction()) {
            case 0: {
                ((SeekBarThumbDrawable)this.mThumb).expandMode();
                break;
            }
            case 1: {
                ((SeekBarThumbDrawable)this.mThumb).shrinkMode();
            }
        }
        return false;
    }

    public void setThumb(Drawable thumb) {
        super.setThumb(thumb);
        this.mThumb = thumb;
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener l) {
        super.setOnSeekBarChangeListener(l);
        if (!this.lollipopAndAbove()) {
            this.mThumb.invalidateSelf();
        }
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.mThumb != null && this.mThumb instanceof SeekBarThumbDrawable) {
            ((SeekBarThumbDrawable)this.mThumb).setMax(max);
        }
    }
}

