/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.ShapeDrawable;

public class SeekBarThumbDrawable
extends ShapeDrawable {
    private static final String TAG = "SeekBarThumb";
    private final int mHeight;
    private Paint mPaint = new Paint();
    private int mProgress;
    private int mTotalWidth;
    private int shrinkScale = 5;

    public SeekBarThumbDrawable(int thumbColor, int height, int totalWidth) {
        this.mHeight = height;
        this.mTotalWidth = totalWidth;
        this.mProgress = height / 2;
        this.mPaint.setColor(thumbColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle((float)(this.mProgress - this.mHeight / 2), (float)(this.mHeight / 2), (float)(this.mHeight / this.shrinkScale), this.mPaint);
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return 0;
    }

    public void updatePosition(int xPos) {
        if (xPos >= this.mHeight / 2 && xPos <= this.mTotalWidth - this.mHeight / 2) {
            this.mProgress = xPos;
            this.invalidateSelf();
        }
    }

    public void shrinkMode() {
        this.shrinkScale = 5;
        this.invalidateSelf();
    }

    public void expandMode() {
        this.shrinkScale = 3;
        this.invalidateSelf();
    }
}

