/*
 * Decompiled with CFR 0.152.
 */
package app.minimize.com.seek_bar_compat;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.SeekBar;
import app.minimize.com.seek_bar_compat.R;
import java.util.concurrent.Callable;

public class SeekBarCompat
extends SeekBar
implements View.OnTouchListener {
    int mThumbColor;
    int mProgressColor;
    Drawable mThumb;
    int[][] states = new int[][]{{16842910}, {16842919}};
    int[] colorsThumb = new int[]{-16777216, -16777216};
    int[] colorsProgress = new int[]{-16777216, -16777216};
    ColorStateList mColorStateListThumb;
    ColorStateList mColorStateListProgress;

    public void setThumbColor(int thumbColor) {
        this.mThumbColor = thumbColor;
        if (Build.VERSION.SDK_INT >= 21) {
            this.colorsThumb[0] = thumbColor;
            this.colorsThumb[1] = thumbColor;
            this.mColorStateListThumb = new ColorStateList(this.states, this.colorsThumb);
            this.setThumbTintList(this.mColorStateListThumb);
        } else {
            this.updateThumb(thumbColor);
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setProgressColor(int progressColor) {
        this.mProgressColor = progressColor;
        if (Build.VERSION.SDK_INT >= 21) {
            this.colorsProgress[0] = progressColor;
            this.colorsProgress[1] = progressColor;
            this.mColorStateListProgress = new ColorStateList(this.states, this.colorsProgress);
            this.setProgressTintList(this.mColorStateListProgress);
        } else {
            LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
            ld.setColorFilter(this.mProgressColor, PorterDuff.Mode.SRC_IN);
        }
        this.invalidate();
        this.requestLayout();
    }

    public SeekBarCompat(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeekBarCompat(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SeekBarCompat, 0, 0);
        try {
            this.mThumbColor = a.getColor(R.styleable.SeekBarCompat_thumbColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.mProgressColor = a.getColor(R.styleable.SeekBarCompat_progressColor, SeekBarCompat.getPrimaryColorFromSelectedTheme(context));
            this.colorsThumb[0] = this.mThumbColor;
            this.colorsThumb[1] = this.mThumbColor;
            this.mColorStateListThumb = new ColorStateList(this.states, this.colorsThumb);
            this.colorsProgress[0] = this.mProgressColor;
            this.colorsProgress[1] = this.mProgressColor;
            this.mColorStateListProgress = new ColorStateList(this.states, this.colorsProgress);
            if (Build.VERSION.SDK_INT >= 21) {
                this.setThumbTintList(this.mColorStateListThumb);
                this.setProgressTintList(this.mColorStateListProgress);
            } else {
                this.mThumb = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_circle);
                this.updateThumb(this.mThumbColor);
                LayerDrawable ld = (LayerDrawable)this.getProgressDrawable();
                ld.setColorFilter(this.mProgressColor, PorterDuff.Mode.SRC_IN);
                this.setOnTouchListener(this);
                SeekBarCompat.triggerMethodOnceViewIsDisplayed((View)this, new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ViewGroup.LayoutParams layoutParams = SeekBarCompat.this.getLayoutParams();
                        layoutParams.height = (int)((double)SeekBarCompat.this.mThumb.getIntrinsicHeight() * 1.5);
                        SeekBarCompat.this.setLayoutParams(layoutParams);
                        return null;
                    }
                });
            }
        }
        finally {
            a.recycle();
        }
    }

    public static int getPrimaryColorFromSelectedTheme(Context context) {
        int[] attrs = new int[]{R.attr.colorPrimary, R.attr.colorPrimaryDark};
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs);
        int primaryColor = ta.getColor(0, -16777216);
        ta.recycle();
        return primaryColor;
    }

    public static void triggerMethodOnceViewIsDisplayed(final View view, final Callable<Void> method) {
        ViewTreeObserver observer = view.getViewTreeObserver();
        observer.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                try {
                    method.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.updateThumb(this.mThumbColor, 1.1f);
                break;
            }
            case 1: {
                this.expandThumb(this.getHeight());
                this.mThumb.setColorFilter(this.mThumbColor, PorterDuff.Mode.MULTIPLY);
                this.setThumb(this.mThumb);
            }
        }
        return false;
    }

    private void expandThumb(int height) {
        this.mThumb.setBounds(0, 0, this.mThumb.getIntrinsicWidth(), height);
        int progress = this.getProgress();
        this.setProgress(0);
        this.setProgress(progress);
    }

    private void updateThumb(int thumbColor, float scale) {
        int h = (int)((float)this.mThumb.getIntrinsicHeight() * scale);
        Bitmap bmpOrg = ((BitmapDrawable)this.mThumb).getBitmap();
        Bitmap bmpScaled = Bitmap.createScaledBitmap((Bitmap)bmpOrg, (int)h, (int)h, (boolean)true);
        BitmapDrawable newThumb = new BitmapDrawable(this.getResources(), bmpScaled);
        newThumb.setBounds(0, 0, newThumb.getIntrinsicWidth(), newThumb.getIntrinsicHeight());
        this.setThumb((Drawable)newThumb);
        this.getThumb().setColorFilter(thumbColor, PorterDuff.Mode.MULTIPLY);
    }

    private void updateThumb(int thumbColor) {
        Bitmap bmpOrg = ((BitmapDrawable)this.mThumb).getBitmap();
        BitmapDrawable newThumb = new BitmapDrawable(this.getResources(), bmpOrg);
        newThumb.setBounds(0, 0, newThumb.getIntrinsicWidth(), newThumb.getIntrinsicHeight());
        this.setThumb((Drawable)newThumb);
        this.getThumb().setColorFilter(thumbColor, PorterDuff.Mode.MULTIPLY);
    }
}

