/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.minggo.pluto.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtil {
    public static String getSimpleMimeType(String url) {
        return BitmapUtil.getMimeType(url).replace("image/", "");
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public static String getImageType(InputStream in) {
        if (in == null) {
            return null;
        }
        try {
            byte[] bytes = new byte[8];
            in.read(bytes);
            return BitmapUtil.getImageType(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getImageType(String filePath) {
        FileInputStream in = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                in = new FileInputStream(filePath);
                System.out.println("in-->" + in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (in == null) {
            return null;
        }
        try {
            byte[] bytes = new byte[8];
            ((InputStream)in).read(bytes);
            return BitmapUtil.getImageType(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getImageType(byte[] bytes) {
        if (BitmapUtil.isJPEG(bytes)) {
            return "image/jpeg";
        }
        if (BitmapUtil.isGIF(bytes)) {
            return "image/gif";
        }
        if (BitmapUtil.isPNG(bytes)) {
            return "image/png";
        }
        if (BitmapUtil.isBMP(bytes)) {
            return "image/bmp";
        }
        return null;
    }

    private static boolean isJPEG(byte[] b) {
        if (b.length < 2) {
            return false;
        }
        return b[0] == -1 && b[1] == -40;
    }

    private static boolean isGIF(byte[] b) {
        if (b.length < 6) {
            return false;
        }
        return b[0] == 71 && b[1] == 73 && b[2] == 70 && b[3] == 56 && (b[4] == 55 || b[4] == 57) && b[5] == 97;
    }

    private static boolean isPNG(byte[] b) {
        if (b.length < 8) {
            return false;
        }
        return b[0] == -119 && b[1] == 80 && b[2] == 78 && b[3] == 71 && b[4] == 13 && b[5] == 10 && b[6] == 26 && b[7] == 10;
    }

    private static boolean isBMP(byte[] b) {
        if (b.length < 2) {
            return false;
        }
        return b[0] == 66 && b[1] == 77;
    }

    public static String getPostfix(String filePath) {
        String postfix = "jpg";
        String type = BitmapUtil.getSimpleMimeType(filePath);
        if (!TextUtils.isEmpty((CharSequence)type) && type.indexOf("png") != -1) {
            postfix = "png";
        }
        return postfix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getSmallBitmap(String filePath) {
        if (FileUtils.getFileSize(filePath) < 200000L) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtil.calculateInSampleSize(options, 480, 800);
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bm == null) {
            return null;
        }
        int degree = BitmapUtil.readPictureDegree(filePath);
        bm = BitmapUtil.rotateBitmap(bm, degree);
        FileOutputStream baos = null;
        try {
            baos = new FileOutputStream(new File(filePath));
            bm.compress(BitmapUtil.getCompressFormat(filePath), 30, (OutputStream)baos);
            baos.flush();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bm;
    }

    private static Bitmap.CompressFormat getCompressFormat(String filePath) {
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
        String type = BitmapUtil.getSimpleMimeType(filePath);
        if (!TextUtils.isEmpty((CharSequence)type) && type.indexOf("png") != -1) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return compressFormat;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? widthRatio : heightRatio;
        }
        return inSampleSize;
    }

    private static Bitmap rotateBitmap(Bitmap bitmap, int rotate) {
        if (bitmap == null) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Matrix mtx = new Matrix();
        mtx.postRotate((float)rotate);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
    }

    private static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }
}

