/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import android.text.TextUtils;
import com.minggo.pluto.db.orm.DbException;
import com.minggo.pluto.db.orm.Id;
import com.minggo.pluto.db.orm.KeyValue;
import com.minggo.pluto.db.orm.ManyToOne;
import com.minggo.pluto.db.orm.ManyToOneLazyLoader;
import com.minggo.pluto.db.orm.Property;
import com.minggo.pluto.db.orm.SqlInfo;
import com.minggo.pluto.db.orm.TableInfo;
import com.minggo.pluto.util.LogUtils;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SqlBuilder {
    public static SqlInfo buildInsertSql(Object entity) {
        LogUtils.info("finalDb", ">>>>entity==" + entity);
        List<KeyValue> keyValueList = SqlBuilder.getSaveKeyValueListByEntity(entity);
        StringBuffer strSQL = new StringBuffer();
        SqlInfo sqlInfo = null;
        if (keyValueList != null && keyValueList.size() > 0) {
            sqlInfo = new SqlInfo();
            strSQL.append("INSERT INTO ");
            strSQL.append(TableInfo.get(entity.getClass()).getTableName());
            strSQL.append(" (");
            for (KeyValue kv : keyValueList) {
                strSQL.append(kv.getKey()).append(",");
                sqlInfo.addValue(kv.getValue());
            }
            strSQL.deleteCharAt(strSQL.length() - 1);
            strSQL.append(") VALUES ( ");
            int length = keyValueList.size();
            for (int i = 0; i < length; ++i) {
                strSQL.append("?,");
            }
            strSQL.deleteCharAt(strSQL.length() - 1);
            strSQL.append(")");
            sqlInfo.setSql(strSQL.toString());
        }
        LogUtils.info("finalDb", ">>>>sqlInfo==" + sqlInfo);
        return sqlInfo;
    }

    public static List<KeyValue> getSaveKeyValueListByEntity(Object entity) {
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
        TableInfo table = TableInfo.get(entity.getClass());
        LogUtils.info("finalDb", ">>>>>table-" + table);
        Object idvalue = table.getId().getValue(entity);
        LogUtils.info("finalDb", ">>>>>idvalue-" + idvalue);
        if (idvalue != null) {
            KeyValue kv = new KeyValue(table.getId().getColumn(), idvalue);
            keyValueList.add(kv);
        }
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            KeyValue kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        return keyValueList;
    }

    private static String getDeleteSqlBytableName(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public static SqlInfo buildDeleteSql(Object entity) {
        TableInfo table = TableInfo.get(entity.getClass());
        Id id2 = table.getId();
        Object idvalue = id2.getValue(entity);
        if (idvalue == null) {
            throw new DbException("getDeleteSQL:" + entity.getClass() + " id value is null");
        }
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        strSQL.append(" WHERE ").append(id2.getColumn()).append("=?");
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setSql(strSQL.toString());
        sqlInfo.addValue(idvalue);
        return sqlInfo;
    }

    public static SqlInfo buildDeleteSql(Class<?> clazz, Object idValue) {
        TableInfo table = TableInfo.get(clazz);
        Id id2 = table.getId();
        if (null == idValue) {
            throw new DbException("getDeleteSQL:idValue is null");
        }
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        strSQL.append(" WHERE ").append(id2.getColumn()).append("=?");
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setSql(strSQL.toString());
        sqlInfo.addValue(idValue);
        return sqlInfo;
    }

    public static String buildDeleteSql(Class<?> clazz, String strWhere) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getDeleteSqlBytableName(table.getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ");
            strSQL.append(strWhere);
        }
        return strSQL.toString();
    }

    private static String getSelectSqlByTableName(String tableName) {
        return new StringBuffer("SELECT * FROM ").append(tableName).toString();
    }

    public static String getSelectSQL(Class<?> clazz, Object idValue) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getSelectSqlByTableName(table.getTableName()));
        strSQL.append(" WHERE ");
        strSQL.append(SqlBuilder.getPropertyStrSql(table.getId().getColumn(), idValue));
        return strSQL.toString();
    }

    public static SqlInfo getSelectSqlAsSqlInfo(Class<?> clazz, Object idValue) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getSelectSqlByTableName(table.getTableName()));
        strSQL.append(" WHERE ").append(table.getId().getColumn()).append("=?");
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setSql(strSQL.toString());
        sqlInfo.addValue(idValue);
        return sqlInfo;
    }

    public static String getSelectSQL(Class<?> clazz) {
        return SqlBuilder.getSelectSqlByTableName(TableInfo.get(clazz).getTableName());
    }

    public static String getSelectSQLByWhere(Class<?> clazz, String strWhere) {
        TableInfo table = TableInfo.get(clazz);
        StringBuffer strSQL = new StringBuffer(SqlBuilder.getSelectSqlByTableName(table.getTableName()));
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ").append(strWhere);
        }
        return strSQL.toString();
    }

    public static SqlInfo getUpdateSqlAsSqlInfo(Object entity) {
        TableInfo table = TableInfo.get(entity.getClass());
        Object idvalue = table.getId().getValue(entity);
        if (null == idvalue) {
            throw new DbException("this entity[" + entity.getClass() + "]'s id value is null");
        }
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            KeyValue kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        if (keyValueList == null || keyValueList.size() == 0) {
            return null;
        }
        SqlInfo sqlInfo = new SqlInfo();
        StringBuffer strSQL = new StringBuffer("UPDATE ");
        strSQL.append(table.getTableName());
        strSQL.append(" SET ");
        for (KeyValue kv : keyValueList) {
            strSQL.append(kv.getKey()).append("=?,");
            sqlInfo.addValue(kv.getValue());
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        strSQL.append(" WHERE ").append(table.getId().getColumn()).append("=?");
        sqlInfo.addValue(idvalue);
        sqlInfo.setSql(strSQL.toString());
        return sqlInfo;
    }

    public static SqlInfo getUpdateSqlAsSqlInfo(Object entity, String strWhere) {
        TableInfo table = TableInfo.get(entity.getClass());
        ArrayList<KeyValue> keyValueList = new ArrayList<KeyValue>();
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            KeyValue kv = SqlBuilder.property2KeyValue(property, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne many : manyToOnes) {
            KeyValue kv = SqlBuilder.manyToOne2KeyValue(many, entity);
            if (kv == null) continue;
            keyValueList.add(kv);
        }
        if (keyValueList == null || keyValueList.size() == 0) {
            throw new DbException("this entity[" + entity.getClass() + "] has no property");
        }
        SqlInfo sqlInfo = new SqlInfo();
        StringBuffer strSQL = new StringBuffer("UPDATE ");
        strSQL.append(table.getTableName());
        strSQL.append(" SET ");
        for (KeyValue kv : keyValueList) {
            strSQL.append(kv.getKey()).append("=?,");
            sqlInfo.addValue(kv.getValue());
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        if (!TextUtils.isEmpty((CharSequence)strWhere)) {
            strSQL.append(" WHERE ").append(strWhere);
        }
        sqlInfo.setSql(strSQL.toString());
        return sqlInfo;
    }

    public static String getCreatTableSQL(Class<?> clazz) {
        TableInfo table = TableInfo.get(clazz);
        Id id2 = table.getId();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("CREATE TABLE IF NOT EXISTS ");
        strSQL.append(table.getTableName());
        strSQL.append(" ( ");
        Class<?> primaryClazz = id2.getDataType();
        if (primaryClazz == Integer.TYPE || primaryClazz == Integer.class || primaryClazz == Long.TYPE || primaryClazz == Long.class) {
            strSQL.append(id2.getColumn()).append(" INTEGER PRIMARY KEY AUTOINCREMENT,");
        } else {
            strSQL.append(id2.getColumn()).append(" TEXT PRIMARY KEY,");
        }
        Collection<Property> propertys = table.propertyMap.values();
        for (Property property : propertys) {
            strSQL.append(property.getColumn());
            Class<?> dataType = property.getDataType();
            if (dataType == Integer.TYPE || dataType == Integer.class || dataType == Long.TYPE || dataType == Long.class) {
                strSQL.append(" INTEGER");
            } else if (dataType == Float.TYPE || dataType == Float.class || dataType == Double.TYPE || dataType == Double.class) {
                strSQL.append(" REAL");
            } else if (dataType == Boolean.TYPE || dataType == Boolean.class) {
                strSQL.append(" NUMERIC");
            }
            strSQL.append(",");
        }
        Collection<ManyToOne> manyToOnes = table.manyToOneMap.values();
        for (ManyToOne manyToOne : manyToOnes) {
            strSQL.append(manyToOne.getColumn()).append(" INTEGER").append(",");
        }
        strSQL.deleteCharAt(strSQL.length() - 1);
        strSQL.append(" )");
        return strSQL.toString();
    }

    private static String getPropertyStrSql(String key, Object value) {
        StringBuffer sbSQL = new StringBuffer(key).append("=");
        if (value instanceof String || value instanceof java.util.Date || value instanceof Date) {
            sbSQL.append("'").append(value).append("'");
        } else {
            sbSQL.append(value);
        }
        return sbSQL.toString();
    }

    private static KeyValue property2KeyValue(Property property, Object entity) {
        KeyValue kv = null;
        String pcolumn = property.getColumn();
        Object value = property.getValue(entity);
        if (value != null) {
            kv = new KeyValue(pcolumn, value);
        } else if (property.getDefaultValue() != null && property.getDefaultValue().trim().length() != 0) {
            kv = new KeyValue(pcolumn, property.getDefaultValue());
        }
        return kv;
    }

    private static KeyValue manyToOne2KeyValue(ManyToOne many, Object entity) {
        KeyValue kv = null;
        String manycolumn = many.getColumn();
        Object manyobject = many.getValue(entity);
        if (manyobject != null) {
            Object manyvalue = manyobject.getClass() == ManyToOneLazyLoader.class ? TableInfo.get(many.getManyClass()).getId().getValue(((ManyToOneLazyLoader)manyobject).get()) : TableInfo.get(manyobject.getClass()).getId().getValue(manyobject);
            if (manycolumn != null && manyvalue != null) {
                kv = new KeyValue(manycolumn, manyvalue);
            }
        }
        return kv;
    }
}

