/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import android.util.Log;
import com.minggo.pluto.Pluto;
import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.db.manager.DataManagerStub;
import com.minggo.pluto.db.orm.CursorUtils;
import com.minggo.pluto.db.orm.DbException;
import com.minggo.pluto.db.orm.DbModel;
import com.minggo.pluto.db.orm.KeyValue;
import com.minggo.pluto.db.orm.ManyToOne;
import com.minggo.pluto.db.orm.ManyToOneLazyLoader;
import com.minggo.pluto.db.orm.OneToMany;
import com.minggo.pluto.db.orm.OneToManyLazyLoader;
import com.minggo.pluto.db.orm.SqlBuilder;
import com.minggo.pluto.db.orm.SqlInfo;
import com.minggo.pluto.db.orm.TableInfo;
import com.minggo.pluto.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class FinalDb
extends DataManagerStub {
    private static final String TAG = "FinalDb";
    private static HashMap<String, FinalDb> daoMap = new HashMap();
    private SQLiteDatabase db;
    private DaoConfig config;

    private FinalDb(DaoConfig config) {
        if (config == null) {
            throw new DbException("daoConfig is null");
        }
        if (config.getContext() == null) {
            throw new DbException("android context is null");
        }
        this.db = config.getTargetDirectory() != null && config.getTargetDirectory().trim().length() > 0 ? this.createDbFileOnSDCard(config.getTargetDirectory(), config.getDbName()) : new SqliteDbHelper(config.getContext().getApplicationContext(), config.getDbName(), config.getDbVersion(), config.getDbUpdateListener()).getWritableDatabase();
        this.config = config;
    }

    private static synchronized FinalDb getInstance(DaoConfig daoConfig) {
        FinalDb dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new FinalDb(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        }
        return dao;
    }

    public static FinalDb create(Context context) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setTargetDirectory(targetDirectory);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName, boolean isDebug) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setTargetDirectory(targetDirectory);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String dbName, boolean isDebug, int dbVersion, DbUpdateListener dbUpdateListener) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        config.setDbVersion(dbVersion);
        config.setDbUpdateListener(dbUpdateListener);
        return FinalDb.create(config);
    }

    public static FinalDb create(Context context, String targetDirectory, String dbName, boolean isDebug, int dbVersion, DbUpdateListener dbUpdateListener) {
        DaoConfig config = new DaoConfig();
        config.setContext(context);
        config.setTargetDirectory(targetDirectory);
        config.setDbName(dbName);
        config.setDebug(isDebug);
        config.setDbVersion(dbVersion);
        config.setDbUpdateListener(dbUpdateListener);
        return FinalDb.create(config);
    }

    public static FinalDb create(DaoConfig daoConfig) {
        return FinalDb.getInstance(daoConfig);
    }

    public void save(Object entity) {
        LogUtils.info("finalDb", ">>>>>>save data");
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildInsertSql(entity));
    }

    public void saveOrUpdate(Object entity) {
        try {
            Object idValue = TableInfo.get(entity.getClass()).getId().getValue(entity);
            if (this.findById(idValue, entity.getClass()) != null) {
                this.update(entity);
            } else {
                this.save(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean saveBindId(Object entity) {
        this.checkTableExist(entity.getClass());
        List<KeyValue> entityKvList = SqlBuilder.getSaveKeyValueListByEntity(entity);
        if (entityKvList != null && entityKvList.size() > 0) {
            TableInfo tf = TableInfo.get(entity.getClass());
            ContentValues cv = new ContentValues();
            this.insertContentValues(entityKvList, cv);
            Long id2 = this.db.insert(tf.getTableName(), null, cv);
            if (id2 == -1L) {
                return false;
            }
            tf.getId().setValue(entity, id2);
            return true;
        }
        return false;
    }

    private void insertContentValues(List<KeyValue> list, ContentValues cv) {
        if (list != null && cv != null) {
            for (KeyValue kv : list) {
                cv.put(kv.getKey(), kv.getValue().toString());
            }
        } else {
            Log.w((String)TAG, (String)"insertContentValues: List<KeyValue> is empty or ContentValues is empty!");
        }
    }

    public void update(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity));
    }

    public void update(Object entity, String strWhere) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.getUpdateSqlAsSqlInfo(entity, strWhere));
    }

    public void delete(Object entity) {
        this.checkTableExist(entity.getClass());
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(entity));
    }

    public void deleteById(Class<?> clazz, Object id2) {
        this.checkTableExist(clazz);
        this.exeSqlInfo(SqlBuilder.buildDeleteSql(clazz, id2));
    }

    public void deleteByWhere(Class<?> clazz, String strWhere) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.buildDeleteSql(clazz, strWhere);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void deleteAll(Class<?> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.buildDeleteSql(clazz, null);
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void dropTable(Class<?> clazz) {
        this.checkTableExist(clazz);
        TableInfo table = TableInfo.get(clazz);
        String sql = "DROP TABLE " + table.getTableName();
        this.debugSql(sql);
        this.db.execSQL(sql);
    }

    public void dropDb() {
        Cursor cursor = this.db.rawQuery("SELECT name FROM sqlite_master WHERE type ='table' AND name != 'sqlite_sequence'", null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                this.db.execSQL("DROP TABLE " + cursor.getString(0));
            }
        }
        if (cursor != null) {
            cursor.close();
            cursor = null;
        }
    }

    private void exeSqlInfo(SqlInfo sqlInfo) {
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            this.db.execSQL(sqlInfo.getSql(), sqlInfo.getBindArgsAsArray());
        } else {
            Log.e((String)TAG, (String)"sava error:sqlInfo is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findById(Object id2, Class<T> clazz) {
        this.checkTableExist(clazz);
        SqlInfo sqlInfo = SqlBuilder.getSelectSqlAsSqlInfo(clazz, id2);
        if (sqlInfo != null) {
            this.debugSql(sqlInfo.getSql());
            try (Cursor cursor = this.db.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStringArray());){
                if (cursor.moveToNext()) {
                    T t = CursorUtils.getEntity(cursor, clazz, this);
                    return t;
                }
            }
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id2, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id2);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadManyToOne(dbModel, entity, clazz, new Class[0]);
        }
        return null;
    }

    public <T> T findWithManyToOneById(Object id2, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id2);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadManyToOne(dbModel, entity, clazz, findClass);
        }
        return null;
    }

    public <T> T loadManyToOne(DbModel dbModel, T entity, Class<T> clazz, Class<?> ... findClass) {
        if (entity != null) {
            try {
                Collection<ManyToOne> manys = TableInfo.get(clazz).manyToOneMap.values();
                for (ManyToOne many : manys) {
                    Object manyEntity;
                    Object id2 = null;
                    if (dbModel != null) {
                        id2 = dbModel.get(many.getColumn());
                    } else if (many.getValue(entity).getClass() == ManyToOneLazyLoader.class && many.getValue(entity) != null) {
                        id2 = ((ManyToOneLazyLoader)many.getValue(entity)).getFieldValue();
                    }
                    if (id2 == null) continue;
                    boolean isFind = false;
                    if (findClass == null || findClass.length == 0) {
                        isFind = true;
                    }
                    for (Class<?> mClass : findClass) {
                        if (many.getManyClass() != mClass) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind || (manyEntity = this.findById(Integer.valueOf(id2.toString()), many.getManyClass())) == null) continue;
                    if (many.getValue(entity).getClass() == ManyToOneLazyLoader.class) {
                        if (many.getValue(entity) == null) {
                            many.setValue(entity, new ManyToOneLazyLoader(entity, clazz, many.getManyClass(), this));
                        }
                        ((ManyToOneLazyLoader)many.getValue(entity)).set(manyEntity);
                        continue;
                    }
                    many.setValue(entity, manyEntity);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    public <T> T findWithOneToManyById(Object id2, Class<T> clazz) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id2);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadOneToMany(entity, clazz, new Class[0]);
        }
        return null;
    }

    public <T> T findWithOneToManyById(Object id2, Class<T> clazz, Class<?> ... findClass) {
        this.checkTableExist(clazz);
        String sql = SqlBuilder.getSelectSQL(clazz, id2);
        this.debugSql(sql);
        DbModel dbModel = this.findDbModelBySQL(sql);
        if (dbModel != null) {
            Object entity = CursorUtils.dbModel2Entity(dbModel, clazz);
            return this.loadOneToMany(entity, clazz, findClass);
        }
        return null;
    }

    public <T> T loadOneToMany(T entity, Class<T> clazz, Class<?> ... findClass) {
        if (entity != null) {
            try {
                Collection<OneToMany> ones = TableInfo.get(clazz).oneToManyMap.values();
                Object id2 = TableInfo.get(clazz).getId().getValue(entity);
                for (OneToMany one : ones) {
                    List<?> list;
                    boolean isFind = false;
                    if (findClass == null || findClass.length == 0) {
                        isFind = true;
                    }
                    for (Class<?> mClass : findClass) {
                        if (one.getOneClass() != mClass) continue;
                        isFind = true;
                        break;
                    }
                    if (!isFind || (list = this.findAllByWhere(one.getOneClass(), one.getColumn() + "=" + id2)) == null) continue;
                    if (one.getDataType() == OneToManyLazyLoader.class) {
                        OneToManyLazyLoader oneToManyLazyLoader = (OneToManyLazyLoader)one.getValue(entity);
                        oneToManyLazyLoader.setList(list);
                        continue;
                    }
                    one.setValue(entity, list);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return entity;
    }

    public <T> List<T> findAll(Class<T> clazz) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQL(clazz));
    }

    public <T> List<T> findAll(Class<T> clazz, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQL(clazz) + " ORDER BY " + orderBy);
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQLByWhere(clazz, strWhere));
    }

    public <T> T findModelByWhere(Class<T> clazz, String strWhere) {
        this.checkTableExist(clazz);
        return this.findModelBySql(clazz, SqlBuilder.getSelectSQLByWhere(clazz, strWhere));
    }

    public <T> List<T> findAllByWhere(Class<T> clazz, String strWhere, String orderBy) {
        this.checkTableExist(clazz);
        return this.findAllBySql(clazz, SqlBuilder.getSelectSQLByWhere(clazz, strWhere) + " ORDER BY " + orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> findAllBySql(Class<T> clazz, String strSQL) {
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            ArrayList<T> list = new ArrayList<T>();
            while (cursor.moveToNext()) {
                T t = CursorUtils.getEntity(cursor, clazz, this);
                list.add(t);
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findModelBySql(Class<T> clazz, String strSQL) {
        this.checkTableExist(clazz);
        this.debugSql(strSQL);
        Cursor cursor = this.db.rawQuery(strSQL, null);
        try {
            T t = null;
            if (cursor.moveToNext()) {
                t = CursorUtils.getEntity(cursor, clazz, this);
            }
            T t2 = t;
            return t2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbModel findDbModelBySQL(String strSQL) {
        this.debugSql(strSQL);
        try (Cursor cursor = this.db.rawQuery(strSQL, null);){
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DbModel> findDbModelListBySQL(String strSQL) {
        this.debugSql(strSQL);
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        try (Cursor cursor = this.db.rawQuery(strSQL, null);){
            while (cursor.moveToNext()) {
                dbModelList.add(CursorUtils.getDbModel(cursor));
            }
        }
        return dbModelList;
    }

    private void checkTableExist(Class<?> clazz) {
        if (!this.tableIsExist(TableInfo.get(clazz))) {
            String sql = SqlBuilder.getCreatTableSQL(clazz);
            this.debugSql(sql);
            this.db.execSQL(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableIsExist(TableInfo table) {
        if (table.isCheckDatabese()) {
            return true;
        }
        Cursor cursor = null;
        try {
            int count;
            String sql = "SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "' ";
            this.debugSql(sql);
            cursor = this.db.rawQuery(sql, null);
            if (cursor != null && cursor.moveToNext() && (count = cursor.getInt(0)) > 0) {
                table.setCheckDatabese(true);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            cursor = null;
        }
        return false;
    }

    private void debugSql(String sql) {
        if (this.config != null && this.config.isDebug()) {
            LogUtils.info("Debug SQL", ">>>>>>  " + sql);
        }
    }

    private SQLiteDatabase createDbFileOnSDCard(String sdcardPath, String dbfilename) {
        block4: {
            File dbf = new File(sdcardPath, dbfilename);
            LogUtils.info("dbf.getAbsolutePath():" + dbf.getAbsolutePath());
            if (!dbf.exists()) {
                try {
                    if (dbf.createNewFile()) {
                        return SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
                    }
                    break block4;
                }
                catch (IOException ioex) {
                    throw new DbException("\u6570\u636e\u5e93\u6587\u4ef6\u521b\u5efa\u5931\u8d25", ioex);
                }
            }
            return SQLiteDatabase.openOrCreateDatabase((File)dbf, null);
        }
        return null;
    }

    @Override
    public void saveData(Object key, Object object) {
        super.saveData(key, object);
        this.save(object);
    }

    @Override
    public <T> T queryData(Object key, Class<T> clazz) {
        return this.findById(key, clazz);
    }

    @Override
    public void updateData(Object key, Object object) {
        super.updateData(key, object);
        this.update(object);
    }

    @Override
    public <T> void deleteData(Object key, Class<T> clazz) {
        super.deleteData(key, clazz);
        this.deleteById(clazz, key);
    }

    public static interface DbUpdateListener {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);
    }

    class SqliteDbHelper
    extends SQLiteOpenHelper {
        private DbUpdateListener mDbUpdateListener;

        public SqliteDbHelper(Context context, String name, int version, DbUpdateListener dbUpdateListener) {
            super(context, name, null, version);
            this.mDbUpdateListener = dbUpdateListener;
        }

        public void onCreate(SQLiteDatabase db) {
            LogUtils.info(db.toString() + "|Version:" + db.getVersion());
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            LogUtils.info(String.format("oldV:%d newV:%d", oldVersion, newVersion));
            if (this.mDbUpdateListener != null) {
                this.mDbUpdateListener.onUpgrade(db, oldVersion, newVersion);
            }
        }

        private void tableAddColumns(SQLiteDatabase db, int oldVersion, int newVersion, int addColumnVersion, Class<?> tableClass, String ... addColumnName) {
            if (addColumnName != null) {
                for (String columnName : addColumnName) {
                    this.tableAddColumn(db, oldVersion, newVersion, addColumnVersion, tableClass, columnName);
                }
            }
        }

        private void tableAddColumn(SQLiteDatabase db, int oldVersion, int newVersion, int addColumnVersion, Class<?> tableClass, String addColumnName) {
            LogUtils.info("----------------tableAddColumn Start-------------------");
            LogUtils.info(String.format("oldV:%d addV:%d table:%s column:%s", oldVersion, addColumnVersion, tableClass + "", addColumnName));
            if (addColumnVersion <= newVersion && addColumnVersion > oldVersion && tableClass != null && !TextUtils.isEmpty((CharSequence)addColumnName)) {
                TableInfo userTableInfo = TableInfo.get(tableClass);
                String tableName = userTableInfo.getTableName();
                LogUtils.info(this.getPropertyMapStr(userTableInfo));
                boolean isFieldExist = this.isFieldExist(db, tableName, addColumnName);
                LogUtils.info(String.format("%s %s isFieldExist:%b", tableName, addColumnName, isFieldExist));
                if (!isFieldExist) {
                    String sql = String.format("ALTER TABLE %s ADD COLUMN %s text", tableName, addColumnName);
                    LogUtils.info(sql);
                    db.execSQL(sql);
                    LogUtils.info(String.format("%s %s isFieldExist:%b", tableName, addColumnName, this.isFieldExist(db, tableName, addColumnName)));
                }
            }
            LogUtils.info("----------------tableAddColumn End-------------------");
        }

        private String getPropertyMapStr(TableInfo tableInfo) {
            Set<String> keySet = tableInfo.propertyMap.keySet();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(tableInfo.getTableName()).append(":");
            for (String s : keySet) {
                stringBuilder.append(s).append(",");
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isFieldExist(SQLiteDatabase db, String tableName, String fieldName) {
            String queryStr = "select sql from sqlite_master where type = 'table' and name = '%s'";
            queryStr = String.format(queryStr, tableName);
            String tableCreateSql = null;
            try (Cursor c = db.rawQuery(queryStr, null);){
                if (c != null && c.moveToFirst()) {
                    tableCreateSql = c.getString(c.getColumnIndex("sql"));
                }
            }
            return tableCreateSql != null && tableCreateSql.contains(fieldName);
        }
    }

    public static class DaoConfig {
        private Context mContext;
        private String mDbName;
        private int dbVersion;
        private boolean debug;
        private DbUpdateListener dbUpdateListener;
        private String targetDirectory;

        public DaoConfig() {
            this.mContext = AppContext.getInstance().context;
            this.mDbName = Pluto.DBConfig.NAME;
            this.dbVersion = Pluto.DBConfig.VERSION;
            this.debug = true;
        }

        public Context getContext() {
            return this.mContext;
        }

        public void setContext(Context context) {
            this.mContext = context;
        }

        public String getDbName() {
            return this.mDbName;
        }

        public void setDbName(String dbName) {
            this.mDbName = dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public DbUpdateListener getDbUpdateListener() {
            return this.dbUpdateListener;
        }

        public void setDbUpdateListener(DbUpdateListener dbUpdateListener) {
            this.dbUpdateListener = dbUpdateListener;
        }

        public String getTargetDirectory() {
            return this.targetDirectory;
        }

        public void setTargetDirectory(String targetDirectory) {
            this.targetDirectory = targetDirectory;
        }
    }
}

