/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import android.database.Cursor;
import com.minggo.pluto.db.orm.DbModel;
import com.minggo.pluto.db.orm.FinalDb;
import com.minggo.pluto.db.orm.ManyToOne;
import com.minggo.pluto.db.orm.ManyToOneLazyLoader;
import com.minggo.pluto.db.orm.OneToMany;
import com.minggo.pluto.db.orm.OneToManyLazyLoader;
import com.minggo.pluto.db.orm.Property;
import com.minggo.pluto.db.orm.TableInfo;
import java.util.HashMap;
import java.util.Map;

public class CursorUtils {
    public static <T> T getEntity(Cursor cursor, Class<T> clazz, FinalDb db) {
        try {
            if (cursor != null) {
                TableInfo table = TableInfo.get(clazz);
                int columnCount = cursor.getColumnCount();
                if (columnCount > 0) {
                    T entity = clazz.newInstance();
                    for (int i = 0; i < columnCount; ++i) {
                        String column = cursor.getColumnName(i);
                        Property property = table.propertyMap.get(column);
                        if (property != null) {
                            property.setValue(entity, cursor.getString(i));
                            continue;
                        }
                        if (!table.getId().getColumn().equals(column)) continue;
                        table.getId().setValue(entity, cursor.getString(i));
                    }
                    for (OneToMany oneToManyProp : table.oneToManyMap.values()) {
                        if (oneToManyProp.getDataType() != OneToManyLazyLoader.class) continue;
                        OneToManyLazyLoader oneToManyLazyLoader = new OneToManyLazyLoader(entity, clazz, oneToManyProp.getOneClass(), db);
                        oneToManyProp.setValue(entity, oneToManyLazyLoader);
                    }
                    for (ManyToOne manyToOneProp : table.manyToOneMap.values()) {
                        if (manyToOneProp.getDataType() != ManyToOneLazyLoader.class) continue;
                        ManyToOneLazyLoader manyToOneLazyLoader = new ManyToOneLazyLoader(entity, clazz, manyToOneProp.getManyClass(), db);
                        manyToOneLazyLoader.setFieldValue(cursor.getInt(cursor.getColumnIndex(manyToOneProp.getColumn())));
                        manyToOneProp.setValue(entity, manyToOneLazyLoader);
                    }
                    return entity;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static DbModel getDbModel(Cursor cursor) {
        if (cursor != null && cursor.getColumnCount() > 0) {
            DbModel model = new DbModel();
            int columnCount = cursor.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                model.set(cursor.getColumnName(i), cursor.getString(i));
            }
            return model;
        }
        return null;
    }

    public static <T> T dbModel2Entity(DbModel dbModel, Class<?> clazz) {
        if (dbModel != null) {
            HashMap<String, Object> dataMap = dbModel.getDataMap();
            try {
                Object entity = clazz.newInstance();
                for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                    String column = entry.getKey();
                    TableInfo table = TableInfo.get(clazz);
                    Property property = table.propertyMap.get(column);
                    if (property != null) {
                        property.setValue(entity, entry.getValue() == null ? null : entry.getValue().toString());
                        continue;
                    }
                    if (!table.getId().getColumn().equals(column)) continue;
                    table.getId().setValue(entity, entry.getValue() == null ? null : entry.getValue().toString());
                }
                return (T)entity;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

