/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import com.minggo.pluto.db.orm.DbException;
import com.minggo.pluto.db.orm.FieldUtils;
import com.minggo.pluto.db.orm.Id_A;
import com.minggo.pluto.db.orm.ManyToOne;
import com.minggo.pluto.db.orm.ManyToOneLazyLoader;
import com.minggo.pluto.db.orm.OneToMany;
import com.minggo.pluto.db.orm.Property;
import com.minggo.pluto.db.orm.Table;
import com.minggo.pluto.util.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ClassUtils {
    public static String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table == null || table.name().trim().length() == 0) {
            return clazz.getName().replace('.', '_');
        }
        return table.name();
    }

    public static Object getPrimaryKeyValue(Object entity) {
        return FieldUtils.getFieldValue(entity, ClassUtils.getPrimaryKeyField(entity.getClass()));
    }

    public static String getPrimaryKeyColumn(Class<?> clazz) {
        String primaryKey = null;
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            Id_A idAnnotation = null;
            Field idField = null;
            for (Field field : fields) {
                idAnnotation = field.getAnnotation(Id_A.class);
                if (idAnnotation == null) continue;
                idField = field;
                break;
            }
            if (idAnnotation != null) {
                primaryKey = idAnnotation.column();
                if (primaryKey == null || primaryKey.trim().length() == 0) {
                    primaryKey = idField.getName();
                }
            } else {
                for (Field field : fields) {
                    if (!"_id".equals(field.getName())) continue;
                    return "_id";
                }
                for (Field field : fields) {
                    if (!"id".equals(field.getName())) continue;
                    return "id";
                }
            }
        } else {
            throw new RuntimeException("this model[" + clazz + "] has no field");
        }
        return primaryKey;
    }

    public static Field getPrimaryKeyField(Class<?> clazz) {
        Field primaryKeyField = null;
        Field[] fields = clazz.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                if (field.getAnnotation(Id_A.class) == null) continue;
                LogUtils.info("finalDb", ">>>>>idFeild is not null");
                primaryKeyField = field;
                break;
            }
            if (primaryKeyField == null) {
                for (Field field : fields) {
                    if (!"_id".equals(field.getName())) continue;
                    primaryKeyField = field;
                    break;
                }
            }
            if (primaryKeyField == null) {
                for (Field field : fields) {
                    if (!"id".equals(field.getName())) continue;
                    primaryKeyField = field;
                    break;
                }
            }
        } else {
            throw new RuntimeException("this model[" + clazz + "] has no field");
        }
        return primaryKeyField;
    }

    public static String getPrimaryKeyFieldName(Class<?> clazz) {
        Field f = ClassUtils.getPrimaryKeyField(clazz);
        return f == null ? null : f.getName();
    }

    public static List<Property> getPropertyList(Class<?> clazz) {
        ArrayList<Property> plist = new ArrayList<Property>();
        try {
            Field[] fs = clazz.getDeclaredFields();
            String primaryKeyFieldName = ClassUtils.getPrimaryKeyFieldName(clazz);
            for (Field f : fs) {
                if (FieldUtils.isTransient(f) || !FieldUtils.isBaseDateType(f) || f.getName().equals(primaryKeyFieldName)) continue;
                Property property = new Property();
                property.setColumn(FieldUtils.getColumnByField(f));
                property.setFieldName(f.getName());
                property.setDataType(f.getType());
                property.setDefaultValue(FieldUtils.getPropertyDefaultValue(f));
                property.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                property.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                property.setField(f);
                plist.add(property);
            }
            return plist;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<ManyToOne> getManyToOneList(Class<?> clazz) {
        ArrayList<ManyToOne> mList = new ArrayList<ManyToOne>();
        try {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                if (FieldUtils.isTransient(f) || !FieldUtils.isManyToOne(f)) continue;
                ManyToOne mto = new ManyToOne();
                if (f.getType() == ManyToOneLazyLoader.class) {
                    Class pClazz = (Class)((ParameterizedType)f.getGenericType()).getActualTypeArguments()[1];
                    if (pClazz != null) {
                        mto.setManyClass(pClazz);
                    }
                } else {
                    mto.setManyClass(f.getType());
                }
                mto.setColumn(FieldUtils.getColumnByField(f));
                mto.setFieldName(f.getName());
                mto.setDataType(f.getType());
                mto.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                mto.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                mList.add(mto);
            }
            return mList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static List<OneToMany> getOneToManyList(Class<?> clazz) {
        ArrayList<OneToMany> oList = new ArrayList<OneToMany>();
        try {
            Field[] fs;
            for (Field f : fs = clazz.getDeclaredFields()) {
                if (FieldUtils.isTransient(f) || !FieldUtils.isOneToMany(f)) continue;
                OneToMany otm = new OneToMany();
                otm.setColumn(FieldUtils.getColumnByField(f));
                otm.setFieldName(f.getName());
                Type type = f.getGenericType();
                if (type instanceof ParameterizedType) {
                    Class pClazz;
                    ParameterizedType pType = (ParameterizedType)f.getGenericType();
                    if (pType.getActualTypeArguments().length == 1) {
                        pClazz = (Class)pType.getActualTypeArguments()[0];
                        if (pClazz != null) {
                            otm.setOneClass(pClazz);
                        }
                    } else {
                        pClazz = (Class)pType.getActualTypeArguments()[1];
                        if (pClazz != null) {
                            otm.setOneClass(pClazz);
                        }
                    }
                } else {
                    throw new DbException("getOneToManyList Exception:" + f.getName() + "'s type is null");
                }
                otm.setDataType(f.getType());
                otm.setSet(FieldUtils.getFieldSetMethod(clazz, f));
                otm.setGet(FieldUtils.getFieldGetMethod(clazz, f));
                oList.add(otm);
            }
            return oList;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

