/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.manager;

import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.db.manager.DataManager;
import com.minggo.pluto.db.orm.FinalDb;
import com.minggo.pluto.util.LogUtils;
import com.minggo.pluto.util.PlutoFileCache;
import com.minggo.pluto.util.SharePreferenceUtils;
import java.util.List;

public class DataManagerProxy
implements DataManager {
    public static final String TAG = "DATA_MANAGER";
    private DataManager dataManagerStub;

    public DataManagerProxy(DataType type) {
        this.getDataManager(type);
    }

    private DataManager getDataManager(DataType type) {
        switch (type) {
            case SQLITE: {
                this.dataManagerStub = FinalDb.create(AppContext.getInstance().context);
                break;
            }
            case FILECACHE: {
                this.dataManagerStub = PlutoFileCache.getInstance();
                break;
            }
            case SHAREPREFERENCE: {
                this.dataManagerStub = SharePreferenceUtils.getInstance();
                break;
            }
        }
        return this.dataManagerStub;
    }

    @Override
    public void saveData(Object key, Object object) {
        this.dataManagerStub.saveData(key, object);
    }

    @Override
    public <T> T queryData(Object key, Class<T> clazz) {
        return this.dataManagerStub.queryData(key, clazz);
    }

    @Override
    public <T> void deleteData(Object key, Class<T> clazz) {
        this.dataManagerStub.deleteData(key, clazz);
    }

    @Override
    public void updateData(Object key, Object object) {
        this.dataManagerStub.updateData(key, object);
    }

    public <T> T queryModelData(Class<T> clazz, String selectArg) {
        if (this.dataManagerStub instanceof FinalDb) {
            return ((FinalDb)this.dataManagerStub).findModelByWhere(clazz, selectArg);
        }
        LogUtils.info(TAG, "\u4ee3\u7406\u7c7b\u578b\u4e0d\u662f FinalDb");
        return null;
    }

    public <T> List<T> queryListData(Class<T> clazz, String selectArg) {
        if (this.dataManagerStub instanceof FinalDb) {
            return ((FinalDb)this.dataManagerStub).findAllByWhere(clazz, selectArg);
        }
        LogUtils.info(TAG, "\u4ee3\u7406\u7c7b\u578b\u4e0d\u662f FinalDb");
        return null;
    }

    public boolean saveOrUpdate(Object object) {
        if (this.dataManagerStub instanceof FinalDb) {
            ((FinalDb)this.dataManagerStub).saveOrUpdate(object);
            return true;
        }
        LogUtils.info(TAG, "this methord just can be used when DataManager is FinalDb's instance");
        return false;
    }

    public boolean isExpiredFile(String key, int min) {
        if (this.dataManagerStub instanceof PlutoFileCache) {
            return ((PlutoFileCache)this.dataManagerStub).isCacheDataFailure(key, min);
        }
        LogUtils.info(TAG, "this methord just can be used when DataManager is PlutoFileCache instance");
        return false;
    }

    public boolean saveByNameAndKey(String name, String key, Object data) {
        if (this.dataManagerStub instanceof SharePreferenceUtils) {
            if (data instanceof Integer) {
                ((SharePreferenceUtils)this.dataManagerStub).putInt(name, key, (Integer)data);
            } else if (data instanceof String) {
                ((SharePreferenceUtils)this.dataManagerStub).putString(name, key, data.toString());
            } else if (data instanceof Boolean) {
                ((SharePreferenceUtils)this.dataManagerStub).putBoolean(name, key, (Boolean)data);
            }
            return true;
        }
        LogUtils.info(TAG, "this methord just can be used when DataManager is SharePreferenceUtils instance");
        return false;
    }

    public <T> T queryByNameAndKey(String name, String key, Class<T> clazz) {
        Object t = null;
        if (this.dataManagerStub instanceof SharePreferenceUtils) {
            if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
                t = ((SharePreferenceUtils)this.dataManagerStub).getInt(name, key, 0);
            } else if (clazz.equals(String.class)) {
                t = ((SharePreferenceUtils)this.dataManagerStub).getString(name, key);
            } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                t = ((SharePreferenceUtils)this.dataManagerStub).getBoolean(name, key);
            }
            return (T)t;
        }
        LogUtils.info(TAG, "this methord just can be used when DataManager is SharePreferenceUtils instance");
        return null;
    }

    public static enum DataType {
        SQLITE,
        FILECACHE,
        SHAREPREFERENCE;

    }
}

