/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.common;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Environment;
import android.widget.Toast;
import com.minggo.pluto.Pluto;
import com.minggo.pluto.R;
import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.common.AppManager;
import com.minggo.pluto.util.FileUtils;
import com.minggo.pluto.util.LogUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import org.apache.commons.httpclient.HttpException;

public class PlutoException
extends Exception
implements Thread.UncaughtExceptionHandler {
    private static final long serialVersionUID = -2802147109149812598L;
    private static final boolean Debug = true;
    public static String filepath = Pluto.SDPATH + "/errlog/";
    private static String crashfilepath = Pluto.SDPATH + "/crashlog/";
    public static String filename = "err_log.txt";
    private static PlutoException appException;
    public static final byte TYPE_NETWORK = 1;
    public static final byte TYPE_SOCKET = 2;
    public static final byte TYPE_HTTP_CODE = 3;
    public static final byte TYPE_HTTP_ERROR = 4;
    public static final byte TYPE_XML = 5;
    public static final byte TYPE_IO = 6;
    public static final byte TYPE_RUN = 7;
    private byte type;
    private int code;
    private Thread.UncaughtExceptionHandler mDefaultHandler;

    private PlutoException(Context context) {
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    private PlutoException(byte type, int code, Exception excp) {
        super(excp);
        this.type = type;
        this.code = code;
        this.saveErrorLog(excp);
    }

    public int getCode() {
        return this.code;
    }

    public int getType() {
        return this.type;
    }

    public void makeToast(Context ctx) {
        switch (this.getType()) {
            case 3: {
                String err = ctx.getString(R.string.http_status_code_error, new Object[]{this.getCode()});
                Toast.makeText((Context)ctx, (CharSequence)err, (int)0).show();
                break;
            }
            case 4: {
                Toast.makeText((Context)ctx, (int)R.string.http_exception_error, (int)0).show();
                break;
            }
            case 2: {
                Toast.makeText((Context)ctx, (int)R.string.socket_exception_error, (int)0).show();
                break;
            }
            case 1: {
                Toast.makeText((Context)ctx, (int)R.string.network_not_connected, (int)0).show();
                break;
            }
            case 5: {
                Toast.makeText((Context)ctx, (int)R.string.xml_parser_failed, (int)0).show();
                break;
            }
            case 6: {
                Toast.makeText((Context)ctx, (int)R.string.io_exception_error, (int)0).show();
                break;
            }
            case 7: {
                Toast.makeText((Context)ctx, (int)R.string.app_run_code_error, (int)0).show();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveErrorLog(Exception excp) {
        String savePath = "";
        String logFilePath = "";
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            String storageState = Environment.getExternalStorageState();
            if (storageState.equals("mounted")) {
                savePath = filepath;
                File file = new File(savePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                logFilePath = savePath + filename;
            }
            if (logFilePath == "") {
                return;
            }
            File logFile = new File(logFilePath);
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
            fw = new FileWriter(logFile, true);
            pw = new PrintWriter(fw);
            pw.println("\n");
            pw.println("\n--------------------" + new Date().toLocaleString() + "---------------------\n");
            excp.printStackTrace(pw);
            StringBuffer exceptionStr = new StringBuffer();
            exceptionStr.append("Cause by:");
            StackTraceElement[] caseElements = excp.getCause().getStackTrace();
            for (int i = 0; i < caseElements.length; ++i) {
                exceptionStr.append(caseElements[i].toString() + "\n");
            }
            pw.println(exceptionStr.toString());
            excp.printStackTrace(pw);
            pw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static PlutoException http(int code) {
        return new PlutoException(3, code, null);
    }

    public static PlutoException http(Exception e) {
        return new PlutoException(4, 0, e);
    }

    public static PlutoException socket(Exception e) {
        return new PlutoException(2, 0, e);
    }

    public static PlutoException io(Exception e) {
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return new PlutoException(1, 0, e);
        }
        if (e instanceof IOException) {
            return new PlutoException(6, 0, e);
        }
        return PlutoException.run(e);
    }

    public static PlutoException xml(Exception e) {
        return new PlutoException(5, 0, e);
    }

    public static PlutoException network(Exception e) {
        if (e instanceof UnknownHostException || e instanceof ConnectException) {
            return new PlutoException(1, 0, e);
        }
        if (e instanceof HttpException) {
            return PlutoException.http(e);
        }
        if (e instanceof SocketException) {
            return PlutoException.socket(e);
        }
        return PlutoException.http(e);
    }

    public static PlutoException run(Exception e) {
        return new PlutoException(7, 0, e);
    }

    public static PlutoException getAppExceptionHandler(Context context) {
        if (appException == null) {
            appException = new PlutoException(context);
        }
        return appException;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        }
    }

    private boolean handleException(Throwable ex) {
        LogUtils.info("plutoexception", ">>>>>handle exception");
        if (ex == null) {
            return false;
        }
        Activity context = AppManager.getAppManager().currentActivity();
        if (context == null) {
            LogUtils.info("plutoexception", ">>>>>context is null");
            return false;
        }
        final String crashReport = this.getCrashReport(ex);
        ex.printStackTrace();
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileUtils.WriterTxtFile(filepath, filename, crashReport, true);
                FileUtils.WriterTxtFile(crashfilepath, filename, crashReport, true);
            }
        }).start();
        System.out.println("<<<handleException:" + ex.getMessage());
        return true;
    }

    public static void sendAppCrashReport(Context cont, String crashReport) {
        AlertDialog.Builder builder = new AlertDialog.Builder(cont);
        builder.setIcon(17301659);
        builder.setTitle(R.string.app_error);
        builder.setMessage(R.string.app_error_message);
        builder.setPositiveButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                LogUtils.debug("AppException UIHelper", "\u6709\u5f02\u5e38\u65e5\u5fd7\uff0c\u4e0b\u6b21\u6253\u5f00\u63d0\u4ea4");
                System.exit(0);
            }
        });
        builder.setNegativeButton((CharSequence)"\u53d1\u9001", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                try {
                    File file = new File(filepath);
                    if (file.exists() && (file = new File(filepath + filename)).exists()) {
                        file.delete();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.exit(0);
            }
        });
        builder.show();
    }

    private String getCrashReport(Throwable ex) {
        PackageInfo pinfo = AppContext.getInstance().getPackageInfo();
        StringBuffer exceptionStr = new StringBuffer();
        exceptionStr.append("\n------------------" + new Date().toLocaleString() + "-----------------------\n");
        exceptionStr.append("Version: " + pinfo.versionName + "(" + pinfo.versionCode + ")\n");
        exceptionStr.append("Android: " + Build.VERSION.RELEASE + "(" + Build.MODEL + ")\n");
        exceptionStr.append("Exception: " + ex.getMessage() + "\n");
        StackTraceElement[] elements = ex.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            exceptionStr.append(elements[i].toString() + "\n");
        }
        exceptionStr.append("Cause by:");
        StackTraceElement[] caseElements = ex.getCause().getStackTrace();
        for (int i = 0; i < caseElements.length; ++i) {
            exceptionStr.append(caseElements[i].toString() + "\n");
        }
        return exceptionStr.toString();
    }
}

