/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.common;

import android.os.Handler;
import android.os.Message;
import android.os.Process;
import com.google.gson.Gson;
import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.common.AsyncTaskManager;
import com.minggo.pluto.util.LogUtils;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class CommonAsyncTask<Params, Progress, Result>
implements Observer {
    private static final String TAG = "CommonAsyncTask";
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 5;
    private static final int KEEP_ALIVE = 10;
    private static final BlockingQueue<Runnable> sWorkQueue = new ArrayBlockingQueue<Runnable>(120);
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "CommonAsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final ThreadPoolExecutor sExecutor = new ThreadPoolExecutor(5, 5, 10L, TimeUnit.SECONDS, sWorkQueue, sThreadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
    private static final int MESSAGE_POST_RESULT = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static final int MESSAGE_POST_CANCEL = 3;
    private static final InternalHandler sHandler = new InternalHandler();
    private final WorkerRunnable<Params, Result> mWorker;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    protected Gson gson = new Gson();

    public CommonAsyncTask() {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                Process.setThreadPriority((int)10);
                return CommonAsyncTask.this.doInBackground(this.mParams);
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                Object result = null;
                try {
                    if (this.isCancelled()) {
                        Message message = sHandler.obtainMessage(3, new UserTaskResult<Object>(CommonAsyncTask.this, null));
                        message.sendToTarget();
                        return;
                    }
                    result = this.get();
                }
                catch (InterruptedException e) {
                    LogUtils.error(CommonAsyncTask.TAG, e.toString());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occured while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    Message message = sHandler.obtainMessage(3, new UserTaskResult<Object>(CommonAsyncTask.this, null));
                    message.sendToTarget();
                    return;
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occured while executing doInBackground()", t);
                }
                Message message = sHandler.obtainMessage(1, new UserTaskResult<Object>(CommonAsyncTask.this, result));
                message.sendToTarget();
            }
        };
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute(Params ... params) {
    }

    protected void onPostExecute(Result result) {
    }

    protected void onProgressUpdate(Progress ... values) {
    }

    protected void onCancelled() {
        AppContext.getInstance().getAsyncTaskManager().deleteObserver(this);
    }

    public final boolean isCancelled() {
        return this.mFuture.isCancelled();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    public final CommonAsyncTask<Params, Progress, Result> execute(Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute(params);
        this.mWorker.mParams = params;
        AppContext.getInstance().getAsyncTaskManager().addTask(this);
        sExecutor.execute(this.mFuture);
        return this;
    }

    protected final void publishProgress(Progress ... values) {
        sHandler.obtainMessage(2, new UserTaskResult<Progress>(this, values)).sendToTarget();
    }

    private void finish(Result result) {
        this.onPostExecute(result);
        this.mStatus = Status.FINISHED;
        AppContext.getInstance().getAsyncTaskManager().deleteObserver(this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (AsyncTaskManager.CANCEL_ALL == (Integer)arg && this.getStatus() == Status.RUNNING) {
            this.cancel(true);
        }
    }

    private static class UserTaskResult<Data> {
        final CommonAsyncTask mTask;
        final Data[] mData;

        UserTaskResult(CommonAsyncTask task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        private WorkerRunnable() {
        }
    }

    private static class InternalHandler
    extends Handler {
        private InternalHandler() {
        }

        public void handleMessage(Message msg) {
            UserTaskResult result = (UserTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    if (result.mTask.isCancelled()) {
                        result.mTask.cancel(true);
                        break;
                    }
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                    break;
                }
                case 3: {
                    result.mTask.cancel(true);
                }
            }
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

