/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.minggo.pluto.bitmap.RecyclingBitmapDrawable;

public class RecyclingImageView
extends ImageView {
    public RecyclingImageView(Context context) {
        super(context);
    }

    public RecyclingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDetachedFromWindow() {
        this.setImageDrawable(null);
        super.onDetachedFromWindow();
    }

    public void setImageDrawable(Drawable drawable2) {
        Drawable previousDrawable = this.getDrawable();
        super.setImageDrawable(drawable2);
        RecyclingImageView.notifyDrawable(drawable2, true);
        RecyclingImageView.notifyDrawable(previousDrawable, false);
    }

    private static void notifyDrawable(Drawable drawable2, boolean isDisplayed) {
        if (drawable2 instanceof RecyclingBitmapDrawable) {
            ((RecyclingBitmapDrawable)drawable2).setIsDisplayed(isDisplayed);
        } else if (drawable2 instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)drawable2;
            int z = layerDrawable.getNumberOfLayers();
            for (int i = 0; i < z; ++i) {
                RecyclingImageView.notifyDrawable(layerDrawable.getDrawable(i), isDisplayed);
            }
        }
    }
}

