/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;
import com.minggo.pluto.bitmap.BitmapCommonUtils;
import com.minggo.pluto.bitmap.FileNameGenerator;
import com.minggo.pluto.bitmap.LruDiskCache;
import com.minggo.pluto.bitmap.LruMemoryCache;
import com.minggo.pluto.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapCache {
    private static final String TAG = "ImageCache";
    private static final int DEFAULT_MEM_CACHE_SIZE = 0x800000;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0x1400000;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 90;
    private static final int DISK_CACHE_INDEX = 0;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private static final boolean DEFAULT_CLEAR_DISK_CACHE_ON_START = false;
    private static final boolean DEFAULT_INIT_DISK_CACHE_ON_CREATE = false;
    private LruDiskCache mDiskLruCache;
    private LruMemoryCache<String, Bitmap> mMemoryCache;
    private ImageCacheParams mCacheParams;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;

    public BitmapCache(ImageCacheParams cacheParams) {
        this.init(cacheParams);
    }

    private void init(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
        if (this.mCacheParams.memoryCacheEnabled) {
            this.mMemoryCache = new LruMemoryCache<String, Bitmap>(this.mCacheParams.memCacheSize){

                @Override
                protected int sizeOf(String key, Bitmap bitmap) {
                    return BitmapCommonUtils.getBitmapSize(bitmap);
                }
            };
        }
        if (cacheParams.initDiskCacheOnCreate) {
            this.initDiskCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) {
                File diskCacheDir = this.mCacheParams.diskCacheDir;
                if (this.mCacheParams.diskCacheEnabled && diskCacheDir != null) {
                    if (!diskCacheDir.exists()) {
                        diskCacheDir.mkdirs();
                    }
                    if (BitmapCommonUtils.getUsableSpace(diskCacheDir) > (long)this.mCacheParams.diskCacheSize) {
                        try {
                            this.mDiskLruCache = LruDiskCache.open(diskCacheDir, 1, 1, this.mCacheParams.diskCacheSize);
                        }
                        catch (IOException e) {
                            this.mCacheParams.diskCacheDir = null;
                            Log.e((String)TAG, (String)("initDiskCache - " + e));
                        }
                    }
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBitmapToCache(String data, Bitmap bitmap) {
        if (data == null || bitmap == null) {
            return;
        }
        if (this.mMemoryCache != null && this.mMemoryCache.get(data) == null) {
            this.mMemoryCache.put(data, bitmap);
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                String key = FileNameGenerator.generator(data);
                OutputStream out = null;
                try {
                    LruDiskCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot == null) {
                        LruDiskCache.Editor editor = this.mDiskLruCache.edit(key);
                        if (editor != null) {
                            out = editor.newOutputStream(0);
                            LogUtils.info("data-->" + data + " key-->" + data);
                            bitmap.compress(this.getImageType(data), this.mCacheParams.compressQuality, out);
                            editor.commit();
                            out.close();
                        }
                    } else {
                        snapshot.getInputStream(0).close();
                    }
                }
                catch (IOException e) {
                    LogUtils.error(TAG, "addBitmapToCache - " + e);
                }
                catch (Exception e) {
                    LogUtils.error(TAG, "addBitmapToCache - " + e);
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Bitmap.CompressFormat getImageType(String data) {
        Bitmap.CompressFormat type = Bitmap.CompressFormat.PNG;
        return type;
    }

    public Bitmap getBitmapFromMemCache(Context context, int resId) {
        if (this.mMemoryCache != null) {
            Bitmap memBitmap = this.mMemoryCache.get(resId + "");
            if (memBitmap != null) {
                return memBitmap;
            }
            memBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
            if (memBitmap != null) {
                this.mMemoryCache.put(resId + "", memBitmap);
                return memBitmap;
            }
        }
        return null;
    }

    public Bitmap getBitmapFromMemCache(String data) {
        Bitmap memBitmap;
        if (this.mMemoryCache != null && (memBitmap = this.mMemoryCache.get(data)) != null) {
            return memBitmap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromDiskCache(String data) {
        String key = FileNameGenerator.generator(data);
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mDiskLruCache != null) {
                InputStream inputStream = null;
                try {
                    LruDiskCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot != null && (inputStream = snapshot.getInputStream(0)) != null) {
                        Bitmap bitmap;
                        Bitmap bitmap2 = bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                        return bitmap2;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("getBitmapFromDiskCache - " + e));
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.clearMemoryCache();
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    public void clearMemoryCache() {
        if (this.mMemoryCache != null) {
            this.mMemoryCache.evictAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("close - " + e));
                }
            }
        }
    }

    static /* synthetic */ Bitmap.CompressFormat access$000() {
        return DEFAULT_COMPRESS_FORMAT;
    }

    public static class ImageCacheParams {
        public int memCacheSize = 0x800000;
        public int diskCacheSize = 0x1400000;
        public File diskCacheDir;
        public Bitmap.CompressFormat compressFormat = BitmapCache.access$000();
        public int compressQuality = 90;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean clearDiskCacheOnStart = false;
        public boolean initDiskCacheOnCreate = false;

        public ImageCacheParams(File diskCacheDir) {
            this.diskCacheDir = diskCacheDir;
        }

        public ImageCacheParams(String diskCacheDir) {
            this.diskCacheDir = new File(diskCacheDir);
        }

        public void setMemCacheSizePercent(Context context, float percent) {
            if (percent < 0.05f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)ImageCacheParams.getMemoryClass(context) * 1024.0f * 1024.0f);
        }

        public void setMemCacheSize(int memCacheSize) {
            this.memCacheSize = memCacheSize;
        }

        public void setDiskCacheSize(int diskCacheSize) {
            this.diskCacheSize = diskCacheSize;
        }

        private static int getMemoryClass(Context context) {
            return ((ActivityManager)context.getSystemService("activity")).getMemoryClass();
        }
    }
}

