/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.api;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.minggo.pluto.api.ApiUrl;
import com.minggo.pluto.common.PlutoException;
import com.minggo.pluto.model.Result;
import com.minggo.pluto.util.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class ApiClient {
    public static final String UTF_8 = "UTF-8";
    public static final String DESC = "descend";
    public static final String ASC = "ascend";
    private static final int TIMEOUT_CONNECTION = 15000;
    private static final int TIMEOUT_SOCKET = 15000;
    private static final int RETRY_TIME = 0;
    private static String appUserAgent;

    private static String getUserAgent() {
        if (appUserAgent == null || appUserAgent == "") {
            StringBuilder ua = new StringBuilder();
            ua.append("/Android");
            ua.append("/" + Build.VERSION.RELEASE);
            ua.append("/" + Build.MODEL);
            ua.append("/" + Locale.getDefault().toString());
            appUserAgent = ua.toString();
        }
        return appUserAgent;
    }

    private static HttpClient getHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setCookiePolicy("compatibility");
        httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(15000);
        httpClient.getHttpConnectionManager().getParams().setParameter("http.socket.timeout", (Object)15000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(15000);
        httpClient.getParams().setContentCharset(UTF_8);
        return httpClient;
    }

    private static GetMethod getHttpGet(String url, String cookie, String userAgent) {
        GetMethod httpGet = new GetMethod(url);
        httpGet.getParams().setSoTimeout(15000);
        httpGet.setRequestHeader("Connection", "Keep-Alive");
        httpGet.setRequestHeader("User-Agent", userAgent);
        return httpGet;
    }

    private static PostMethod getHttpPost(String url, String cookie, String userAgent) {
        PostMethod httpPost = new PostMethod(url);
        httpPost.getParams().setSoTimeout(15000);
        httpPost.setRequestHeader("Connection", "Keep-Alive");
        httpPost.setRequestHeader("User-Agent", userAgent);
        return httpPost;
    }

    public static String _MakeURL(String p_url, Map<String, Object> params) {
        StringBuilder url = new StringBuilder(p_url);
        if (url.indexOf("?") < 0) {
            url.append('?');
        }
        for (String name : params.keySet()) {
            url.append('&');
            url.append(name);
            url.append('=');
            url.append(URLEncoder.encode(String.valueOf(params.get(name))));
        }
        return url.toString().replace("?&", "?");
    }

    public static <T> Result<T> httpGetModel(String url, Map<String, Object> params) throws PlutoException {
        return ApiClient.httpGetModel(url, params, true);
    }

    public static <T> Result<List<T>> httpGetList(String url, Map<String, Object> params) throws PlutoException {
        return ApiClient.httpGetList(url, params, true);
    }

    public static <T> Result<T> httpGetModel(String url, Map<String, Object> params, boolean keepChangeLine) throws PlutoException {
        int requestId = new Random().nextInt(10000);
        String urlTemp = url;
        String userAgent = ApiClient.getUserAgent();
        HttpClient httpClient = null;
        GetMethod httpGet = null;
        String responseBody = "";
        int time = 0;
        do {
            try {
                if (!urlTemp.contains("http")) {
                    url = ApiUrl.URL_DOMAIN + urlTemp;
                }
                url = ApiClient._MakeURL(url, params);
                LogUtils.info("Get." + requestId + ".URL:" + url);
                httpClient = ApiClient.getHttpClient();
                httpGet = ApiClient.getHttpGet(url, null, userAgent);
                int statusCode = httpClient.executeMethod((HttpMethod)httpGet);
                LogUtils.info("Get." + requestId + ".StatusCode:" + statusCode);
                if (statusCode != 200 && statusCode != 404 && statusCode != 302 && statusCode != 301 && statusCode != 504 && statusCode != 502) continue;
                responseBody = ApiClient.toString(httpGet.getResponseBodyAsStream(), "utf-8", keepChangeLine);
                LogUtils.info("Get." + requestId + ".Result:" + responseBody);
            }
            catch (HttpException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.http((Exception)((Object)e));
            }
            catch (IOException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.network(e);
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                httpClient = null;
            }
        } while (time < 0);
        if (responseBody == null || responseBody == "") {
            return null;
        }
        Result result = null;
        if (responseBody != null) {
            responseBody = responseBody.toString();
        } else {
            LogUtils.info("reader", "Exceptiom-->JSONValue.parse(responseBody)=null,\u6ca1\u6709json\u8fd4\u56de");
        }
        Gson gson = new Gson();
        try {
            result = (Result)gson.fromJson(responseBody, new TypeToken<Result<T>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static <T> Result<List<T>> httpGetList(String url, Map<String, Object> params, boolean keepChangeLine) throws PlutoException {
        int requestId = new Random().nextInt(10000);
        String urlTemp = url;
        String userAgent = ApiClient.getUserAgent();
        HttpClient httpClient = null;
        GetMethod httpGet = null;
        String responseBody = "";
        int time = 0;
        do {
            try {
                if (!urlTemp.contains("http")) {
                    url = ApiUrl.URL_DOMAIN + urlTemp;
                }
                url = ApiClient._MakeURL(url, params);
                LogUtils.info("Get." + requestId + ".URL:" + url);
                httpClient = ApiClient.getHttpClient();
                httpGet = ApiClient.getHttpGet(url, null, userAgent);
                int statusCode = httpClient.executeMethod((HttpMethod)httpGet);
                LogUtils.info("Get." + requestId + ".StatusCode:" + statusCode);
                if (statusCode != 200 && statusCode != 404 && statusCode != 302 && statusCode != 301 && statusCode != 504 && statusCode != 502) continue;
                responseBody = ApiClient.toString(httpGet.getResponseBodyAsStream(), "utf-8", keepChangeLine);
                LogUtils.info("Get." + requestId + ".Result:" + responseBody);
            }
            catch (HttpException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.http((Exception)((Object)e));
            }
            catch (IOException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.network(e);
            }
            finally {
                if (httpGet != null) {
                    httpGet.releaseConnection();
                }
                httpClient = null;
            }
        } while (time < 0);
        if (responseBody == null || responseBody == "") {
            return null;
        }
        Result result = null;
        if (responseBody != null) {
            responseBody = responseBody.toString();
        } else {
            LogUtils.info("reader", "Exceptiom-->JSONValue.parse(responseBody)=null,\u6ca1\u6709json\u8fd4\u56de");
        }
        Gson gson = new Gson();
        try {
            result = (Result)gson.fromJson(responseBody, new TypeToken<Result<List<T>>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http_getString(String url, Map<String, Object> params, boolean keepChangeLine) throws PlutoException {
        int requestId = new Random().nextInt(10000);
        String urlTemp = url;
        String userAgent = ApiClient.getUserAgent();
        GetMethod httpGet = null;
        try {
            if (!urlTemp.contains("http")) {
                url = ApiUrl.URL_DOMAIN + urlTemp;
            }
            url = ApiClient._MakeURL(url, params);
            LogUtils.infoF("Get.%d.URL:%s", requestId, url);
            HttpClient httpClient = ApiClient.getHttpClient();
            httpGet = ApiClient.getHttpGet(url, null, userAgent);
            int statusCode = httpClient.executeMethod((HttpMethod)httpGet);
            LogUtils.infoF("Get.%d.StatusCode:%d", requestId, statusCode);
            if (statusCode == 200) {
                String responseBody = ApiClient.toString(httpGet.getResponseBodyAsStream(), "utf-8", keepChangeLine);
                LogUtils.infoF("Get.%d.Result:%s", requestId, responseBody);
                String string2 = responseBody;
                return string2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
        return "";
    }

    public static <T> Result<T> httpPostModel(String url, Map<String, Object> params, Map<String, File> files, boolean keepChangeLine) throws PlutoException {
        return ApiClient.httpPostModel(url, params, files, false, keepChangeLine);
    }

    public static <T> Result<T> httpPostModel(String url, Map<String, Object> params, Map<String, File> files, boolean isphp, boolean keepChangeLine) throws PlutoException {
        int requestId = new Random().nextInt(10000);
        String urlTemp = url;
        String userAgent = ApiClient.getUserAgent();
        HttpClient httpClient = null;
        PostMethod httpPost = null;
        int length = (params == null ? 0 : params.size()) + (files == null ? 0 : files.size());
        Part[] parts = new Part[length];
        int i = 0;
        if (params != null) {
            for (String name : params.keySet()) {
                parts[i++] = new StringPart(name, String.valueOf(params.get(name)), UTF_8);
            }
        }
        if (files != null) {
            for (String file : files.keySet()) {
                try {
                    parts[i++] = new FilePart(file, files.get(file));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        String responseBody = "";
        int time = 0;
        do {
            try {
                if (!urlTemp.contains("http")) {
                    url = ApiUrl.URL_DOMAIN + urlTemp;
                }
                httpClient = ApiClient.getHttpClient();
                httpPost = ApiClient.getHttpPost(url, null, userAgent);
                if (files == null) {
                    httpPost.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
                    ApiClient.setPostParams(httpPost, params);
                } else {
                    httpPost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, httpPost.getParams()));
                }
                LogUtils.info("Post." + requestId + ".URL:" + url);
                ApiClient.showPostParams(requestId, params);
                int statusCode = httpClient.executeMethod((HttpMethod)httpPost);
                LogUtils.info("Post." + requestId + ".StatusCode:" + statusCode);
                if (statusCode != 200 && statusCode != 404 && statusCode != 302 && statusCode != 301 && statusCode != 504 && statusCode != 502) continue;
                responseBody = ApiClient.toString(httpPost.getResponseBodyAsStream(), "utf-8", keepChangeLine);
                LogUtils.info("Post." + requestId + ".Result:" + responseBody);
            }
            catch (HttpException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.http((Exception)((Object)e));
            }
            catch (IOException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.network(e);
            }
            catch (Exception e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.network(e);
            }
            finally {
                httpPost.releaseConnection();
                httpClient = null;
            }
        } while (time < 0);
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        Result result = null;
        try {
            result = (Result)gson.fromJson(responseBody, Result.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void setPostParams(PostMethod postMethod, Map<String, Object> params) {
        for (String name : params.keySet()) {
            postMethod.setParameter(name, String.valueOf(params.get(name)));
        }
    }

    public static Bitmap getNetBitmap(String url) throws PlutoException {
        String urlTemp = url;
        HttpClient httpClient = null;
        GetMethod httpGet = null;
        Bitmap bitmap = null;
        int time = 0;
        do {
            try {
                url = ApiUrl.URL_DOMAIN + urlTemp;
                httpClient = ApiClient.getHttpClient();
                httpGet = ApiClient.getHttpGet(url, null, null);
                int statusCode = httpClient.executeMethod((HttpMethod)httpGet);
                if (statusCode != 200 && statusCode != 404 && statusCode != 302 && statusCode != 301 && statusCode != 504 && statusCode != 502) continue;
                InputStream inStream = httpGet.getResponseBodyAsStream();
                bitmap = BitmapFactory.decodeStream((InputStream)inStream);
                inStream.close();
                LogUtils.info("domain", "\u4e0d\u9700\u8981\u5207\u6362\u57df\u540d\uff0c\u6b63\u5e38");
            }
            catch (HttpException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.http((Exception)((Object)e));
            }
            catch (IOException e) {
                if (++time < 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                e.printStackTrace();
                throw PlutoException.network(e);
            }
            finally {
                httpGet.releaseConnection();
                httpClient = null;
            }
        } while (time < 0);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String toString(InputStream in, String decoding, boolean keepChangeLine) {
        if (in == null) {
            return "";
        }
        if (TextUtils.isEmpty((CharSequence)decoding)) {
            decoding = "utf-8";
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String temp;
            isr = new InputStreamReader(in, decoding);
            br = new BufferedReader(isr);
            while ((temp = br.readLine()) != null) {
                if (keepChangeLine) {
                    sb.append(temp + "\n");
                    continue;
                }
                sb.append(temp);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (isr != null) {
                        isr.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return sb.toString();
    }

    private static void showPostParams(int requestId, Map<String, Object> params) {
        String message = "Post." + requestId + ".Params:";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        String separator = "&";
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            stringBuilder.append(separator);
            stringBuilder.append(String.format(Locale.getDefault(), "%s=%s", key, value));
        }
        int separatorIndex = stringBuilder.indexOf(separator);
        if (separatorIndex != -1) {
            stringBuilder.deleteCharAt(separatorIndex);
        }
        LogUtils.info(stringBuilder.toString());
    }
}

