/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.annotation.SuppressLint;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern emailer = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    private static final String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String regEx_head = "<head[^>]*?>[\\s\\S]*?<\\/head>";
    private static final String regEx_html = "<[^>]+>";
    private static final String regEx_space = "\\s*|\t|\r|\n";
    @SuppressLint(value={"SimpleDateFormat"})
    private static final ThreadLocal<SimpleDateFormat> dateFormater = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> dateFormater2 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };

    public static Date toDate(String sdate) {
        try {
            return dateFormater.get().parse(sdate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date toDate2(String sdate) {
        try {
            return dateFormater2.get().parse(sdate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String toDate3(long sdate) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            return df.format(sdate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String friendly_time(String sdate) {
        String paramDate;
        Date time = StringUtils.toDate(sdate);
        if (time == null) {
            return "Unknown";
        }
        String ftime = "";
        Calendar cal = Calendar.getInstance();
        String curDate = dateFormater2.get().format(cal.getTime());
        if (curDate.equals(paramDate = dateFormater2.get().format(time))) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
            return ftime;
        }
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        if (days == 0) {
            int hour = (int)((cal.getTimeInMillis() - time.getTime()) / 3600000L);
            ftime = hour == 0 ? Math.max((cal.getTimeInMillis() - time.getTime()) / 60000L, 1L) + "\u5206\u949f\u524d" : hour + "\u5c0f\u65f6\u524d";
        } else if (days == 1) {
            ftime = "\u6628\u5929";
        } else if (days == 2) {
            ftime = "\u524d\u5929";
        } else if (days > 2 && days <= 10) {
            ftime = days + "\u5929\u524d";
        } else if (days > 10) {
            ftime = dateFormater2.get().format(time);
        }
        return ftime;
    }

    public static boolean isToday(String sdate) {
        String timeDate;
        String nowDate;
        boolean b = false;
        Date time = StringUtils.toDate(sdate);
        Date today = new Date();
        if (time != null && (nowDate = dateFormater2.get().format(today)).equals(timeDate = dateFormater2.get().format(time))) {
            b = true;
        }
        return b;
    }

    public static boolean isEmpty(String input) {
        if (input == null || "".equals(input)) {
            return true;
        }
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n') continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        if (email == null || email.trim().length() == 0) {
            return false;
        }
        return emailer.matcher(email).matches();
    }

    public static int toInt(String str, int defValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defValue;
        }
    }

    public static int toInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        return StringUtils.toInt(obj.toString(), 0);
    }

    public static long toLong(String obj) {
        try {
            return Long.parseLong(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean toBool(String b) {
        try {
            return Boolean.parseBoolean(b);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getCompareDay(String sdate) {
        Date time = StringUtils.toDate(sdate);
        if (time == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        long lt = time.getTime() / 86400000L;
        long ct = cal.getTimeInMillis() / 86400000L;
        int days = (int)(ct - lt);
        return days;
    }

    public static boolean check(int min, int max, String str) {
        int leng2;
        int leng1 = str.length();
        int result = (leng1 + (leng2 = str.getBytes().length)) / 2;
        return min <= result && max >= result;
    }

    public static String delHTMLTag(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        return htmlStr.trim();
    }

    public static String delStyleScript(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_head = Pattern.compile(regEx_head, 2);
        Matcher m_head = p_head.matcher(htmlStr);
        htmlStr = m_head.replaceAll("");
        return htmlStr.trim();
    }

    public static String delHTMLTagSimple(String htmlStr) {
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String deleteBlank(String htmlStr) {
        Pattern p_space = Pattern.compile(regEx_space, 2);
        Matcher m_space = p_space.matcher(htmlStr);
        htmlStr = m_space.replaceAll("");
        return htmlStr.trim();
    }

    public static String getTextFromHtml(String htmlStr) {
        htmlStr = StringUtils.delHTMLTag(htmlStr);
        htmlStr = htmlStr.replaceAll("&nbsp;", "");
        return htmlStr;
    }

    public static String halfToFull(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] <= ' ' || c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static boolean needScale(String line) {
        if (line.length() == 0) {
            return false;
        }
        return line.charAt(line.length() - 1) != '\n';
    }

    public static void testHtmlCutTag() {
        String str = "<div style=\"text-align:center;\"> \u6574\u6cbb\u201c\u56db\u98ce\u201d   \u6e05\u5f0a\u9664\u57a2<br/><span style=\"font-size:14px;\"> </span><span style=\"font-size:18px;\">\u516c\u53f8\u53ec\u5f00\u515a\u7684\u7fa4\u4f17\u8def\u7ebf\u6559\u80b2\u5b9e\u8df5\u6d3b\u52a8\u52a8\u5458\u5927\u4f1a</span><br/></div>";
        System.out.println("result-->" + StringUtils.getTextFromHtml(str));
    }

    public static String[] clearNewLineSign(String strParagraph) {
        String strReturn = "";
        if (strParagraph.contains("\r\n")) {
            strReturn = "\r\n";
            strParagraph = strParagraph.replace("\r\n", "");
        } else if (strParagraph.contains("\n")) {
            strReturn = "\n";
            strParagraph = strParagraph.replace("\n", "");
        } else if (strParagraph.contains("\\r\\n")) {
            strReturn = "\\r\\n";
            strParagraph = strParagraph.replace("\\r\\n", "");
        }
        return new String[]{strParagraph, strReturn};
    }

    public static String ellipsis(String content, int count) {
        String ellipsisSign = "\u2026\u2026";
        if (content.length() > count) {
            content = content.substring(0, count - ellipsisSign.length()) + ellipsisSign;
        }
        return content;
    }
}

