/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.db.manager.DataManagerStub;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharePreferenceUtils
extends DataManagerStub {
    public static SharePreferenceUtils sharePreferenceUtils;
    private static Context context;
    public static final String USER_CONFING = "USER_CONFIG";

    private SharePreferenceUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharePreferenceUtils getInstance() {
        if (sharePreferenceUtils != null) return sharePreferenceUtils;
        Class<SharePreferenceUtils> clazz = SharePreferenceUtils.class;
        synchronized (SharePreferenceUtils.class) {
            if (sharePreferenceUtils != null) return sharePreferenceUtils;
            sharePreferenceUtils = new SharePreferenceUtils();
            context = AppContext.getInstance().context;
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharePreferenceUtils;
        }
    }

    public boolean contains(String key) {
        return context.getSharedPreferences(USER_CONFING, 0).contains(key);
    }

    public boolean putStringByDefaultSP(String key, String value) {
        return this.putString(USER_CONFING, key, value);
    }

    public boolean putStringSetByDefaultSP(String key, Set<String> values) {
        if (values != null && values.size() != 0 && context != null && TextUtils.isEmpty((CharSequence)key)) {
            return context.getSharedPreferences(USER_CONFING, 0).edit().putStringSet(key, values).commit();
        }
        return false;
    }

    public boolean putOrderStringListByDefaultSP(String key, List<String> values) {
        if (values != null && context != null && !TextUtils.isEmpty((CharSequence)key)) {
            Gson gson = new Gson();
            try {
                String valuesJSON = gson.toJson(values, new TypeToken<List<String>>(){}.getType());
                return context.getSharedPreferences(USER_CONFING, 0).edit().putString(key, valuesJSON).commit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean putString(String name, String content) {
        return this.putString(name, name, content);
    }

    public boolean putString(String name, String key, String content) {
        if (content != null && name != null && context != null) {
            return context.getSharedPreferences(name, 0).edit().putString(key, content).commit();
        }
        return false;
    }

    public boolean putInt(String key, int content) {
        return this.putInt(USER_CONFING, key, content);
    }

    public boolean putInt(String name, String key, int content) {
        if (name != null && context != null) {
            return context.getSharedPreferences(name, 0).edit().putInt(key, content).commit();
        }
        return false;
    }

    public boolean putLong(String spFileName, String key, long value) {
        return this.notNull(spFileName) && this.getSharedPreferences(spFileName).edit().putLong(key, value).commit();
    }

    public boolean putLong(String key, long value) {
        return this.putLong(USER_CONFING, key, value);
    }

    public boolean putBoolean(String name, String key, boolean content) {
        if (context != null) {
            return context.getSharedPreferences(name, 0).edit().putBoolean(key, content).commit();
        }
        return false;
    }

    public boolean putBooleanByDefaultSP(String key, boolean value) {
        return this.putBoolean(USER_CONFING, key, value);
    }

    public boolean getBoolean(String name, String key) {
        if (context != null && name != null) {
            return context.getSharedPreferences(name, 0).getBoolean(key, false);
        }
        return false;
    }

    public boolean getBooleanByDefaultSP(String key, boolean defaultValue) {
        boolean result = defaultValue;
        if (context != null && !TextUtils.isEmpty((CharSequence)key)) {
            result = context.getSharedPreferences(USER_CONFING, 0).getBoolean(key, defaultValue);
        }
        return result;
    }

    public Set<String> getStringSetByDefaultSP(String key) {
        Set<String> result = new HashSet<String>();
        if (context != null && !TextUtils.isEmpty((CharSequence)key)) {
            result = context.getSharedPreferences(USER_CONFING, 0).getStringSet(key, result);
        }
        return result;
    }

    public List<String> getOrderStringListByDefaultSP(String key) {
        String json;
        List<String> result = new ArrayList<String>();
        if (context != null && !TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)(json = context.getSharedPreferences(USER_CONFING, 0).getString(key, "")))) {
            Gson gson = new Gson();
            result = (List)gson.fromJson(json, new TypeToken<List<String>>(){}.getType());
        }
        return result;
    }

    public String getStringByName(String name, String defaultStr, boolean nothing) {
        if (context != null && name != null) {
            return context.getSharedPreferences(name, 0).getString(name, defaultStr);
        }
        return defaultStr;
    }

    public String getStringByDefaultSP(String key, String defaultValue) {
        return this.getString(USER_CONFING, key, defaultValue);
    }

    public String getString(String name, String key) {
        if (context != null && name != null) {
            return context.getSharedPreferences(name, 0).getString(key, null);
        }
        return null;
    }

    public String getString(String name, String key, String defaultValue) {
        String result = defaultValue;
        if (context != null && !TextUtils.isEmpty((CharSequence)name) && !TextUtils.isEmpty((CharSequence)key)) {
            result = context.getSharedPreferences(name, 0).getString(key, defaultValue);
        }
        return result;
    }

    public int getInt(String spFileName, String key, int defaultValue) {
        if (this.notNull(spFileName)) {
            return this.getSharedPreferences(spFileName).getInt(key, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(USER_CONFING, key, defaultValue);
    }

    public long getLong(String spFileName, String key, long defaultValue) {
        if (this.notNull(spFileName)) {
            return this.getSharedPreferences(spFileName).getLong(key, defaultValue);
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(USER_CONFING, key, defaultValue);
    }

    public Map<String, ?> getAllString(String name) {
        if (context != null && name != null) {
            return context.getSharedPreferences(name, 0).getAll();
        }
        return null;
    }

    public static void clearString(String name) {
        context.getSharedPreferences(name, 0).edit().clear().commit();
    }

    public static <T> boolean put(T t) {
        if (t == null || context == null) {
            return false;
        }
        try {
            Field[] fields;
            SharedPreferences.Editor edit = context.getSharedPreferences(t.getClass().getSimpleName(), 0).edit();
            for (Field field : fields = t.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(t);
                if (value == null) continue;
                Class<?> type = field.getType();
                String name = field.getName();
                if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                    edit.putInt(name, ((Integer)value).intValue());
                } else if (String.class.equals(type)) {
                    edit.putString(name, String.valueOf(value));
                } else if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                    edit.putLong(name, ((Long)value).longValue());
                } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
                    edit.putString(name, String.valueOf(value));
                } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
                    edit.putFloat(name, ((Float)value).floatValue());
                }
                edit.commit();
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static <T> T get(Class<T> clazz) {
        if (clazz == null || context == null) {
            return null;
        }
        try {
            Field[] fields;
            SharedPreferences sp = context.getSharedPreferences(clazz.getSimpleName(), 0);
            T instance = clazz.newInstance();
            for (Field field : fields = clazz.getDeclaredFields()) {
                float value;
                field.setAccessible(true);
                Class<?> type = field.getType();
                String name = field.getName();
                if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                    int value2 = sp.getInt(name, -2001);
                    if (value2 == -2001) continue;
                    field.setInt(instance, value2);
                    continue;
                }
                if (String.class.equals(type)) {
                    String value3 = sp.getString(name, null);
                    if (value3 == null) continue;
                    field.set(instance, value3);
                    continue;
                }
                if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                    long value4 = sp.getLong(name, -2001L);
                    if (value4 == -2001L) continue;
                    field.setLong(instance, value4);
                    continue;
                }
                if (Double.TYPE.equals(type) || Double.class.equals(type)) {
                    String value5 = sp.getString(name, null);
                    if (value5 == null) continue;
                    field.setDouble(instance, Double.valueOf(value5));
                    continue;
                }
                if (!Float.TYPE.equals(type) && !Float.class.equals(type) || (value = sp.getFloat(name, -2001.0f)) == -2001.0f) continue;
                field.setFloat(instance, value);
            }
            return instance;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getPrefByPackage(String name, String def) {
        String pkg = context.getPackageName();
        SharedPreferences prefs = context.getSharedPreferences(pkg, 0);
        return prefs.getString(name, def);
    }

    public void setPrefByPackage(String name, String value) {
        String pkg = context.getPackageName();
        SharedPreferences prefs = context.getSharedPreferences(pkg, 0);
        SharedPreferences.Editor ed = prefs.edit();
        ed.putString(name, value);
        ed.apply();
    }

    public boolean getBooleanPrefByPackage(String name, boolean def) {
        String pkg = context.getPackageName();
        SharedPreferences prefs = context.getSharedPreferences(pkg, 0);
        return prefs.getBoolean(name, def);
    }

    public void setBooleanPrefByPackage(String name, boolean value) {
        String pkg = context.getPackageName();
        SharedPreferences prefs = context.getSharedPreferences(pkg, 0);
        SharedPreferences.Editor ed = prefs.edit();
        ed.putBoolean(name, value);
        ed.apply();
    }

    public <T> boolean clear(Class<T> clazz) {
        if (clazz != null && context != null) {
            return context.getSharedPreferences(clazz.getSimpleName(), 0).edit().clear().commit();
        }
        return false;
    }

    public boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    public void remove(String ... keys) {
        if (context != null && keys != null && keys.length > 0) {
            SharedPreferences.Editor editor = context.getSharedPreferences(USER_CONFING, 0).edit();
            for (String keyItem : keys) {
                editor.remove(keyItem);
            }
            editor.apply();
        }
    }

    private boolean notNull(String spFileName) {
        return !TextUtils.isEmpty((CharSequence)spFileName) && context != null;
    }

    private SharedPreferences getSharedPreferences(String spFileName) {
        return context.getSharedPreferences(spFileName, 0);
    }

    @Override
    public void saveData(Object key, Object object) {
        super.saveData(key, object);
        if (object instanceof Integer) {
            this.putInt(key.toString(), (Integer)object);
        } else if (object instanceof String) {
            this.putStringByDefaultSP(key.toString(), object.toString());
        } else if (object instanceof Boolean) {
            this.putBooleanByDefaultSP(key.toString(), (Boolean)object);
        }
    }

    @Override
    public <T> T queryData(Object key, Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(this.getInt(key.toString(), 0));
        }
        if (clazz == String.class) {
            return (T)this.getSharedPreferences(this.getStringByDefaultSP(key.toString(), ""));
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.valueOf(this.getBooleanByDefaultSP(key.toString(), false));
        }
        return null;
    }

    @Override
    public void updateData(Object key, Object object) {
        super.updateData(key, object);
        if (object instanceof Integer) {
            this.putInt(key.toString(), (Integer)object);
        } else if (object instanceof String) {
            this.putString(key.toString(), object.toString());
        } else if (object instanceof Boolean) {
            this.putBooleanByDefaultSP(key.toString(), (Boolean)object);
        }
    }

    @Override
    public <T> void deleteData(Object key, Class<T> clazz) {
        super.deleteData(key, clazz);
        SharePreferenceUtils.clearString(key.toString());
    }
}

