/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.view.Display;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressLint(value={"NewApi"})
public class PhotoUtil {
    public static final int IMAGE_MAX_WIDTH = 300;
    public static final int IMAGE_MAX_HEIGHT = 300;

    public static boolean isSDCardReady() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getFilePath(Activity activity, Uri uri) {
        String[] proj = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, proj, null, null, null);
        int column_index = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        String path = cursor.getString(column_index);
        return path;
    }

    public static Bitmap getBitpMap(Context context, Uri uri, Display display) {
        ParcelFileDescriptor pfd;
        try {
            pfd = context.getContentResolver().openFileDescriptor(uri, "r");
        }
        catch (IOException ex) {
            return null;
        }
        FileDescriptor fd = pfd.getFileDescriptor();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 1;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        options.inSampleSize = PhotoUtil.computeSampleSize(options, display.getWidth(), display.getHeight());
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap sourceBitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
        return sourceBitmap;
    }

    static int computeSampleSize(BitmapFactory.Options options, int targetWindth, int targetHieght) {
        int w = options.outWidth;
        int h = options.outHeight;
        int candidate = 0;
        int candidateW = w / targetWindth;
        int candidateH = h / targetHieght;
        candidate = Math.max(candidateW, candidateH);
        if (candidate == 0) {
            return 1;
        }
        if (candidate > 1 && w > targetWindth && w / candidate < targetWindth) {
            --candidate;
        }
        if (candidate > 1 && h > targetHieght && h / candidate < targetHieght) {
            --candidate;
        }
        return candidate;
    }

    public static void compressImage(String filepath, int quality, Display display) {
        int scale = 1;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
        if (options.outWidth > 300 || options.outHeight > 300) {
            scale = PhotoUtil.calculateInSampleSize(options, display.getWidth(), display.getHeight());
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = scale;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
        Matrix matrix = new Matrix();
        matrix.setRotate((float)PhotoUtil.readPictureDegree(filepath));
        Bitmap saveBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        PhotoUtil.writeToFile(filepath, saveBitmap, quality);
    }

    public static void compressImage(String savePath, String filepath, int quality, Display display) {
        int scale = 1;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
        if (options.outWidth > 300 || options.outHeight > 300) {
            scale = PhotoUtil.calculateInSampleSize(options, display.getWidth(), display.getHeight());
        }
        options.inJustDecodeBounds = false;
        options.inSampleSize = scale;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filepath, (BitmapFactory.Options)options);
        Matrix matrix = new Matrix();
        matrix.setRotate((float)PhotoUtil.readPictureDegree(filepath));
        Bitmap saveBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        PhotoUtil.writeToFile(savePath, saveBitmap, quality);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize = width > height ? Math.round((float)height / (float)reqWidth) : Math.round((float)width / (float)reqHeight);
        }
        return inSampleSize + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(String file, Bitmap bitmap, int quality) {
        if (bitmap == null) {
            return;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)bos);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bos != null) {
                    bitmap.recycle();
                    bos.flush();
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return degree;
    }

    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float right;
        float left;
        float bottom;
        float top;
        float roundPx;
        int height;
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            top = 0.0f;
            bottom = width;
            left = 0.0f;
            right = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }
}

