/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.minggo.pluto.util.StringUtils;
import java.util.Locale;

public class NetworkUtils {
    public static final int NET_TYPE_NOT = 0;
    public static final int NET_TYPE_WIFI = 1;
    public static final int NET_TYPE_CM_WAP = 2;
    public static final int NET_TYPE_CM_NET = 3;

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnectedOrConnecting() && networkInfo.getState() == NetworkInfo.State.CONNECTED;
    }

    public static int getNetworkType(Context context) {
        int netType = 0;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return netType;
        }
        int networkInfoType = networkInfo.getType();
        if (networkInfoType == 0) {
            String extraInfo = networkInfo.getExtraInfo();
            if (!StringUtils.isEmpty(extraInfo)) {
                netType = extraInfo.toLowerCase(Locale.getDefault()).equals("cmnet") ? 3 : 2;
            }
        } else if (networkInfoType == 1) {
            netType = 1;
        }
        return netType;
    }
}

