/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.minggo.pluto.Pluto;
import com.minggo.pluto.util.FileUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogUtils {
    public static boolean DISP = Pluto.LOG_SHOW;
    public static String DEFAULT_TAG = "9kus";
    private static final String UMENG_PAGE_TAG = "UmengPageTrack";

    public static boolean isDISPLog() {
        boolean isDISPLog = DISP;
        if (!isDISPLog) {
            File isDispLogFile = LogUtils.getIsDispLogFile();
            isDISPLog = isDispLogFile.exists();
        }
        return isDISPLog;
    }

    private static File getIsDispLogFile() {
        String isDispLog_FileName = "show";
        return new File(Pluto.SDPATH, isDispLog_FileName);
    }

    public static void removeIsDISPLogFile() {
        File file = LogUtils.getIsDispLogFile();
        if (file.exists()) {
            System.out.println("removeIsDISPLogFile:" + file.delete());
        }
    }

    private static String generateTag(StackTraceElement caller) {
        String tag = "%s.%s(L:%d)";
        String callerClazzName = caller.getClassName();
        callerClazzName = callerClazzName.substring(callerClazzName.lastIndexOf(".") + 1);
        tag = String.format(tag, callerClazzName, caller.getMethodName(), caller.getLineNumber());
        tag = TextUtils.isEmpty((CharSequence)DEFAULT_TAG) ? tag : DEFAULT_TAG + ":" + tag;
        return tag;
    }

    public static StackTraceElement getCallerStackTraceElement() {
        return Thread.currentThread().getStackTrace()[4];
    }

    public static void debug(String TAG, String message) {
        if (DISP) {
            LogUtils.debug(TAG, TAG + message, null);
        }
    }

    public static void debug(String TAG, String message, Throwable t) {
        if (DISP) {
            if (message != null) {
                Log.d((String)TAG, (String)("~~~~~  " + message));
            }
            if (t != null) {
                Log.d((String)TAG, (String)t.toString());
            }
        }
    }

    public static void info(String message) {
        StackTraceElement caller = LogUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        LogUtils.info(tag, message);
    }

    public static void info(String message, Object ... args) {
        LogUtils.info(String.format(message, args));
    }

    public static void info(String TAG, String message) {
        LogUtils.info(TAG, message, null);
    }

    public static void info(String TAG, String message, Throwable t) {
        if (DISP) {
            if (message != null) {
                Log.i((String)TAG, (String)message);
            }
            if (t != null) {
                Log.i((String)TAG, (String)t.toString());
            }
        }
    }

    public static void infoF(String format, Object ... args) {
        String message = String.format(format, args);
        StackTraceElement caller = LogUtils.getCallerStackTraceElement();
        String tag = LogUtils.generateTag(caller);
        LogUtils.info(tag, message);
    }

    public static void warn(String TAG, String message) {
        if (DISP) {
            LogUtils.warn(TAG, message, null);
        }
    }

    public static void warn(String TAG, String message, Throwable t) {
        if (DISP) {
            if (message != null) {
                Log.w((String)TAG, (String)message);
            }
            if (t != null) {
                Log.w((String)TAG, (String)t.toString());
            }
        }
    }

    public static void error(String TAG, String message) {
        if (DISP) {
            LogUtils.error(TAG, message, null);
        }
    }

    public static void error(String TAG, String message, Throwable t) {
        if (DISP) {
            if (message != null) {
                Log.e((String)TAG, (String)("~~~~~  " + message));
            }
            if (t != null) {
                Log.e((String)TAG, (String)t.toString());
            }
        }
    }

    public static void log(String TAG, String message) {
        if (DISP && message != null) {
            Log.e((String)TAG, (String)message);
        }
    }

    @SuppressLint(value={"SdCardPath"})
    public static void fileWrite(String filename, String message) {
        if (DISP && message != null) {
            FileUtils.WriterTxtFile(Pluto.SDPATH, "/sdcard/" + Pluto.APP_CACHE_FILE + "/" + filename + ".txt", message, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public static void saveErrorLog(Exception excp) {
        if (DISP) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String errorlog = "errorlog" + sDateFormat.format(new Date()) + ".txt";
            String savePath = "";
            String logFilePath = "";
            OutputStreamWriter fw = null;
            PrintWriter pw = null;
            try {
                String storageState = Environment.getExternalStorageState();
                if (storageState.equals("mounted")) {
                    savePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + Pluto.APP_CACHE_FILE + "/Log/";
                    File file = new File(savePath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    logFilePath = savePath + errorlog;
                }
                if (logFilePath == "") {
                    return;
                }
                File logFile = new File(logFilePath);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                fw = new FileWriter(logFile, true);
                pw = new PrintWriter(fw);
                pw.println("--------------------" + new Date().toLocaleString() + "---------------------");
                Log.d((String)"saveErrorLog", (String)new Date().toLocaleString());
                excp.printStackTrace(pw);
                pw.close();
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public static void saveLog(String logString) {
        if (DISP) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String errorlog = "Requestlog" + sDateFormat.format(new Date()) + ".txt";
            String savePath = "";
            String logFilePath = "";
            OutputStreamWriter fw = null;
            PrintWriter pw = null;
            try {
                String storageState = Environment.getExternalStorageState();
                if (storageState.equals("mounted")) {
                    savePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + Pluto.APP_CACHE_FILE + "/Log/";
                    File file = new File(savePath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    logFilePath = savePath + errorlog;
                }
                if (logFilePath == "") {
                    return;
                }
                File logFile = new File(logFilePath);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                fw = new FileWriter(logFile, true);
                pw = new PrintWriter(fw);
                pw.println("--------------------" + new Date().toLocaleString() + "---------------------");
                pw.println(logString);
                pw.close();
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public static void saveImagesLog(String logString) {
        if (DISP) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String errorlog = "ImagesRequestlog" + sDateFormat.format(new Date()) + ".txt";
            String savePath = "";
            String logFilePath = "";
            OutputStreamWriter fw = null;
            PrintWriter pw = null;
            try {
                String storageState = Environment.getExternalStorageState();
                if (storageState.equals("mounted")) {
                    savePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + Pluto.APP_CACHE_FILE + "/Log/";
                    File file = new File(savePath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    logFilePath = savePath + errorlog;
                }
                if (logFilePath == "") {
                    return;
                }
                File logFile = new File(logFilePath);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                fw = new FileWriter(logFile, true);
                pw = new PrintWriter(fw);
                pw.println("--------------------" + new Date().toLocaleString() + "---------------------");
                pw.println(logString);
                pw.close();
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SimpleDateFormat"})
    public static void saveRequestLog(String logString) {
        if (DISP) {
            SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String errorlog = "saveRequestLog" + sDateFormat.format(new Date()) + ".txt";
            String savePath = "";
            String logFilePath = "";
            OutputStreamWriter fw = null;
            PrintWriter pw = null;
            try {
                String storageState = Environment.getExternalStorageState();
                if (storageState.equals("mounted")) {
                    savePath = Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + Pluto.APP_CACHE_FILE + "/Log/";
                    File file = new File(savePath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    logFilePath = savePath + errorlog;
                }
                if (logFilePath == "") {
                    return;
                }
                File logFile = new File(logFilePath);
                if (!logFile.exists()) {
                    logFile.createNewFile();
                }
                fw = new FileWriter(logFile, true);
                pw = new PrintWriter(fw);
                pw.println("--------------------" + new Date().toLocaleString() + "---------------------");
                pw.println(logString);
                pw.close();
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void umengOnResume(String pageName) {
        LogUtils.info(UMENG_PAGE_TAG, "Start:" + pageName);
    }

    public static void umengOnPause(String pageName) {
        LogUtils.warn(UMENG_PAGE_TAG, "End:" + pageName);
    }

    static {
        System.out.println("dLogStart:" + DISP);
        DISP = LogUtils.isDISPLog();
        System.out.println("dLogEnd:" + DISP);
    }
}

