/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.util.Log;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.minggo.pluto.util.JsCallJava;

public class InjectedChromeClient
extends WebChromeClient {
    private final String TAG = "InjectedChromeClient";
    private JsCallJava mJsCallJava;
    private boolean mIsInjectedJS;

    public InjectedChromeClient(String injectedName, Class injectedCls) {
        this.mJsCallJava = new JsCallJava(injectedName, injectedCls);
    }

    public InjectedChromeClient(JsCallJava jsCallJava) {
        this.mJsCallJava = jsCallJava;
    }

    public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
        result.confirm();
        return true;
    }

    public void onProgressChanged(WebView view, int newProgress) {
        if (newProgress <= 25) {
            this.mIsInjectedJS = false;
        } else if (!this.mIsInjectedJS) {
            view.loadUrl(this.mJsCallJava.getPreloadInterfaceJS());
            this.mIsInjectedJS = true;
            Log.d((String)"InjectedChromeClient", (String)(" inject js interface completely on progress " + newProgress));
        }
        super.onProgressChanged(view, newProgress);
    }

    public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
        result.confirm(this.mJsCallJava.call(view, message));
        return true;
    }
}

