/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import com.minggo.pluto.util.LogUtils;
import com.minggo.pluto.util.StringUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    public static boolean WriterTxtFile(String filePath, String fileName, String content, boolean append) {
        String strFile = filePath + "/" + fileName;
        File file = new File(strFile);
        file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(strFile)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(strFile, append);
            out.write(content.getBytes("UTF-8"));
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean WriterTxtFileReturn(String filePath, String fileName, String content, boolean append) {
        String strFile = filePath + "/" + fileName;
        File file = new File(strFile);
        file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(strFile)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return true;
        }
        try {
            FileOutputStream out = new FileOutputStream(strFile, append);
            out.write(content.getBytes("UTF-8"));
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String ReadTxtFile(String strFilePath) {
        String content = "";
        File file = new File(strFilePath);
        if (!file.isDirectory() && file.exists()) {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        if (strFilePath.contains("ggid")) {
                            content = content + line;
                            continue;
                        }
                        content = content + line + "\n";
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return content;
    }

    public static String RemoveTxtFile(String strFilePath) {
        String content = "";
        File file = new File(strFilePath);
        if (file.exists()) {
            file.delete();
        }
        return content;
    }

    public static String ReadTxtFileForBookids(String strFilePath) {
        String content = "";
        File file = new File(strFilePath);
        if (!file.isDirectory()) {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        content = content + line;
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return content;
    }

    public static String ReadTxtFile(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int len;
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toString();
    }

    public static String getFileName(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return "";
        }
        return filePath.substring(filePath.lastIndexOf(File.separator) + 1);
    }

    public static String getFileNameNoFormat(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            return "";
        }
        int point = filePath.lastIndexOf(46);
        return filePath.substring(filePath.lastIndexOf(File.separator) + 1, point);
    }

    public static String getFileFormat(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return "";
        }
        int point = fileName.lastIndexOf(46);
        return fileName.substring(point + 1);
    }

    public static long getFileSize(String filePath) {
        long size = 0L;
        File file = new File(filePath);
        if (file != null && file.exists()) {
            size = file.length();
        }
        return size;
    }

    public static String getFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        DecimalFormat df = new DecimalFormat("##.##");
        float temp = (float)size / 1024.0f;
        if (temp >= 1024.0f) {
            return df.format(temp / 1024.0f) + "M";
        }
        return df.format(temp) + "K";
    }

    public static String formatFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "G"));
        return fileSizeString;
    }

    public static long getDirSize(File dir) {
        File[] files;
        if (dir == null) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return 0L;
        }
        long dirSize = 0L;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                dirSize += file.length();
                continue;
            }
            if (!file.isDirectory()) continue;
            dirSize += file.length();
            dirSize += FileUtils.getDirSize(file);
        }
        return dirSize;
    }

    public long getFileList(File dir) {
        long count = 0L;
        File[] files = dir.listFiles();
        count = files.length;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            count += this.getFileList(file);
            --count;
        }
        return count;
    }

    public static byte[] toBytes(InputStream in) throws IOException {
        int ch;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((ch = in.read()) != -1) {
            out.write(ch);
        }
        byte[] buffer = out.toByteArray();
        out.close();
        return buffer;
    }

    public static boolean checkFileExists(String filepath) {
        boolean status;
        if (!filepath.equals("")) {
            File newPath = new File(filepath);
            status = newPath.exists();
        } else {
            status = false;
        }
        return status;
    }

    public static long getFreeDiskSpace() {
        String status = Environment.getExternalStorageState();
        long freeSpace = 0L;
        if (status.equals("mounted")) {
            try {
                File path = Environment.getExternalStorageDirectory();
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSize();
                long availableBlocks = stat.getAvailableBlocks();
                freeSpace = availableBlocks * blockSize / 1024L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return -1L;
        }
        return freeSpace;
    }

    public static boolean createDirectory(String directoryName) {
        boolean status;
        if (!directoryName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + directoryName);
            status = newPath.mkdir();
            status = true;
        } else {
            status = false;
        }
        return status;
    }

    public static boolean checkSaveLocationExists() {
        String sDCardStatus = Environment.getExternalStorageState();
        boolean status = sDCardStatus.equals("mounted");
        return status;
    }

    public static boolean deleteDirectory(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (!fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isDirectory()) {
                String[] listfile = newPath.list();
                try {
                    for (int i = 0; i < listfile.length; ++i) {
                        File deletedFile = new File(newPath.toString() + "/" + listfile[i].toString());
                        deletedFile.delete();
                    }
                    newPath.delete();
                    LogUtils.info("DirectoryManager deleteDirectory", fileName);
                    status = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    public static boolean deleteFile(String fileName) {
        boolean status;
        SecurityManager checker = new SecurityManager();
        if (!fileName.equals("")) {
            File path = Environment.getExternalStorageDirectory();
            File newPath = new File(path.toString() + fileName);
            checker.checkDelete(newPath.toString());
            if (newPath.isFile()) {
                try {
                    newPath.delete();
                    status = true;
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                    status = false;
                }
            } else {
                status = false;
            }
        } else {
            status = false;
        }
        return status;
    }

    public static boolean deleteSDFile(String strFilePath) {
        if (strFilePath.equals("")) {
            return false;
        }
        File file = new File(strFilePath);
        return file.exists() && file.delete();
    }

    public static long getLastModified(String filePath) {
        File file = new File(filePath);
        return file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String oldPath, String newPath) {
        InputStream inStream = null;
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = inStream.read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u590d\u5236\u5355\u4e2a\u6587\u4ef6\u64cd\u4f5c\u51fa\u9519");
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static List<String> getDirsFileNames(String path) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                fileNames.add(file.getName());
            }
        }
        return fileNames;
    }

    public static File getExternalFilesDir(Context context, String dirType) {
        return context.getExternalFilesDir(dirType);
    }

    public static File getExternalCacheDir(Context context) {
        return context.getExternalCacheDir();
    }
}

