/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.content.Context;
import java.util.Locale;

public class DisplayUtil {
    public static final int SCREEN_WIDTH_PIXELS_480 = 480;
    public static final int SCREEN_WIDTH_PIXELS_720 = 720;
    public static final int SCREEN_WIDTH_PIXELS_1080 = 1080;

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static float px2dipByFloat(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return pxValue / scale;
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static float dip2pxByFloat(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return dipValue * scale;
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int getScreenWidthPixels(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeightPixels(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static boolean isTargetScreenWidth(Context context, int targetPixels) {
        return DisplayUtil.getScreenWidthPixels(context) == targetPixels;
    }

    public static boolean isTargetScreenHeight(Context context, int targetPixels) {
        return DisplayUtil.getScreenHeightPixels(context) == targetPixels;
    }

    public static String getDisplayInfo(Context context) {
        String infoFormat = "\u5bbd:%s,\u9ad8:%s \u5bbdDip:%s,\u9ad8Dip:%s\ndpi:%s,1dip=%sPixels";
        int screenWidthPixels = DisplayUtil.getScreenWidthPixels(context);
        int screenHeightPixels = DisplayUtil.getScreenHeightPixels(context);
        float density = context.getResources().getDisplayMetrics().density;
        Object[] infoFormatValue = new Object[]{screenWidthPixels, screenHeightPixels, (int)((float)screenWidthPixels / density), (int)((float)screenHeightPixels / density), context.getResources().getDisplayMetrics().densityDpi, Float.valueOf(density)};
        return String.format(Locale.getDefault(), infoFormat, infoFormatValue);
    }
}

