/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import com.minggo.pluto.R;

public class ProgressFragment
extends Fragment {
    private View mProgressContainer;
    private View mContentContainer;
    private View mContentView;
    private View mEmptyView;
    private boolean mContentShown;
    private boolean mIsContentEmpty;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_progress, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureContent();
    }

    public void onDestroyView() {
        this.mContentShown = false;
        this.mIsContentEmpty = false;
        this.mEmptyView = null;
        this.mContentView = null;
        this.mContentContainer = null;
        this.mProgressContainer = null;
        super.onDestroyView();
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setContentView(int layoutResId) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getActivity());
        View contentView = layoutInflater.inflate(layoutResId, null);
        this.setContentView(contentView);
    }

    public void setContentView(View view) {
        this.ensureContent();
        if (view == null) {
            throw new IllegalArgumentException("Content view can't be null");
        }
        if (this.mContentContainer instanceof ViewGroup) {
            ViewGroup contentContainer = (ViewGroup)this.mContentContainer;
            if (this.mContentView == null) {
                contentContainer.addView(view);
            } else {
                int index = contentContainer.indexOfChild(this.mContentView);
                contentContainer.removeView(this.mContentView);
                contentContainer.addView(view, index);
            }
        } else {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        this.mContentView = view;
    }

    public void setEmptyText(int resId) {
        this.setEmptyText(this.getString(resId));
    }

    public void setEmptyText(CharSequence text) {
        this.ensureContent();
        if (this.mEmptyView == null || !(this.mEmptyView instanceof TextView)) {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        ((TextView)this.mEmptyView).setText(text);
    }

    public void setContentShown(boolean shown) {
        this.setContentShown(shown, true);
    }

    public void setContentShownNoAnimation(boolean shown) {
        this.setContentShown(shown, false);
    }

    private void setContentShown(boolean shown, boolean animate) {
        this.ensureContent();
        if (this.mContentShown == shown) {
            return;
        }
        this.mContentShown = shown;
        if (shown) {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)0x10A0001));
                this.mContentContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)0x10A0000));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mContentContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(8);
            this.mContentContainer.setVisibility(0);
        } else {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)0x10A0000));
                this.mContentContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)0x10A0001));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mContentContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(0);
            this.mContentContainer.setVisibility(8);
        }
    }

    public boolean isContentEmpty() {
        return this.mIsContentEmpty;
    }

    public void setContentEmpty(boolean isEmpty) {
        this.ensureContent();
        if (this.mContentView == null) {
            throw new IllegalStateException("Content view must be initialized before");
        }
        if (isEmpty) {
            this.mEmptyView.setVisibility(0);
            this.mContentView.setVisibility(8);
        } else {
            this.mEmptyView.setVisibility(8);
            this.mContentView.setVisibility(0);
        }
        this.mIsContentEmpty = isEmpty;
    }

    private void ensureContent() {
        if (this.mContentContainer != null && this.mProgressContainer != null) {
            return;
        }
        View root = this.getView();
        if (root == null) {
            throw new IllegalStateException("Content view not yet created");
        }
        this.mProgressContainer = root.findViewById(R.id.progress_container);
        if (this.mProgressContainer == null) {
            throw new RuntimeException("Your content must have a ViewGroup whose id attribute is 'R.id.progress_container'");
        }
        this.mContentContainer = root.findViewById(R.id.content_container);
        if (this.mContentContainer == null) {
            throw new RuntimeException("Your content must have a ViewGroup whose id attribute is 'R.id.content_container'");
        }
        this.mEmptyView = root.findViewById(16908292);
        if (this.mEmptyView != null) {
            this.mEmptyView.setVisibility(8);
        }
        this.mContentShown = true;
        if (this.mContentView == null) {
            this.setContentShown(false, false);
        }
    }
}

