/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import com.minggo.pluto.bitmap.BitmapDisplayConfig;
import com.minggo.pluto.bitmap.FinalBitmap;
import com.minggo.pluto.common.CommonAsyncTask;
import com.minggo.pluto.dialog.PlutoDialog;
import com.minggo.pluto.fragment.FragmentUserVisibleController;
import com.minggo.pluto.fragment.IFragment;
import com.minggo.pluto.fragment.ProgressFragment;
import com.minggo.pluto.util.NetworkUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public abstract class PlutoFragment
extends ProgressFragment
implements IFragment,
FragmentUserVisibleController.UserVisibleCallback {
    private boolean isInit;
    private boolean isCreated;
    private boolean isStatistics = true;
    protected String simpleName = this.getClass().getSimpleName();
    private FragmentUserVisibleController userVisibleController;
    private Toast toast = null;
    protected Handler mUiHandler = new UiHandler(this);
    protected FinalBitmap finalBitmap;
    protected BitmapDisplayConfig bitmapDisplayConfig;
    protected PlutoDialog loadingDialog;

    public PlutoFragment() {
        this.userVisibleController = new FragmentUserVisibleController(this, this);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.isCreated = true;
        this.initLoadingDialog();
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.isInit = true;
        this.userVisibleController.activityCreated();
    }

    public void onResume() {
        super.onResume();
        this.userVisibleController.resume();
        if (this.getUserVisibleHint() && this.isInit && this.isCreated) {
            this.isInit = false;
            this.showData();
        }
        if (this.getUserVisibleHint()) {
            this.statistics(true);
        }
    }

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        this.userVisibleController.setUserVisibleHint(isVisibleToUser);
        if (isVisibleToUser && this.isInit && this.isCreated) {
            this.isInit = false;
            this.showData();
        }
        if (this.isResumed()) {
            this.statistics(this.getUserVisibleHint());
        }
    }

    public void onPause() {
        super.onPause();
        this.userVisibleController.pause();
        if (this.getUserVisibleHint()) {
            this.statistics(false);
        }
    }

    public void statistics(boolean isStart) {
        if (this.isStatistics()) {
            // empty if block
        }
    }

    protected void cancelAsyncTask(CommonAsyncTask<?, ?, ?> ... asyncTasks) {
        for (CommonAsyncTask<?, ?, ?> asyncTask : asyncTasks) {
            if (asyncTask == null || asyncTask.isCancelled()) continue;
            asyncTask.cancel(true);
        }
    }

    protected abstract void showData();

    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void setupActions(ArrayList<String> actions) {
    }

    @Override
    public void handleUiMessage(Message msg) {
    }

    @Override
    public void handleBroadcast(Context context, Intent intent) {
    }

    protected void sendUiMessage(Message msg) {
        this.mUiHandler.sendMessage(msg);
    }

    protected void sendUiMessageDelayed(Message msg, long delayMillis) {
        this.mUiHandler.sendMessageDelayed(msg, delayMillis);
    }

    protected void sendEmptyUiMessage(int what) {
        this.mUiHandler.sendEmptyMessage(what);
    }

    protected void sendEmptyUiMessageDelayed(int what, long delayMillis) {
        this.mUiHandler.sendEmptyMessageDelayed(what, delayMillis);
    }

    protected void removeUiMessage(int what) {
        this.mUiHandler.removeMessages(what);
    }

    protected Message obtainUiMessage() {
        return this.mUiHandler.obtainMessage();
    }

    public void showToast(final String msg) {
        if (this.getActivity() != null) {
            this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (PlutoFragment.this.toast == null) {
                        PlutoFragment.this.toast = Toast.makeText((Context)PlutoFragment.this.getActivity(), (CharSequence)msg, (int)0);
                    } else {
                        PlutoFragment.this.toast.setText((CharSequence)msg);
                        PlutoFragment.this.toast.setDuration(0);
                    }
                    PlutoFragment.this.toast.show();
                }
            });
        }
    }

    public void showToast(int strResId) {
        String text = this.getString(strResId);
        this.showToast(text);
    }

    protected void hideSoftInput(Context context) {
        InputMethodManager manager = (InputMethodManager)context.getSystemService("input_method");
        if (this.getActivity().getCurrentFocus() != null) {
            manager.hideSoftInputFromWindow(this.getActivity().getCurrentFocus().getWindowToken(), 2);
        }
    }

    public boolean isStatistics() {
        return this.isStatistics;
    }

    public void setStatistics(boolean statistics) {
        this.isStatistics = statistics;
    }

    protected void showSoftInput() {
        InputMethodManager manager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        manager.toggleSoftInput(1, 0);
    }

    @Override
    public void setWaitingShowToUser(boolean waitingShowToUser) {
        this.userVisibleController.setWaitingShowToUser(waitingShowToUser);
    }

    @Override
    public boolean isWaitingShowToUser() {
        return this.userVisibleController.isWaitingShowToUser();
    }

    @Override
    public boolean isVisibleToUser() {
        return this.userVisibleController.isVisibleToUser();
    }

    @Override
    public void callSuperSetUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
    }

    @Override
    public void onVisibleToUserChanged(boolean isVisibleToUser, boolean invokeInResumeOrPause) {
    }

    public boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected(this.getContext());
    }

    private void initLoadingDialog() {
        this.loadingDialog = new PlutoDialog(this.getContext(), 1);
    }

    private static class UiHandler
    extends Handler {
        private final WeakReference<PlutoFragment> mFragmentReference;

        public UiHandler(PlutoFragment activity) {
            this.mFragmentReference = new WeakReference<PlutoFragment>(activity);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (this.mFragmentReference.get() != null) {
                ((PlutoFragment)this.mFragmentReference.get()).handleUiMessage(msg);
            }
        }
    }
}

