/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import com.minggo.pluto.db.orm.ClassUtils;
import com.minggo.pluto.db.orm.DbException;
import com.minggo.pluto.db.orm.FieldUtils;
import com.minggo.pluto.db.orm.Id;
import com.minggo.pluto.db.orm.ManyToOne;
import com.minggo.pluto.db.orm.OneToMany;
import com.minggo.pluto.db.orm.Property;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;

public class TableInfo {
    private String className;
    private String tableName;
    private Id id;
    public final HashMap<String, Property> propertyMap = new HashMap();
    public final HashMap<String, OneToMany> oneToManyMap = new HashMap();
    public final HashMap<String, ManyToOne> manyToOneMap = new HashMap();
    private boolean checkDatabese;
    private static final HashMap<String, TableInfo> tableInfoMap = new HashMap();

    private TableInfo() {
    }

    public static TableInfo get(Class<?> clazz) {
        if (clazz == null) {
            throw new DbException("table info get error,because the clazz is null");
        }
        TableInfo tableInfo = tableInfoMap.get(clazz.getName());
        if (tableInfo == null) {
            List<OneToMany> list;
            List<ManyToOne> mList;
            tableInfo = new TableInfo();
            tableInfo.setTableName(ClassUtils.getTableName(clazz));
            tableInfo.setClassName(clazz.getName());
            Field idField = ClassUtils.getPrimaryKeyField(clazz);
            if (idField == null) {
                throw new DbException("the class[" + clazz + "]'s idField is null , \n you can define _id,id property or use annotation @id to solution this exception");
            }
            Id id2 = new Id();
            id2.setColumn(FieldUtils.getColumnByField(idField));
            id2.setFieldName(idField.getName());
            id2.setSet(FieldUtils.getFieldSetMethod(clazz, idField));
            id2.setGet(FieldUtils.getFieldGetMethod(clazz, idField));
            id2.setDataType(idField.getType());
            tableInfo.setId(id2);
            List<Property> pList = ClassUtils.getPropertyList(clazz);
            if (pList != null) {
                for (Property property : pList) {
                    if (property == null) continue;
                    tableInfo.propertyMap.put(property.getColumn(), property);
                }
            }
            if ((mList = ClassUtils.getManyToOneList(clazz)) != null) {
                for (ManyToOne m : mList) {
                    if (m == null) continue;
                    tableInfo.manyToOneMap.put(m.getColumn(), m);
                }
            }
            if ((list = ClassUtils.getOneToManyList(clazz)) != null) {
                for (OneToMany o : list) {
                    if (o == null) continue;
                    tableInfo.oneToManyMap.put(o.getColumn(), o);
                }
            }
            tableInfoMap.put(clazz.getName(), tableInfo);
        }
        if (tableInfo == null) {
            throw new DbException("the class[" + clazz + "]'s table is null");
        }
        return tableInfo;
    }

    public static TableInfo get(String className) {
        try {
            return TableInfo.get(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id2) {
        this.id = id2;
    }

    public boolean isCheckDatabese() {
        return this.checkDatabese;
    }

    public void setCheckDatabese(boolean checkDatabese) {
        this.checkDatabese = checkDatabese;
    }
}

