/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import com.minggo.pluto.annotation.AutoIncrement;
import com.minggo.pluto.annotation.Exclude;
import com.minggo.pluto.annotation.Primarykey;
import java.lang.reflect.Field;
import java.util.Date;

public class SQLHelper {
    public static final String getCreateTable(String tableName, Class<?> clazz) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE IF NOT EXISTS ");
        sb.append(tableName);
        sb.append("(");
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (field.getAnnotation(Exclude.class) != null) continue;
            if (field.getAnnotation(Primarykey.class) != null) {
                if (field.getAnnotation(AutoIncrement.class) == null) {
                    sb.append(field.getName() + SQLHelper.getTypeText(field) + "PRIMARY KEY NOT NULL,");
                    continue;
                }
                System.out.println("\u8bbe\u7f6e\u4e86\u6570\u636e\u5e93\u9012\u589e\u5b57\u6bb5");
                sb.append(field.getName() + SQLHelper.getTypeText(field) + "PRIMARY KEY autoincrement NOT NULL ,");
                continue;
            }
            if (field.getAnnotation(AutoIncrement.class) == null) {
                sb.append(field.getName() + SQLHelper.getTypeText(field) + ",");
                continue;
            }
            sb.append(field.getName() + SQLHelper.getTypeText(field) + "auto_increment,");
        }
        int indexOf = sb.lastIndexOf(",");
        if (indexOf != -1) {
            sb.deleteCharAt(indexOf);
        }
        sb.append(")");
        return sb.toString();
    }

    private static final String getTypeText(Field field) {
        Class<?> type = field.getType();
        field.setAccessible(true);
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return " INTEGER ";
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return " LONG ";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return " Double ";
        }
        if (type.equals(Date.class)) {
            return " LONG ";
        }
        return " TEXT ";
    }

    public static String getDrapTable(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }
}

