/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.db.orm;

import android.content.ContentValues;
import android.database.Cursor;
import com.minggo.pluto.annotation.AutoIncrement;
import com.minggo.pluto.annotation.Exclude;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;

public final class DaoUtils {
    public static final <T> ContentValues object2ContentValues(T t) {
        ContentValues values = new ContentValues();
        try {
            Field[] fields;
            Class<?> clazz = t.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                Date date;
                field.setAccessible(true);
                if (field.getAnnotation(Exclude.class) != null) continue;
                Class<?> type = field.getType();
                if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    values.put(field.getName(), Integer.valueOf(field.getInt(t)));
                    continue;
                }
                if (type.equals(String.class)) {
                    values.put(field.getName(), String.valueOf(field.get(t)));
                    continue;
                }
                if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                    values.put(field.getName(), Long.valueOf(field.getLong(t)));
                    continue;
                }
                if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                    values.put(field.getName(), Double.valueOf(field.getDouble(t)));
                    continue;
                }
                if (!type.equals(Date.class) || (date = (Date)field.get(t)) == null) continue;
                values.put(field.getName(), Long.valueOf(date.getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static final <T> ContentValues object2ContentValuesWithoutIncrement(T t) {
        ContentValues values = new ContentValues();
        try {
            Field[] fields;
            Class<?> clazz = t.getClass();
            for (Field field : fields = clazz.getDeclaredFields()) {
                Date date;
                field.setAccessible(true);
                if (field.getAnnotation(Exclude.class) != null || field.getAnnotation(AutoIncrement.class) != null) continue;
                Class<?> type = field.getType();
                if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    values.put(field.getName(), Integer.valueOf(field.getInt(t)));
                    continue;
                }
                if (type.equals(String.class)) {
                    values.put(field.getName(), String.valueOf(field.get(t)));
                    continue;
                }
                if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                    values.put(field.getName(), Long.valueOf(field.getLong(t)));
                    continue;
                }
                if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                    values.put(field.getName(), Double.valueOf(field.getDouble(t)));
                    continue;
                }
                if (!type.equals(Date.class) || (date = (Date)field.get(t)) == null) continue;
                values.put(field.getName(), Long.valueOf(date.getTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public static final <T> ArrayList<T> cursor2ObjectList(Cursor cursor, Class<T> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        try {
            if (clazz != null && cursor != null && !cursor.isClosed()) {
                String[] columnNames = cursor.getColumnNames();
                int length = columnNames.length;
                Field[] fields = clazz.getDeclaredFields();
                while (cursor.moveToNext()) {
                    T instance = clazz.newInstance();
                    for (int index = 0; index < length; ++index) {
                        String columnName = columnNames[index];
                        for (Field field : fields) {
                            field.setAccessible(true);
                            if (field.getAnnotation(Exclude.class) != null || !field.getName().equals(columnName)) continue;
                            DaoUtils.setField(cursor, index, instance, field);
                        }
                    }
                    list.add(instance);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static final <T> void setField(Cursor cursor, int columnIndex, T instance, Field field) throws IllegalArgumentException, IllegalAccessException {
        long datetime;
        Class<?> type = field.getType();
        field.setAccessible(true);
        int index = cursor.getColumnIndex(field.getName());
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            field.setInt(instance, cursor.getInt(index));
        } else if (type.equals(String.class)) {
            field.set(instance, cursor.getString(index));
        } else if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            field.setLong(instance, cursor.getLong(index));
        } else if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            field.setDouble(instance, cursor.getDouble(index));
        } else if (type.equals(Date.class) && (datetime = cursor.getLong(index)) > 0L) {
            field.set(instance, new Date(datetime));
        }
    }
}

