/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.common;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import java.util.Stack;

public class AppManager {
    private static final String TAG = AppManager.class.getSimpleName();
    private static Stack<Activity> activityStack;
    private static AppManager instance;

    private AppManager() {
    }

    public static AppManager getAppManager() {
        if (instance == null) {
            instance = new AppManager();
        }
        return instance;
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
        activityStack.remove(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity = null;
        }
    }

    public void removeActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
        }
    }

    public void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
        }
    }

    public int getCountActivity() {
        return activityStack.size();
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    private void cancelAllNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancelAll();
    }
}

