/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.widget.ImageView;
import com.minggo.pluto.Pluto;
import com.minggo.pluto.bitmap.AsyncTask;
import com.minggo.pluto.bitmap.BitmapCache;
import com.minggo.pluto.bitmap.BitmapCommonUtils;
import com.minggo.pluto.bitmap.BitmapDisplayConfig;
import com.minggo.pluto.bitmap.BitmapProcess;
import com.minggo.pluto.bitmap.Displayer;
import com.minggo.pluto.bitmap.Downloader;
import com.minggo.pluto.bitmap.FileNameGenerator;
import com.minggo.pluto.bitmap.SimpleDisplayer;
import com.minggo.pluto.bitmap.SimpleHttpDownloader;
import com.minggo.pluto.util.LogUtils;
import com.minggo.pluto.util.PhotoUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class FinalBitmap {
    private FinalBitmapConfig mConfig;
    private static BitmapCache mImageCache;
    private boolean mExitTasksEarly = false;
    private boolean mPauseWork = false;
    private final Object mPauseWorkLock = new Object();
    private Context mContext;
    private float memerySize;
    private static ExecutorService bitmapLoadAndDisplayExecutor;
    private static FinalBitmap mFinalBitmap;
    private HashMap<String, BitmapDisplayConfig> configMap = new HashMap();
    private LoadFinishListener loadFinishListener;

    private FinalBitmap(Context context) {
        this.mContext = context;
        this.mConfig = new FinalBitmapConfig(context);
        this.configDiskCachePath(BitmapCommonUtils.getDiskCacheDir(context, Pluto.FINAL_BIMAP_SAVE_PATH).getAbsolutePath());
        this.configDisplayer(new SimpleDisplayer());
        this.configDownlader(new SimpleHttpDownloader());
    }

    public static FinalBitmap create(Context ctx) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, float memoryCacheSizePercent) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configMemoryCachePercent(memoryCacheSizePercent);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, int memoryCacheSize) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configMemoryCacheSize(memoryCacheSize);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, float memoryCacheSizePercent, int threadSize) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configBitmapLoadThreadSize(threadSize);
            mFinalBitmap.configMemoryCachePercent(memoryCacheSizePercent);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, int memoryCacheSize, int threadSize) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configBitmapLoadThreadSize(threadSize);
            mFinalBitmap.configMemoryCacheSize(memoryCacheSize);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, float memoryCacheSizePercent, int diskCacheSize, int threadSize) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configBitmapLoadThreadSize(threadSize);
            mFinalBitmap.configMemoryCachePercent(memoryCacheSizePercent);
            mFinalBitmap.configDiskCacheSize(diskCacheSize);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public static FinalBitmap create(Context ctx, String diskCachePath, int memoryCacheSize, int diskCacheSize, int threadSize) {
        if (mFinalBitmap == null) {
            mFinalBitmap = new FinalBitmap(ctx.getApplicationContext());
            mFinalBitmap.configDiskCachePath(diskCachePath);
            mFinalBitmap.configBitmapLoadThreadSize(threadSize);
            mFinalBitmap.configMemoryCacheSize(memoryCacheSize);
            mFinalBitmap.configDiskCacheSize(diskCacheSize);
            mFinalBitmap.init();
        }
        return mFinalBitmap;
    }

    public FinalBitmap configLoadingImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadingImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadingBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configLoadfailImage(Bitmap bitmap) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(bitmap);
        return this;
    }

    public FinalBitmap configLoadfailImage(int resId) {
        this.mConfig.defaultDisplayConfig.setLoadfailBitmap(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resId));
        return this;
    }

    public FinalBitmap configBitmapMaxHeight(int bitmapHeight) {
        this.mConfig.defaultDisplayConfig.setBitmapHeight(bitmapHeight);
        return this;
    }

    public FinalBitmap configBitmapMaxWidth(int bitmapWidth) {
        this.mConfig.defaultDisplayConfig.setBitmapWidth(bitmapWidth);
        return this;
    }

    public FinalBitmap configDownlader(Downloader downlader) {
        this.mConfig.downloader = downlader;
        return this;
    }

    public FinalBitmap configDisplayer(Displayer displayer) {
        this.mConfig.displayer = displayer;
        return this;
    }

    private FinalBitmap configDiskCachePath(String strPath) {
        if (!TextUtils.isEmpty((CharSequence)strPath)) {
            this.mConfig.cachePath = strPath;
        }
        return this;
    }

    private FinalBitmap configMemoryCacheSize(int size) {
        this.mConfig.memCacheSize = size;
        return this;
    }

    private FinalBitmap configMemoryCachePercent(float percent) {
        this.mConfig.memCacheSizePercent = percent;
        return this;
    }

    private FinalBitmap configDiskCacheSize(int size) {
        this.mConfig.diskCacheSize = size;
        return this;
    }

    private FinalBitmap configBitmapLoadThreadSize(int size) {
        if (size >= 1) {
            this.mConfig.poolSize = size;
        }
        return this;
    }

    private FinalBitmap init() {
        this.mConfig.init();
        BitmapCache.ImageCacheParams imageCacheParams = new BitmapCache.ImageCacheParams(this.mConfig.cachePath);
        if ((double)this.mConfig.memCacheSizePercent > 0.05 && (double)this.mConfig.memCacheSizePercent < 0.8) {
            imageCacheParams.setMemCacheSizePercent(this.mContext, this.mConfig.memCacheSizePercent);
        } else if (this.mConfig.memCacheSize > 0x200000) {
            imageCacheParams.setMemCacheSize(this.mConfig.memCacheSize);
        } else {
            imageCacheParams.setMemCacheSizePercent(this.mContext, 0.3f);
        }
        if (this.mConfig.diskCacheSize > 0x500000) {
            imageCacheParams.setDiskCacheSize(this.mConfig.diskCacheSize);
        }
        mImageCache = new BitmapCache(imageCacheParams);
        bitmapLoadAndDisplayExecutor = Executors.newFixedThreadPool(this.mConfig.poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(4);
                return t;
            }
        });
        new CacheExecutecTask().execute(1);
        return this;
    }

    public void display(ImageView imageView, String uri) {
        if (uri != null) {
            this.doDisplay(imageView, uri, null, false, false);
        }
    }

    public void displayRound(ImageView imageView, String uri, BitmapDisplayConfig displayConfig, boolean round) {
        this.doDisplay(imageView, uri, displayConfig, false, round);
    }

    public void display(ImageView imageView, String uri, String bigUrl) {
        String path = BitmapCommonUtils.getDiskCacheDir(this.mContext, Pluto.FINAL_BIMAP_SAVE_PATH).getAbsolutePath() + "/" + FileNameGenerator.generator(bigUrl) + ".0";
        this.doDisplay(imageView, uri, null, false, false);
    }

    private boolean isLessMemory() {
        if (this.memerySize == 0.0f) {
            String str1 = "/proc/meminfo";
            long initial_memory = 0L;
            try {
                FileReader localFileReader = new FileReader(str1);
                BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
                String str2 = localBufferedReader.readLine();
                String[] arrayOfString = str2.split("\\s+");
                initial_memory = Math.abs(Integer.valueOf(arrayOfString[1]) * 1024);
                localBufferedReader.close();
                this.memerySize = initial_memory;
                return !(this.memerySize / 1024.0f / 1024.0f / 1024.0f > 1.0f);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return !(this.memerySize / 1024.0f / 1024.0f / 1024.0f > 1.0f);
    }

    public void displayScale(ImageView imageView, String uri, boolean scale) {
        this.doDisplay(imageView, uri, null, scale, false);
    }

    public void displayScale(ImageView imageView, String uri, BitmapDisplayConfig displayConfig, boolean scale) {
        this.doDisplay(imageView, uri, displayConfig, scale, false);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight) {
        BitmapDisplayConfig displayConfig = this.configMap.get(imageWidth + "_" + imageHeight);
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            this.configMap.put(imageWidth + "_" + imageHeight, displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig, false, false);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(loadingBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            this.configMap.put(String.valueOf(loadingBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig, false, false);
    }

    public void display(ImageView imageView, String uri, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig, false, false);
    }

    public void display(ImageView imageView, String uri, int imageWidth, int imageHeight, Bitmap loadingBitmap, Bitmap laodfailBitmap) {
        BitmapDisplayConfig displayConfig = this.configMap.get(imageWidth + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap));
        if (displayConfig == null) {
            displayConfig = this.getDisplayConfig();
            displayConfig.setBitmapHeight(imageHeight);
            displayConfig.setBitmapWidth(imageWidth);
            displayConfig.setLoadingBitmap(loadingBitmap);
            displayConfig.setLoadfailBitmap(laodfailBitmap);
            this.configMap.put(imageWidth + "_" + imageHeight + "_" + String.valueOf(loadingBitmap) + "_" + String.valueOf(laodfailBitmap), displayConfig);
        }
        this.doDisplay(imageView, uri, displayConfig, true, false);
    }

    public void display(ImageView imageView, String uri, BitmapDisplayConfig config) {
        this.doDisplay(imageView, uri, config, false, false);
    }

    private void doDisplay(ImageView imageView, String uri, BitmapDisplayConfig displayConfig, boolean scale, boolean round) {
        if (TextUtils.isEmpty((CharSequence)uri) || imageView == null) {
            return;
        }
        if (displayConfig == null) {
            displayConfig = this.mConfig.defaultDisplayConfig;
        }
        Bitmap bitmap = null;
        if (mImageCache != null) {
            bitmap = mImageCache.getBitmapFromMemCache(uri);
        }
        if (bitmap != null) {
            if (round) {
                bitmap = PhotoUtil.toRoundBitmap(bitmap);
            }
            imageView.setImageBitmap(bitmap);
        } else if (FinalBitmap.checkImageTask(uri, imageView)) {
            BitmapLoadAndDisplayTask task = new BitmapLoadAndDisplayTask(imageView, displayConfig);
            AsyncDrawable asyncDrawable = new AsyncDrawable(this.mContext.getResources(), displayConfig.getLoadingBitmap(), task);
            imageView.setImageDrawable((Drawable)asyncDrawable);
            task.executeOnExecutor(bitmapLoadAndDisplayExecutor, uri, scale, round);
        }
    }

    private BitmapDisplayConfig getDisplayConfig() {
        BitmapDisplayConfig config = new BitmapDisplayConfig();
        config.setAnimation(this.mConfig.defaultDisplayConfig.getAnimation());
        config.setAnimationType(this.mConfig.defaultDisplayConfig.getAnimationType());
        config.setBitmapHeight(this.mConfig.defaultDisplayConfig.getBitmapHeight());
        config.setBitmapWidth(this.mConfig.defaultDisplayConfig.getBitmapWidth());
        config.setLoadfailBitmap(this.mConfig.defaultDisplayConfig.getLoadfailBitmap());
        config.setLoadingBitmap(this.mConfig.defaultDisplayConfig.getLoadingBitmap());
        return config;
    }

    private void initDiskCacheInternal() {
        if (mImageCache != null) {
            mImageCache.initDiskCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.initHttpDiskCache();
        }
    }

    private void clearCacheInternal() {
        if (mImageCache != null) {
            mImageCache.clearCache();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private void clearMemoryCache() {
        if (mImageCache != null) {
            mImageCache.clearMemoryCache();
        }
    }

    private void flushCacheInternal() {
        if (mImageCache != null) {
            mImageCache.flush();
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.flushCacheInternal();
        }
    }

    private void closeCacheInternal() {
        if (mImageCache != null) {
            mImageCache.close();
            mImageCache = null;
        }
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            this.mConfig.bitmapProcess.clearCacheInternal();
        }
    }

    private Bitmap processBitmap(String uri, BitmapDisplayConfig config) {
        if (this.mConfig != null && this.mConfig.bitmapProcess != null) {
            return this.mConfig.bitmapProcess.processBitmap(uri, config);
        }
        return null;
    }

    public void setExitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
    }

    public void onResume() {
        this.setExitTasksEarly(false);
    }

    public void onPause() {
        this.setExitTasksEarly(true);
        this.flushCache();
    }

    public void onDestroy() {
        this.closeCache();
    }

    public void clearAllCache() {
        new CacheExecutecTask().execute(0);
    }

    public void clearMemeoryCache() {
        new CacheExecutecTask().execute(4);
    }

    public void flushCache() {
        new CacheExecutecTask().execute(2);
    }

    public void closeCache() {
        new CacheExecutecTask().execute(3);
    }

    public void exitTasksEarly(boolean exitTasksEarly) {
        this.mExitTasksEarly = exitTasksEarly;
        if (exitTasksEarly) {
            this.pauseWork(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseWork(boolean pauseWork) {
        Object object = this.mPauseWorkLock;
        synchronized (object) {
            this.mPauseWork = pauseWork;
            if (!this.mPauseWork) {
                this.mPauseWorkLock.notifyAll();
            }
        }
    }

    private static BitmapLoadAndDisplayTask getBitmapTaskFromImageView(ImageView imageView) {
        Drawable drawable2;
        if (imageView != null && (drawable2 = imageView.getDrawable()) instanceof AsyncDrawable) {
            AsyncDrawable asyncDrawable = (AsyncDrawable)drawable2;
            return asyncDrawable.getBitmapWorkerTask();
        }
        return null;
    }

    public static boolean checkImageTask(Object data, ImageView imageView) {
        BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
        if (bitmapWorkerTask != null) {
            Object bitmapData = bitmapWorkerTask.data;
            if (bitmapData == null || !bitmapData.equals(data)) {
                bitmapWorkerTask.cancel(true);
            } else {
                return false;
            }
        }
        return true;
    }

    public static BitmapCache getBitmapCache() {
        return mImageCache;
    }

    public void display(ImageView imageView, String uri, LoadFinishListener listener) {
        if (listener != null) {
            this.loadFinishListener = listener;
        }
        if (uri != null) {
            this.doDisplay(imageView, uri, null, false, false);
        }
    }

    private class FinalBitmapConfig {
        public String cachePath;
        public Displayer displayer;
        public Downloader downloader;
        public BitmapProcess bitmapProcess;
        public BitmapDisplayConfig defaultDisplayConfig = new BitmapDisplayConfig();
        public float memCacheSizePercent;
        public int memCacheSize;
        public int diskCacheSize;
        public int poolSize = 3;
        public int originalDiskCacheSize = 0x1E00000;

        public FinalBitmapConfig(Context context) {
            this.defaultDisplayConfig.setAnimation(null);
            this.defaultDisplayConfig.setAnimationType(1);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int defaultWidth = (int)Math.floor(displayMetrics.widthPixels / 4);
            this.defaultDisplayConfig.setBitmapHeight(defaultWidth);
            this.defaultDisplayConfig.setBitmapWidth(defaultWidth);
        }

        public void init() {
            if (this.downloader == null) {
                this.downloader = new SimpleHttpDownloader();
            }
            if (this.displayer == null) {
                this.displayer = new SimpleDisplayer();
            }
            this.bitmapProcess = new BitmapProcess(this.downloader, this.cachePath, this.originalDiskCacheSize);
        }
    }

    public static interface LoadFinishListener {
        public void loadFinish(ImageView var1);
    }

    private class BitmapLoadAndDisplayTask
    extends AsyncTask<Object, Void, Bitmap> {
        private Object data;
        private final WeakReference<ImageView> imageViewReference;
        private final BitmapDisplayConfig displayConfig;
        boolean scale = false;
        boolean round = false;

        public BitmapLoadAndDisplayTask(ImageView imageView, BitmapDisplayConfig config) {
            this.imageViewReference = new WeakReference<ImageView>(imageView);
            this.displayConfig = config;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Bitmap doInBackground(Object ... params) {
            this.data = params[0];
            String dataString = String.valueOf(this.data);
            Bitmap bitmap = null;
            if (params.length > 1) {
                this.scale = (Boolean)params[1];
            }
            if (params.length > 2) {
                this.round = (Boolean)params[2];
            }
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                while (FinalBitmap.this.mPauseWork && !this.isCancelled()) {
                    try {
                        FinalBitmap.this.mPauseWorkLock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (mImageCache != null && !this.isCancelled() && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly) {
                bitmap = mImageCache.getBitmapFromDiskCache(dataString);
                LogUtils.info("finalbitmap", "mImageCache != null && !isCancelled()");
            }
            if (bitmap == null && !this.isCancelled() && this.getAttachedImageView() != null && !FinalBitmap.this.mExitTasksEarly && (bitmap = FinalBitmap.this.processBitmap(dataString, this.displayConfig)) != null && this.scale) {
                int widthScrean = ((FinalBitmap)FinalBitmap.this).mContext.getApplicationContext().getResources().getDisplayMetrics().widthPixels;
                int imageOrigWidth = bitmap.getWidth();
                int imageOrigHeigh = bitmap.getHeight();
                LogUtils.info("finalbitmap", "\u5bbd\u5ea6-->" + imageOrigWidth + ",--->" + imageOrigHeigh);
                int reSizeHeigh = (int)((double)widthScrean * ((double)imageOrigHeigh / (double)imageOrigWidth));
                LogUtils.info("finalbitmap", "1\u5bbd\u5ea6-->" + widthScrean + ",---1>" + reSizeHeigh);
                bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)widthScrean, (int)reSizeHeigh, (boolean)true);
            }
            if (bitmap != null && mImageCache != null) {
                mImageCache.addBitmapToCache(dataString, bitmap);
            }
            return bitmap;
        }

        @Override
        protected void onPostExecute(Bitmap bitmap) {
            if (this.isCancelled() || FinalBitmap.this.mExitTasksEarly) {
                bitmap = null;
            }
            ImageView imageView = this.getAttachedImageView();
            if (bitmap != null && imageView != null) {
                if (this.round) {
                    bitmap = PhotoUtil.toRoundBitmap(bitmap);
                }
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadCompletedisplay(imageView, bitmap, this.displayConfig);
            } else if (bitmap == null && imageView != null) {
                ((FinalBitmap)FinalBitmap.this).mConfig.displayer.loadFailDisplay(imageView, this.displayConfig.getLoadfailBitmap());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onCancelled(Bitmap bitmap) {
            super.onCancelled(bitmap);
            Object object = FinalBitmap.this.mPauseWorkLock;
            synchronized (object) {
                FinalBitmap.this.mPauseWorkLock.notifyAll();
            }
        }

        private ImageView getAttachedImageView() {
            ImageView imageView = (ImageView)this.imageViewReference.get();
            BitmapLoadAndDisplayTask bitmapWorkerTask = FinalBitmap.getBitmapTaskFromImageView(imageView);
            if (this == bitmapWorkerTask) {
                return imageView;
            }
            return null;
        }
    }

    private class CacheExecutecTask
    extends AsyncTask<Object, Void, Void> {
        public static final int MESSAGE_CLEAR = 0;
        public static final int MESSAGE_INIT_DISK_CACHE = 1;
        public static final int MESSAGE_FLUSH = 2;
        public static final int MESSAGE_CLOSE = 3;
        public static final int MESSAGE_CLEAR_MEMORY = 4;

        private CacheExecutecTask() {
        }

        @Override
        protected Void doInBackground(Object ... params) {
            switch ((Integer)params[0]) {
                case 0: {
                    FinalBitmap.this.clearCacheInternal();
                    break;
                }
                case 1: {
                    FinalBitmap.this.initDiskCacheInternal();
                    break;
                }
                case 2: {
                    FinalBitmap.this.clearMemoryCache();
                    FinalBitmap.this.flushCacheInternal();
                    break;
                }
                case 3: {
                    FinalBitmap.this.clearMemoryCache();
                    FinalBitmap.this.closeCacheInternal();
                    break;
                }
                case 4: {
                    FinalBitmap.this.clearMemoryCache();
                }
            }
            return null;
        }
    }

    private static class AsyncDrawable
    extends BitmapDrawable {
        private final WeakReference<BitmapLoadAndDisplayTask> bitmapWorkerTaskReference;

        public AsyncDrawable(Resources res, Bitmap bitmap, BitmapLoadAndDisplayTask bitmapWorkerTask) {
            super(res, bitmap);
            this.bitmapWorkerTaskReference = new WeakReference<BitmapLoadAndDisplayTask>(bitmapWorkerTask);
        }

        public BitmapLoadAndDisplayTask getBitmapWorkerTask() {
            return (BitmapLoadAndDisplayTask)this.bitmapWorkerTaskReference.get();
        }
    }
}

