/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import com.minggo.pluto.bitmap.BitmapCommonUtils;
import com.minggo.pluto.bitmap.BitmapDecoder;
import com.minggo.pluto.bitmap.BitmapDisplayConfig;
import com.minggo.pluto.bitmap.Downloader;
import com.minggo.pluto.bitmap.FileNameGenerator;
import com.minggo.pluto.bitmap.LruDiskCache;
import com.minggo.pluto.util.LogUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

public class BitmapProcess {
    private static final String TAG = "BitmapProcess";
    private boolean mHttpDiskCacheStarting = true;
    private int cacheSize;
    private static final int DEFAULT_CACHE_SIZE = 0x1400000;
    private LruDiskCache mOriginalDiskCache;
    private final Object mHttpDiskCacheLock = new Object();
    private static final int DISK_CACHE_INDEX = 0;
    private File mOriginalCacheDir;
    private Downloader downloader;

    public BitmapProcess(Downloader downloader, String filePath, int cacheSize) {
        this.mOriginalCacheDir = new File(filePath + "/original");
        this.downloader = downloader;
        if (cacheSize <= 0) {
            cacheSize = 0x1400000;
        }
        this.cacheSize = cacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap processBitmap(String data, BitmapDisplayConfig config) {
        String key = FileNameGenerator.generator(data);
        FileDescriptor fileDescriptor = null;
        FileInputStream fileInputStream = null;
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            while (this.mHttpDiskCacheStarting) {
                try {
                    this.mHttpDiskCacheLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mOriginalDiskCache != null) {
                try {
                    LruDiskCache.Snapshot snapshot = this.mOriginalDiskCache.get(key);
                    if (snapshot == null) {
                        LruDiskCache.Editor editor = this.mOriginalDiskCache.edit(key);
                        if (editor != null) {
                            if (this.downloader.downloadToLocalStreamByUrl(data, editor.newOutputStream(0))) {
                                editor.commit();
                            } else {
                                editor.abort();
                            }
                        }
                        snapshot = this.mOriginalDiskCache.get(key);
                    }
                    if (snapshot != null) {
                        fileInputStream = (FileInputStream)snapshot.getInputStream(0);
                        fileDescriptor = fileInputStream.getFD();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("processBitmap - " + e));
                }
                catch (IllegalStateException e) {
                    Log.e((String)TAG, (String)("processBitmap - " + e));
                }
                finally {
                    if (fileDescriptor == null && fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        Bitmap bitmap = null;
        if (fileDescriptor != null) {
            bitmap = BitmapDecoder.decodeSampledBitmapFromDescriptor(fileDescriptor, config.getBitmapWidth(), config.getBitmapHeight());
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initHttpDiskCache() {
        if (!this.mOriginalCacheDir.exists()) {
            this.mOriginalCacheDir.mkdirs();
        }
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (BitmapCommonUtils.getUsableSpace(this.mOriginalCacheDir) > (long)this.cacheSize) {
                try {
                    this.mOriginalDiskCache = LruDiskCache.open(this.mOriginalCacheDir, 1, 1, this.cacheSize);
                }
                catch (IOException e) {
                    this.mOriginalDiskCache = null;
                }
            }
            this.mHttpDiskCacheStarting = false;
            this.mHttpDiskCacheLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null && !this.mOriginalDiskCache.isClosed()) {
                try {
                    this.mOriginalDiskCache.delete();
                }
                catch (IOException e) {
                    LogUtils.error(TAG, "clearCacheInternal - " + e.toString());
                }
                this.mOriginalDiskCache = null;
                this.mHttpDiskCacheStarting = true;
                this.initHttpDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null) {
                try {
                    this.mOriginalDiskCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCacheInternal() {
        Object object = this.mHttpDiskCacheLock;
        synchronized (object) {
            if (this.mOriginalDiskCache != null) {
                try {
                    if (!this.mOriginalDiskCache.isClosed()) {
                        this.mOriginalDiskCache.close();
                        this.mOriginalDiskCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("closeCacheInternal - " + e));
                }
            }
        }
    }
}

