/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.DimenRes;
import android.view.animation.Animation;
import com.minggo.pluto.util.DisplayUtil;

public class BitmapDisplayConfig {
    private int bitmapWidth;
    private int bitmapHeight;
    private Animation animation;
    private int animationType;
    private Bitmap loadingBitmap;
    private Bitmap loadfailBitmap;

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    public int getAnimationType() {
        return this.animationType;
    }

    public void setAnimationType(int animationType) {
        this.animationType = animationType;
    }

    public Bitmap getLoadingBitmap() {
        return this.loadingBitmap;
    }

    public void setLoadingBitmap(Bitmap loadingBitmap) {
        this.loadingBitmap = loadingBitmap;
    }

    public Bitmap getLoadfailBitmap() {
        return this.loadfailBitmap;
    }

    public void setLoadfailBitmap(Bitmap loadfailBitmap) {
        this.loadfailBitmap = loadfailBitmap;
    }

    public static BitmapDisplayConfig getDefaultUserAvatarConfig(Context context, int bitmapPxSize) {
        BitmapDisplayConfig bitmapDisplayConfig = new BitmapDisplayConfig();
        bitmapDisplayConfig.setAnimationType(1);
        if (bitmapPxSize > 0) {
            bitmapDisplayConfig.setBitmapWidth(bitmapPxSize);
            bitmapDisplayConfig.setBitmapHeight(bitmapPxSize);
        }
        return bitmapDisplayConfig;
    }

    public static BitmapDisplayConfig getDefaultUserAvatarConfigByDp(Context context, int dp) {
        int dp2px = DisplayUtil.dip2px(context, dp);
        return BitmapDisplayConfig.getDefaultUserAvatarConfig(context, dp2px);
    }

    public static BitmapDisplayConfig getDefaultUserAvatarConfigByDpRes(Context context, @DimenRes int dpRes) {
        int dp2px = context.getResources().getDimensionPixelSize(dpRes);
        return BitmapDisplayConfig.getDefaultUserAvatarConfig(context, dp2px);
    }

    public class AnimationType {
        public static final int userDefined = 0;
        public static final int fadeIn = 1;
    }
}

