/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.api;

import android.os.Handler;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.minggo.pluto.api.ApiClient;
import com.minggo.pluto.api.ApiUrl;
import com.minggo.pluto.common.AppContext;
import com.minggo.pluto.common.PlutoException;
import com.minggo.pluto.db.manager.DataManagerProxy;
import com.minggo.pluto.model.Result;
import com.minggo.pluto.util.EncryptUtils;
import com.minggo.pluto.util.LogUtils;
import com.minggo.pluto.util.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;

public class PlutoApiEngine {
    public static Map<String, Object> addRequiredParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AppContext appContext = AppContext.getInstance();
        int versionCode = appContext.getPackageInfo().versionCode;
        String mid = appContext.getAndroidId(0);
        String imei = appContext.getAndroidIMEI();
        String m_ver = appContext.GetMobileVersion();
        String s_ver = appContext.GetAndroidVersion();
        String versionName = appContext.getPackageInfo().versionName;
        String systemTime = String.valueOf(System.currentTimeMillis());
        String timestamp = systemTime.length() < 10 ? systemTime : systemTime.substring(0, 10);
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.SHAREPREFERENCE);
        String imeiTime = dataManagerProxy.queryByNameAndKey("USER_CONFIG", "imeiTime", String.class);
        if (TextUtils.isEmpty((CharSequence)imeiTime)) {
            imeiTime = timestamp;
            dataManagerProxy.saveByNameAndKey("USER_CONFIG", "imeiTime", imeiTime);
        }
        LogUtils.info("imeiTime-->" + imeiTime);
        try {
            String md5pass = new EncryptUtils().getMD5Str(imei + versionCode + timestamp + ApiUrl.MD5KEY);
            params.put("pass", md5pass);
            params.put("mid", mid);
            params.put("imei", imei);
            params.put("timestamp", timestamp);
            params.put("imeiTime", imeiTime);
            params.put("versionCode", versionCode);
            params.put("versionName", versionName);
            params.put("m_ver", URLEncoder.encode(m_ver, "utf-8"));
            params.put("s_ver", URLEncoder.encode(s_ver, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return params;
    }

    public static Map<String, Object> addRequiredParamByPost() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        AppContext appContext = AppContext.getInstance();
        int versionCode = appContext.getPackageInfo().versionCode;
        String mid = appContext.getAndroidId(0);
        String imei = appContext.getAndroidIMEI();
        String m_ver = appContext.GetMobileVersion();
        String s_ver = appContext.GetAndroidVersion();
        String versionName = appContext.getPackageInfo().versionName;
        String timestamp = String.valueOf(System.currentTimeMillis()).substring(0, 10);
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.SHAREPREFERENCE);
        String imeiTime = dataManagerProxy.queryByNameAndKey("USER_CONFIG", "imeiTime", String.class);
        if (TextUtils.isEmpty((CharSequence)imeiTime)) {
            imeiTime = timestamp;
            dataManagerProxy.saveByNameAndKey("USER_CONFIG", "imeiTime", imeiTime);
        }
        LogUtils.info("imeiTime-->" + imeiTime);
        try {
            String md5pass = new EncryptUtils().getMD5Str(imei + versionCode + timestamp + ApiUrl.MD5KEY);
            params.put("pass", md5pass);
            params.put("mid", mid);
            params.put("imei", imei);
            params.put("timestamp", timestamp);
            params.put("imeiTime", imeiTime);
            params.put("versionCode", versionCode);
            params.put("versionName", versionName);
            params.put("m_ver", URLEncoder.encode(m_ver, "utf-8"));
            params.put("s_ver", URLEncoder.encode(s_ver, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return params;
    }

    public static <T> List<T> getListByCacheAdvance(String url, Map<String, Object> params, String key, Handler handler, int msgWhat, Class<T> clazz) {
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.FILECACHE);
        Gson gson = new Gson();
        String cacheContent = null;
        List<Object> list = new ArrayList<Object>();
        try {
            cacheContent = dataManagerProxy.queryData(key, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!StringUtils.isEmpty(cacheContent) && cacheContent.contains("[") && cacheContent.contains("]")) {
            try {
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(cacheContent);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        list.add(gson.fromJson(jsonArray.getString(i), clazz));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (list != null) {
                    handler.obtainMessage(msgWhat, list).sendToTarget();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return null;
        }
        Result result = null;
        try {
            result = ApiClient.httpGetList(url, params);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        if (!result.success || result.content == null || ((List)result.content).equals("")) {
            return null;
        }
        if (result.content != null) {
            if (clazz == String.class || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Long.TYPE) {
                list = (List)result.content;
            } else {
                String jsonlist = gson.toJson(result.content);
                ArrayList<Object> tList = new ArrayList<Object>();
                if (!StringUtils.isEmpty(jsonlist) && jsonlist.contains("[") && jsonlist.contains("]")) {
                    try {
                        JSONArray jsonArray = null;
                        try {
                            jsonArray = new JSONArray(jsonlist);
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                tList.add(gson.fromJson(jsonArray.getString(i), clazz));
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        if (tList != null) {
                            list = tList;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        try {
            dataManagerProxy.saveData(key, gson.toJson(result.content));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <T> List<T> getListByLimitTime(String url, Map<String, Object> params, String key, Handler handler, int msgWhat, int hour, Class<T> clazz) {
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.FILECACHE);
        Gson gson = new Gson();
        String cacheContent = null;
        List<Object> list = new ArrayList<Object>();
        try {
            cacheContent = dataManagerProxy.queryData(key, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!StringUtils.isEmpty(cacheContent) && cacheContent.contains("[") && cacheContent.contains("]")) {
            try {
                try {
                    JSONArray jsonArray = new JSONArray(cacheContent);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        list.add(gson.fromJson(jsonArray.getString(i), clazz));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (!list.isEmpty() && !dataManagerProxy.isExpiredFile(key, 60 * hour)) {
                    handler.obtainMessage(msgWhat, list).sendToTarget();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (StringUtils.isEmpty(cacheContent) || !cacheContent.contains("[") && !cacheContent.contains("]") || dataManagerProxy.isExpiredFile(key, 60 * hour)) {
            if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
                return null;
            }
            Result result = null;
            try {
                result = ApiClient.httpGetList(url, params);
            }
            catch (PlutoException e) {
                e.printStackTrace();
            }
            if (result == null) {
                return null;
            }
            if (!result.success || result.content == null || result.content.equals("")) {
                return null;
            }
            if (result.content != null) {
                if (clazz == String.class || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Long.TYPE) {
                    list = (List)result.content;
                } else {
                    String jsonlist = gson.toJson(result.content);
                    ArrayList<Object> tList = new ArrayList<Object>();
                    if (!StringUtils.isEmpty(jsonlist) && jsonlist.contains("[") && jsonlist.contains("]")) {
                        try {
                            JSONArray jsonArray = null;
                            try {
                                jsonArray = new JSONArray(jsonlist);
                                for (int i = 0; i < jsonArray.length(); ++i) {
                                    tList.add(gson.fromJson(jsonArray.getString(i), clazz));
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            if (tList != null) {
                                list = tList;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            try {
                dataManagerProxy.saveData(key, gson.toJson(result.content));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static <T> List<T> getListByNoCache(String url, Map<String, Object> params, Class<T> clazz) {
        Gson gson = new Gson();
        List list = new ArrayList();
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return list;
        }
        Result result = null;
        try {
            result = ApiClient.httpGetList(url, params);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return list;
        }
        if (!result.success || result.content == null || ((List)result.content).equals("")) {
            return list;
        }
        if (result.content != null) {
            if (clazz == String.class || clazz == Integer.TYPE || clazz == Float.TYPE || clazz == Long.TYPE) {
                list = (List)result.content;
            } else {
                String jsonlist = gson.toJson(result.content);
                ArrayList<Object> tList = new ArrayList<Object>();
                if (!StringUtils.isEmpty(jsonlist) && jsonlist.contains("[") && jsonlist.contains("]")) {
                    try {
                        JSONArray jsonArray = null;
                        try {
                            jsonArray = new JSONArray(jsonlist);
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                tList.add(gson.fromJson(jsonArray.getString(i), clazz));
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                        if (tList != null) {
                            list = tList;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return list;
    }

    public static <T> T getModelByCacheAdvance(String url, Map<String, Object> params, String key, Handler handler, int msgWhat, Class<T> clazz) {
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.FILECACHE);
        Gson gson = new Gson();
        String cacheContent = null;
        Object t = null;
        try {
            cacheContent = dataManagerProxy.queryData(key, String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!StringUtils.isEmpty(cacheContent)) {
            try {
                t = gson.fromJson(cacheContent, clazz);
                if (t != null) {
                    handler.obtainMessage(msgWhat, t).sendToTarget();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return null;
        }
        Result result = null;
        try {
            result = ApiClient.httpGetModel(url, params, true);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        if (!result.success || result.content == null || result.content.equals("")) {
            return null;
        }
        try {
            t = gson.fromJson(gson.toJson(result.content), clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            dataManagerProxy.saveData(key, gson.toJson(result.content));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static <T> T getModelByGetLimitTime(String url, Map<String, Object> params, String key, Handler handler, int msgWhat, int hour, Class<T> clazz) {
        DataManagerProxy dataManagerProxy = new DataManagerProxy(DataManagerProxy.DataType.FILECACHE);
        Gson gson = new Gson();
        String cacheContent = null;
        Object t = null;
        try {
            cacheContent = dataManagerProxy.queryData(key, String.class);
            t = StringUtils.isEmpty(cacheContent) ? null : gson.fromJson(cacheContent, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (t != null) {
            if (!dataManagerProxy.isExpiredFile(key, hour * 60)) {
                handler.obtainMessage(msgWhat, t).sendToTarget();
            }
        } else if (t == null || dataManagerProxy.isExpiredFile(key, hour * 60)) {
            if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
                return (T)t;
            }
            Result result = null;
            try {
                result = ApiClient.httpGetModel(url, params, true);
            }
            catch (PlutoException e) {
                e.printStackTrace();
            }
            if (result == null) {
                return (T)t;
            }
            if (!result.success || result.content == null || result.content.equals("")) {
                return (T)t;
            }
            try {
                t = gson.fromJson(gson.toJson(result.content), clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                dataManagerProxy.saveData(key, gson.toJson(result.content));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)t;
    }

    public static <T> T getModelByNoCache(String url, Map<String, Object> params, Class<T> clazz) {
        Gson gson = new Gson();
        Object t = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return (T)t;
        }
        Result result = null;
        try {
            result = ApiClient.httpGetModel(url, params, true);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return (T)t;
        }
        if (!result.success || result.content == null || result.content.equals("")) {
            return (T)t;
        }
        try {
            t = gson.fromJson(gson.toJson(result.content), clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static Result getResultOnly(String url, Map<String, Object> params) {
        Result result = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return null;
        }
        try {
            result = ApiClient.httpGetModel(url, params, true);
            params = null;
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public static Result postFilesResult(String url, Map<String, Object> params, Map<String, File> files) {
        Result result = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return null;
        }
        try {
            result = ApiClient.httpPostModel(url, params, files, false);
            params = null;
            files = null;
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        if (!result.success || result.content == null || result.content.equals("")) {
            return null;
        }
        return result;
    }

    public static <T> T postModelUploadFiles(String url, Map<String, Object> params, Map<String, File> files, Class<T> clazz) {
        Gson gson = new Gson();
        Object t = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return (T)t;
        }
        Result result = null;
        try {
            result = ApiClient.httpPostModel(url, params, files, false);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return (T)t;
        }
        if (!result.success || result.content == null) {
            return (T)t;
        }
        try {
            t = gson.fromJson(gson.toJson(result.content), clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static Result postResult(String url, Map<String, Object> params) {
        Result result = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return null;
        }
        try {
            result = ApiClient.httpPostModel(url, params, null, false);
            params = null;
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return null;
        }
        if (!result.success) {
            return null;
        }
        return result;
    }

    public static <T> T postModelByNoCache(String url, Map<String, Object> params, Class<T> clazz) {
        Gson gson = new Gson();
        Object t = null;
        if (!AppContext.isNetworkConnected(AppContext.getInstance().context)) {
            return (T)t;
        }
        Result result = null;
        try {
            result = ApiClient.httpPostModel(url, params, null, false);
        }
        catch (PlutoException e) {
            e.printStackTrace();
        }
        if (result == null) {
            return (T)t;
        }
        if (!result.success || result.content == null) {
            return (T)t;
        }
        try {
            t = gson.fromJson(gson.toJson(result.content), clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)t;
    }
}

