/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import com.minggo.pluto.util.LogUtils;

public class PollingUtils {
    public static void startPollingService(Context context, int seconds, Class<?> cls, String action) {
        LogUtils.info(String.format("cls:%s|action:%s|seconds:%d", cls + "", action, seconds));
        AlarmManager manager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, cls);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        long triggerAtTime = SystemClock.elapsedRealtime();
        manager.setRepeating(2, triggerAtTime, (long)(seconds * 1000), pendingIntent);
    }

    public static void stopPollingService(Context context, Class<?> cls, String action) {
        LogUtils.info(String.format("cls:%s|action:%s", cls + "", action));
        AlarmManager manager = (AlarmManager)context.getSystemService("alarm");
        Intent intent = new Intent(context, cls);
        intent.setAction(action);
        PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0x8000000);
        manager.cancel(pendingIntent);
    }
}

