/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import com.minggo.pluto.Pluto;
import com.minggo.pluto.db.manager.DataManagerStub;
import com.minggo.pluto.util.FileUtils;
import com.minggo.pluto.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PlutoFileCache
extends DataManagerStub {
    static PlutoFileCache cacheUtils;

    private PlutoFileCache() {
    }

    public static PlutoFileCache getInstance() {
        if (null == cacheUtils) {
            cacheUtils = new PlutoFileCache();
        }
        return cacheUtils;
    }

    public boolean isCacheDataFailure(String key, int cache_time_min) {
        boolean failure = false;
        File data = new File(Pluto.SDPATH + "cache/cache_" + key + ".data");
        if (data.exists() && System.currentTimeMillis() - data.lastModified() > (long)(cache_time_min *= 60000)) {
            failure = true;
        } else if (!data.exists()) {
            failure = true;
        }
        LogUtils.info("reader", data.getPath() + "\u6587\u4ef6\u662f\u5426\u5931\u6548====>" + failure);
        return failure;
    }

    public boolean isCacheDataFailurePath(String path, int cache_time_min) {
        boolean failure = false;
        File data = new File(path);
        if (data.exists() && System.currentTimeMillis() - data.lastModified() > (long)(cache_time_min *= 60000)) {
            failure = true;
        } else if (!data.exists()) {
            failure = true;
        }
        LogUtils.info("reader", path + "\u6587\u4ef6\u662f\u5426\u5931\u6548====>" + failure);
        return failure;
    }

    public void setDiskCache(String key, String value) throws IOException {
        FileUtils.WriterTxtFile(Pluto.SDPATH + "cache/", "cache_" + key + ".data", value, false);
    }

    public String getDiskCache(String key) {
        String content = null;
        try {
            content = FileUtils.ReadTxtFile(Pluto.SDPATH + "cache/cache_" + key + ".data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public String removeDiskCache(String key) {
        String content = null;
        try {
            content = FileUtils.RemoveTxtFile(Pluto.SDPATH + "cache/cache_" + key + ".data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    public List<File> getAllDiskCacheFile() {
        ArrayList<File> allFiles = new ArrayList<File>();
        File cacheDir = new File(Pluto.SDPATH + "cache/");
        if (cacheDir.exists()) {
            File[] files;
            for (File file : files = cacheDir.listFiles()) {
                String fileName = file.getName();
                if (!fileName.startsWith("cache_") || !fileName.endsWith(".data")) continue;
                allFiles.add(file);
            }
        }
        return allFiles;
    }

    public File getDiskCacheFile(String key) {
        return new File(Pluto.SDPATH + "cache/cache_" + key + ".data");
    }

    @Override
    public void saveData(Object key, Object object) {
        super.saveData(key, object);
        try {
            this.setDiskCache(key.toString(), object.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public <T> T queryData(Object key, Class<T> clazz) {
        return (T)this.getDiskCache(key.toString());
    }

    @Override
    public <T> void deleteData(Object key, Class<T> clazz) {
        super.deleteData(key, clazz);
        this.removeDiskCache(key.toString());
    }

    @Override
    public void updateData(Object key, Object object) {
        super.updateData(key, object);
        this.saveData(key, object);
    }
}

