/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.util;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYY_MM_DD_HH_MM = "yyyy-MM-dd HH:mm";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());

    public static Date stringToDateTime(String s) {
        if (null == s) {
            return new Date();
        }
        String pattern = s.matches("\\d{4}-\\d{2}-\\d{2}") ? YYYY_MM_DD : (s.matches("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}") ? YYYY_MM_DD_HH_MM_SS : YYYY_MM_DD_HH_MM);
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, Locale.getDefault());
        try {
            return sdf.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTime(Date date) {
        TimeZone t = TimeZone.getTimeZone("GMT+08:00");
        Calendar calendar = Calendar.getInstance(t);
        if (date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            calendar.setTime(date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int ss = calendar.get(13);
        int ms = calendar.get(14);
        String time = year + "-" + (month < 10 ? "0" : "") + month + '-' + (day < 10 ? "0" : "") + day + ' ' + (hour < 10 ? "0" : "") + hour + ':' + (min < 10 ? "0" : "") + min + ":" + (ss < 10 ? "0" : "") + ss;
        return time;
    }

    public static String getTimes(Date date) {
        TimeZone t = TimeZone.getTimeZone("GMT+08:00");
        Calendar calendar = Calendar.getInstance(t);
        if (date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            calendar.setTime(date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int ss = calendar.get(13);
        int ms = calendar.get(14);
        String time = year + "-" + (month < 10 ? "0" : "") + month + '-' + (day < 10 ? "0" : "") + day + ' ' + (hour < 10 ? "0" : "") + hour + ':' + (min < 10 ? "0" : "") + min + ":" + (ss < 10 ? "0" : "") + ss + "." + (ms < 10 ? "00" : (ms < 100 ? "0" : "")) + ms;
        return time;
    }

    public static String getDay(Date date) {
        TimeZone t = TimeZone.getTimeZone("GMT+08:00");
        Calendar calendar = Calendar.getInstance(t);
        if (date == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            calendar.setTime(date);
        }
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String time = year + "-" + (month < 10 ? "0" : "") + month + '-' + (day < 10 ? "0" : "") + day;
        return time;
    }

    public static SimpleDateFormat getSimpleDateFormat(String template) {
        simpleDateFormat.applyPattern(template);
        return simpleDateFormat;
    }

    public static String getThisDateTime() {
        return DateUtil.getSimpleDateFormat(YYYY_MM_DD_HH_MM_SS).format(System.currentTimeMillis());
    }

    public static String convert_before(String datetime) {
        if (TextUtils.isEmpty((CharSequence)datetime)) {
            return "";
        }
        try {
            long time = DateUtil.getSimpleDateFormat(YYYY_MM_DD_HH_MM).parse(datetime).getTime();
            return DateUtil.convert_before(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String convert_before(long time) {
        if (time < 0L) {
            return String.valueOf(time);
        }
        int diffTime = (int)((System.currentTimeMillis() - time) / 1000L);
        if (diffTime < 86400 && diffTime > 0) {
            if (diffTime < 3600) {
                int min = diffTime / 60;
                if (min == 0) {
                    return "\u521a\u521a";
                }
                return diffTime / 60 + "\u5206\u949f\u524d";
            }
            return diffTime / 3600 + "\u5c0f\u65f6\u524d";
        }
        Calendar now = Calendar.getInstance();
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        if (c.get(1) == now.get(1) && c.get(2) == now.get(2) && c.get(5) == now.get(5)) {
            return DateUtil.getSimpleDateFormat("HH:mm").format(c.getTime());
        }
        return DateUtil.dateInterval(now.getTime().getTime(), c.getTime().getTime()) + "\u5929\u524d";
    }

    public static int dateInterval(long date1, long date2) {
        if (date2 > date1) {
            date2 += date1;
            date1 = date2 - date1;
            date2 -= date1;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTimeInMillis(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTimeInMillis(date2);
        int y1 = calendar1.get(1);
        int y2 = calendar2.get(1);
        int d1 = calendar1.get(6);
        int d2 = calendar2.get(6);
        int maxDays = 0;
        int day = 0;
        day = y1 - y2 > 0 ? DateUtil.numerical(maxDays, d1, d2, y1, y2, calendar2) : d1 - d2;
        return day;
    }

    public static int numerical(int maxDays, int d1, int d2, int y1, int y2, Calendar calendar) {
        int i;
        int day = d1 - d2;
        int betweenYears = y1 - y2;
        ArrayList<Integer> d366 = new ArrayList<Integer>();
        if (calendar.getActualMaximum(6) == 366) {
            System.out.println(calendar.getActualMaximum(6));
            ++day;
        }
        for (i = 0; i < betweenYears; ++i) {
            calendar.set(1, calendar.get(1) + 1);
            maxDays = calendar.getActualMaximum(6);
            if (maxDays != 366) {
                day += maxDays;
            } else {
                d366.add(maxDays);
            }
            if (i != betweenYears - 1 || betweenYears <= 1 || maxDays != 366) continue;
            --day;
        }
        for (i = 0; i < d366.size(); ++i) {
            if (d366.size() < 1) continue;
            day += ((Integer)d366.get(i)).intValue();
        }
        return day;
    }

    public static long getUnixTimestampByCurrentDate() {
        return DateUtil.getUnixTimestampByDate(new Date());
    }

    public static long getUnixTimestampByDate(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date getDateByUnixTimestamp(long unixTimestamp) {
        return new Date(unixTimestamp * 1000L);
    }
}

