/*
 * Decompiled with CFR 0.152.
 */
package com.minggo.pluto.logic;

import android.os.Handler;
import com.minggo.pluto.api.PlutoApiEngine;
import com.minggo.pluto.common.CommonAsyncTask;
import com.minggo.pluto.model.Result;
import com.minggo.pluto.util.LogUtils;
import java.util.HashMap;
import java.util.Map;

public class LogicManager
extends CommonAsyncTask<Object, Void, Object> {
    public static final String TAG = "LOGICMANAGER";
    private int what;
    private int arg1;
    private int arg2;
    private String url;
    private String cacheKey;
    private int limitedTime;
    private Handler handler;
    private Class clazz;
    private ReturnDataType returnDataType;
    private LogicType logicType;
    private NetworkRequestType networkRequestType;
    private Map<String, Object> requestParam;

    public <T> LogicManager(Handler handler, Class<T> clazz, LogicManagerType logicManagerType) {
        this.handler = handler;
        this.clazz = clazz;
        this.splitEnum(logicManagerType);
        this.requestParam = new HashMap<String, Object>();
    }

    private void splitEnum(LogicManagerType logicManagerType) {
        String[] logicManagerTypeList = logicManagerType.toString().split("__");
        this.networkRequestType = NetworkRequestType.valueOf(logicManagerTypeList[0]);
        this.returnDataType = ReturnDataType.valueOf(logicManagerTypeList[1]);
        this.logicType = LogicType.valueOf(logicManagerTypeList[2]);
    }

    public LogicManager setParamClass(Class clazz) {
        try {
            this.what = clazz.getDeclaredField("WHAT").getInt(clazz);
            LogUtils.info(TAG, ">>>>what=" + this.what);
            this.url = clazz.getDeclaredField("URL").get(clazz).toString();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this;
    }

    private LogicManager setWhat(int what) {
        this.what = what;
        return this;
    }

    public LogicManager setArg1(int arg1) {
        this.arg1 = arg1;
        return this;
    }

    public LogicManager setArg2(int arg2) {
        this.arg2 = arg2;
        return this;
    }

    private LogicManager setUrl(String url) {
        this.url = url;
        return this;
    }

    public LogicManager setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public LogicManager setLimitedTime(int limitedTime) {
        this.limitedTime = limitedTime;
        return this;
    }

    public LogicManager setParam(String key, Object object) {
        this.requestParam.put(key, object);
        return this;
    }

    public LogicManager setParam(Map<String, Object> param) {
        this.requestParam.putAll(param);
        return this;
    }

    @Override
    protected Object doInBackground(Object[] params) {
        Map<String, Object> param = this.getRequestParam();
        if (!this.requestParam.isEmpty()) {
            param.putAll(this.requestParam);
        }
        Object object = null;
        this.innerDoInBackgroundPre();
        object = this.startEngine(param);
        this.innerDoInBackgroundEnd(object);
        return object;
    }

    private <T> T startEngine(Map<String, Object> param) {
        if (this.networkRequestType == NetworkRequestType.GET) {
            if (this.returnDataType == ReturnDataType.LIST) {
                if (this.logicType == LogicType.CACHE_ADVANCE_AND_NETWORK_RETURN) {
                    return (T)PlutoApiEngine.getListByCacheAdvance(this.url, param, this.cacheKey, this.handler, this.what, this.clazz);
                }
                if (this.logicType == LogicType.ONLY_NETWORK) {
                    return (T)PlutoApiEngine.getListByNoCache(this.url, param, this.clazz);
                }
                if (this.logicType == LogicType.CACHE_EXPIRED_AND_NETWORK_RETURN) {
                    return (T)PlutoApiEngine.getListByLimitTime(this.url, param, this.cacheKey, this.handler, this.what, this.limitedTime, this.clazz);
                }
            } else if (this.returnDataType == ReturnDataType.MODEL) {
                if (this.clazz == Result.class) {
                    Result result = PlutoApiEngine.getResultOnly(this.url, param);
                    return (T)result;
                }
                if (this.logicType == LogicType.CACHE_ADVANCE_AND_NETWORK_RETURN) {
                    return PlutoApiEngine.getModelByCacheAdvance(this.url, param, this.cacheKey, this.handler, this.what, this.clazz);
                }
                if (this.logicType == LogicType.ONLY_NETWORK) {
                    return PlutoApiEngine.getModelByNoCache(this.url, param, this.clazz);
                }
                if (this.logicType == LogicType.CACHE_EXPIRED_AND_NETWORK_RETURN) {
                    return PlutoApiEngine.getModelByGetLimitTime(this.url, param, this.cacheKey, this.handler, this.what, this.limitedTime, this.clazz);
                }
            }
        } else if (this.networkRequestType == NetworkRequestType.POST) {
            if (this.returnDataType == ReturnDataType.LIST) {
                LogUtils.error(TAG, "\u901a\u8fc7post\u83b7\u53d6List\u6682\u4e0d\u652f\u6301\uff0c\u53ef\u4ee5\u81ea\u884c\u6269\u5c55");
            } else if (this.returnDataType == ReturnDataType.MODEL) {
                if (this.clazz == Result.class) {
                    return (T)PlutoApiEngine.postResult(this.url, param);
                }
                if (this.logicType == LogicType.CACHE_ADVANCE_AND_NETWORK_RETURN) {
                    LogUtils.error(TAG, "\u901a\u8fc7post\u83b7\u53d6CACHE_ADVANCE_AND_NETWORK_RETURN\u6682\u4e0d\u652f\u6301\uff0c\u53ef\u4ee5\u81ea\u884c\u6269\u5c55");
                } else {
                    if (this.logicType == LogicType.ONLY_NETWORK) {
                        return PlutoApiEngine.postModelByNoCache(this.url, param, this.clazz);
                    }
                    if (this.logicType == LogicType.CACHE_EXPIRED_AND_NETWORK_RETURN) {
                        LogUtils.error(TAG, "\u901a\u8fc7post\u83b7\u53d6CACHE_EXPIRED_AND_NETWORK_RETURN\u6682\u4e0d\u652f\u6301\uff0c\u53ef\u4ee5\u81ea\u884c\u6269\u5c55");
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected void onPostExecute(Object o) {
        super.onPostExecute(o);
        this.handler.obtainMessage(this.what, this.arg1, this.arg2, o).sendToTarget();
    }

    private Map<String, Object> getRequestParam() {
        Map<String, Object> param = null;
        switch (this.networkRequestType) {
            case GET: {
                param = PlutoApiEngine.addRequiredParam();
                break;
            }
            case POST: {
                param = PlutoApiEngine.addRequiredParamByPost();
                break;
            }
        }
        return param;
    }

    protected void innerDoInBackgroundPre() {
    }

    protected void innerDoInBackgroundEnd(Object object) {
    }

    public static enum LogicManagerType {
        GET__MODEL__CACHE_ADVANCE_AND_NETWORK_RETURN,
        GET__MODEL__CACHE_EXPIRED_AND_NETWORK_RETURN,
        GET__MODEL__ONLY_NETWORK,
        POST__MODEL__CACHE_ADVANCE_AND_NETWORK_RETURN,
        POST__MODEL__CACHE_EXPIRED_AND_NETWORK_RETURN,
        POST__MODEL__ONLY_NETWORK,
        GET__LIST__CACHE_ADVANCE_AND_NETWORK_RETURN,
        GET__LIST__CACHE_EXPIRED_AND_NETWORK_RETURN,
        GET__LIST__ONLY_NETWORK,
        POST__LIST__CACHE_ADVANCE_AND_NETWORK_RETURN,
        POST__LIST__CACHE_EXPIRED_AND_NETWORK_RETURN,
        POST__LIST__ONLY_NETWORK;

    }

    public static enum ReturnDataType {
        MODEL,
        LIST;

    }

    public static enum NetworkRequestType {
        POST,
        GET;

    }

    public static enum LogicType {
        CACHE_ADVANCE_AND_NETWORK_RETURN,
        CACHE_EXPIRED_AND_NETWORK_RETURN,
        ONLY_NETWORK;

    }
}

